library(ggplot2)
library(stringr)

# Read in GO file
go1_resv2_results <- read.csv("./resv2_go1_clean.csv")
go1_resv2_results <- go1_resv2_results[!apply(is.na(go1_resv2_results) | 
                                                go1_resv2_results == "", 1, all),] # remove empty rows
View(go1_resv2_results)

# Make GO table
go1_resv2_results$go_process <- factor(go1_resv2_results$go_process, 
                        levels = go1_resv2_results$go_process[order(go1_resv2_results$fold_enrichment)])

tiff("./resv2_go1.tiff", units="in", width=10, height=4, res=300)
ggplot(go1_resv2_results, aes(x = fold_enrichment, y =go_process, color=fdr, size=found)) + 
  geom_point() + labs(x = "Fold Enrichment", y = "GO Term") + 
  guides(size = guide_legend(title = "Genes Found")) + xlim(-5, 40) + 
  theme_minimal()  +  theme(axis.text.x=element_text(size = 10),
                            axis.text.y = element_text(size = 12),
                            axis.title = element_text(size = 15))
dev.off()