#!/bin/bash -x

# Process CiBER-seq sequencing reads from fastq.gz to a table of barcode counts

#Run Cutadapt on the iRFP barcodes

#Cut constant on 3'end
for sample in Rep1_iRFP_pre Rep1_iRFP_post Rep2_iRFP_pre Rep2_iRFP_post Rep3_iRFP_pre Rep3_iRFP_post
do
        cutadapt -j 30 -a ACGAATTTCGACCTTTACGTGCTAACA -m 68 ./${sample}.fastq.gz > ./${sample}_Cut1.fastq
done

#Cut constant on 5'end
for sample in Rep1_iRFP_pre Rep1_iRFP_post Rep2_iRFP_pre Rep2_iRFP_post Rep3_iRFP_pre Rep3_iRFP_post
do
        cutadapt -j 30 -g GCTGTCGAGATCCAGTCCG -m 50 ./${sample}_Cut1.fastq > ./${sample}_Cut2.fastq
done

#Now should be left with UMI-constant-barcode only

#Run Cutadapt on the mCherry barcodes

#Cut constant on 3'end
for sample in Rep1_mCherry_pre Rep1_mCherry_post Rep2_mCherry_pre Rep2_mCherry_post Rep3_mCherry_pre Rep3_mCherry_post
do
        cutadapt -j 30 -a GAGGCAATGCAAAGTGACTCGACTGGT -m 68 ./${sample}.fastq.gz > ./${sample}Cut1.fastq
done

#Cut constant on 5'end
for sample in Rep1_mCherry_pre Rep1_mCherry_post Rep2_mCherry_pre Rep2_mCherry_post Rep3_mCherry_pre Rep3_mCherry_post
do
        cutadapt -j 30 -g GCAGAAGTGGTCCTGCAAC -m 50 ./${sample}Cut1.fastq > ./${sample}Cut2.fastq
done

#Now should be left with UMI-constant-barcode only

#Run Cutadapt on the Cut2 fastq files to remove the umi and constant

#Cut constant on 3'end
for sample in Rep1_iRFP_pre Rep1_iRFP_post Rep2_iRFP_pre Rep2_iRFP_post Rep3_iRFP_pre Rep3_iRFP_post
do
        cutadapt -j 30 -g NNNNNNNNNNNNTCCAGTCACTCTCCTGCA -m 22 ~/NIJK03/${sample}_Cut2.fastq > ./${sample}_Cut4.fastq
done

#Cut constant on 5'end
for sample in Rep1_mCherry_pre Rep1_mCherry_post Rep2_mCherry_pre Rep2_mCherry_post Rep3_mCherry_pre Rep3_mCherry_post
do
        cutadapt -j 30 -g NNNNNNNNNNNNCATGTCTGGATCCCTGCA -m 22 ~/NIJK03/${sample}Cut2.fastq > ./${sample}_Cut4.fastq
done

#Now should be left with barcode only

# Count barcodes
for sample in Rep1_iRFP_pre Rep1_iRFP_post Rep2_iRFP_pre Rep2_iRFP_post Rep3_iRFP_pre Rep3_iRFP_post Rep1_mCherry_pre Rep1_mCherry_post Rep2_mCherry_pre Rep2_mCherry_post Rep3_mChe$
do
        ../barcode_assign/target/debug/bc-count --fastq ./${sample}_Cut4.fastq --output ./${sample}Count.txt --neighborhood ./${sample}Nbhd
done


# Make iRFP counts table

COUNTDIR='./'

iRFPcounts=$(echo ${COUNTDIR}*iRFP*Count.txt)

../barcode_assign/target/debug/bc-tabulate ${iRFPcounts} -o ${COUNTDIR}NIJK03_iRFP_bccounts_noumi.txt

# Make mCherry counts table

mCherrycounts=$(echo ${COUNTDIR}*mCherry*Count.txt)

../barcode_assign/target/debug/bc-tabulate ${mCherrycounts} -o ${COUNTDIR}NIJK03_mCherry_bccounts_noumi.txt


