Do1:=true;
Do2:=false;


IsConjectureOK_FirstKernel:=function(PL, KN)
  local nbEdge, LVal;
  if IsCommutative(KN) = false then
    return false;
  fi;
  nbEdge:=(3 * Length(PL)) / 2;
  LVal:=FactorsInt(Order(KN));
  if Length(LVal)<>nbEdge-1 then
    return false;
  fi;
  if Set(LVal)<>[2] then
    return false;
  fi;
  return true;
end;


IsConjectureOK_SecondKernel:=function(PL, KN)
  local nbEdge, strTypeA, strTypeB;
  nbEdge:=(3 * Length(PL)) / 2;
  strTypeA:=StructureDescription(KN);
  strTypeB:=Concatenation("A", String(nbEdge));
  return strTypeA = strTypeB;
end;




IsConjectureOK_ThirdKernel:=function(PL, KN)
  local nbVert, LVal;
  nbVert:=Length(PL);
  if IsCommutative(KN) = false then
    return false;
  fi;
  LVal:=FactorsInt(Order(KN));
  if Length(LVal)<>nbVert-1 then
    return false;
  fi;
  if Set(LVal)<>[3] then
    return false;
  fi;
  return true;
end;


IsConjectureOK_GRP4:=function(PL, eGRP)
  local nbVert, ListFaces, HasEvenFace, eFace, res, strTypeA, strTypeB;
  nbVert:=Length(PL);
  ListFaces:=__FaceSet(PL);
  HasEvenFace:=false;
  for eFace in ListFaces
  do
    res:=Length(eFace) mod 2;
    if res=0 then
      HasEvenFace:=true;
    fi;
  od;
  strTypeA:=StructureDescription(eGRP);
  if HasEvenFace then
    strTypeB:=Concatenation("S", String(nbVert));
  else
    strTypeB:=Concatenation("A", String(nbVert));
  fi;
  return strTypeA = strTypeB;
end;






FuncTreat:=function(ePL)
  local F, KN, test1, test2, test3, test4;
  Print("Considering a graph in FuncTreat\n");
  Print("nbv=", Length(ePL), "  grp=", GroupPlan(ePL).TotalGroup.SchoenfliesSymbol, "\n");
  F:=RubikCubeFormalism(ePL);
#  Print("  |GRP1|=", Order(F.GRP1), " |GRP2|=", Order(F.GRP2), " |GRP3|=", Order(F.GRP3), " |GRP4|=", Order(F.GRP4), "\n");

  # First Kernel
  KN:=Kernel(F.phi12);
  test1:=IsConjectureOK_FirstKernel(ePL, KN);
  Print("First conjecture = ", test1, "\n");

  # Second Kernel
  KN:=Kernel(F.phi23);
  test2:=IsConjectureOK_SecondKernel(ePL, KN);
  Print("Second conjecture = ", test2, "\n");

  # Third Kernel
  KN:=Kernel(F.phi34);
  test3:=IsConjectureOK_ThirdKernel(ePL, KN);
  Print("Third conjecture = ", test3, "\n");

  # Last group
  test4:=IsConjectureOK_GRP4(ePL, F.GRP4);
  Print("Fourth conjecture = ", test4, "\n");

  if test1=false or test2=false or test3=false or test4=false then
    Print("           XXXXXXXXXXXXXXXXXXXXXX    Conjecture Broken XXXXXXXXXXXXXXXXXXX\n");
  fi;
  Print("\n");
end;


FuncTreatMedial:=function(ePL)
  local F, PLori, IsComm, TheQuot, eStabVert1, eStabFace1, eStabVert2, eStabFace2;
  Print("Considering a graph in FnucTreatMedial\n");
  Print("nbv=", Length(ePL), "  grp=", GroupPlan(ePL).TotalGroup.SchoenfliesSymbol, "\n");
  PLori:=PlanGraphToPlanGraphOriented(ePL);
  F:=RubikCubeMedialFormalism(PLori);
  IsComm:=IsCommutative(F.GRP2_edge);
  TheQuot:=Order(F.GRP1_de)/Order(F.GRP2_edge);
  Print("TheQuot=", TheQuot, " |GRP2_edge|=", FactorsInt(Order(F.GRP2_edge)), "\n");
#  eStabFace1:=Stabilizer(F.GRP2_edge, F.SetSet_Face, OnSetsSets);
#  eStabVert1:=Stabilizer(F.GRP2_edge, F.SetSet_Vert, OnSetsSets);
#  Print(" |eStabFace1|=", Order(eStabFace1), " |eStabVert1|=", Order(eStabVert1), "\n");
  eStabFace2:=OnSetsSetsStabilizer(F.GRP2_edge, F.SetSet_Face);
  eStabVert2:=OnSetsSetsStabilizer(F.GRP2_edge, F.SetSet_Vert);
  Print(" |eStabFace2|=", Order(eStabFace2), " |eStabVert2|=", Order(eStabVert2), "\n");
  Print("\n");
end;






TheTetra:=ArchimedeanPolyhedra("Tetrahedron");
TheCube:=ArchimedeanPolyhedra("Cube");
TheDodec:=ArchimedeanPolyhedra("Dodecahedron");


ChoiceOption:=2;

if ChoiceOption=1 then
  #
  LPL:=[
    TheTetra,
    GoldbergConstruction(TheTetra,1,1),
    TheCube,
    GoldbergConstruction(TheTetra,2,0),
    TheDodec,
    GoldbergConstruction(TheTetra,2,1),
    GoldbergConstruction(TheCube,1,1),
    GoldbergConstruction(TheCube,2,0),
    GoldbergConstruction(TheCube,2,1),
    GoldbergConstruction(TheDodec,1,1),
    GoldbergConstruction(TheDodec,2,0),
    GoldbergConstruction(TheDodec,2,1)];
fi;
if ChoiceOption=2 then
  LPL:=[];
  #
  for iS in [3,4,5]
  do
    for n in [0..10]
    do
      nbS:=12/(6-iS);
      ListPair:=[[iS, nbS], [6,n]];
      nbV:=(iS*nbS + 6*n)/3;
      if IsInt(nbV) and IsInt(nbS) then
        eFileSave:=Concatenation("ConjD3/LPL", String(n), "_", String(iS), "_", String(nbV));
        if IsExistingFile(eFileSave)=false then
          Print("iS=", iS, " n=", n, " : ListPair=", ListPair, " nbV=", nbV, "\n");
          PartLPL:=GetList3valentPlaneGraphSpecifiedFvector(nbV, ListPair);
          Print("|PartLPL|=", Length(PartLPL), "\n");
          Append(LPL, PartLPL);
        fi;
      fi;
    od;
  od;
  MaxV:=Maximum(List(LPL, Length));
  Print("|LPL|=", Length(LPL), " MaxV=", MaxV, "\n");
fi;




for ePL in LPL
do
  if Do1=true then
    FuncTreat(ePL);
  fi;
  if Do2=true then
    FuncTreatMedial(ePL);
  fi;
od;
