#load data


library(vegan)
library(qiime2R)
library(readxl)
library(tidyverse)
source("Code/general_functions.R")
metadata<-read_excel("Data/Metadatos.xlsx") %>% mutate_if(is.numeric, as.factor)
meta<-metadata
table_single_micop<- read.delim("Data/table_micop_single.txt") 
table_paired_micop<- read.delim("Data/table_micop_paired.txt")
table_qiime2<- data.frame(
  read_qza("Data/clustered_table_filter.qza")$data,
  check.names = F) %>% t() %>% as.data.frame(
  ) %>% rownames_to_column(
    var = "SampleID") %>% separate(
      SampleID, c(
        "id_metagenome", "R", "unmap", "Paired"), 
      sep = "_")%>% inner_join(
        meta) %>% dplyr::select(
          -id_metagenome:-Paired, -id_sequence:-id_fisicoq, -Sites, -Names) %>% column_to_rownames(
            var="SampleID") %>% t() %>% as.data.frame() %>% mutate_all(as.numeric)
table_fungi<- read.delim("Data/table_fungi_again.txt", 
                         skip = 1, row.names = 1, check.names = F) %>% dplyr::select_if(
                           is.numeric)%>% t() %>% as.data.frame() %>% rownames_to_column(
                             var = "id_sequence") %>% separate(
                               ., "id_sequence", c("kraken", "fungi", "id_metagenome", "report", "bracken"), 
                               sep = "_") %>% dplyr::select(-kraken, -fungi, -report, -bracken) %>% full_join(
                                 metadata) %>% dplyr::select(-id_sequence:-Transecto, -id_metagenome, -Sites, -id_new, -Names, -id_fisicoq) %>% column_to_rownames(
                                   var = "SampleID") %>% t() %>% as.data.frame() %>% mutate_all(as.numeric)


vector_order<- c("P1S1T1", "P1S1T2", "P1S1T3",
                 "P1S2T1", "P1S2T2", "P1S2T3",
                 "P2S1T1", "P2S1T2", "P2S1T3",
                 "P2S2T1", "P2S2T2", "P2S2T3",
                 "P3S1T1", "P3S1T2", "P3S1T3",
                 "P3S2T1", "P3S2T2", "P3S2T3",
                 "P4S1T1", "P4S1T2", "P4S1T3",
                 "P4S2T1", "P4S2T2", "P4S2T3",
                 "P5S1T1", "P5S1T2", "P5S1T3",
                 "P5S2T1", "P5S2T2", "P5S2T3",
                 "P6S1T1", "P6S1T2", "P6S1T3",
                 "P6S2T1", "P6S2T2", "P6S2T3")

#ordering

taxonomy_qiime2<- data.frame(read_qza("Data/taxonomy_blast_dfc_0.98.qza")$data, check.names = F) %>% dplyr::select(Feature.ID,Taxon)
taxonomy_single_micop<- read.delim("Data/table_micop_single.txt") %>% rownames_to_column(var = "Feature.ID") %>% dplyr::select(Feature.ID) %>% mutate(Taxon=Feature.ID)
taxonomy_paired_micop<- read.delim("Data/table_micop_paired.txt") %>% rownames_to_column(var = "Feature.ID") %>% dplyr::select(Feature.ID) %>% mutate(Taxon=Feature.ID)
taxonomy_fungi<- read.delim("Data/table_fungi_again.txt", 
                            skip = 1, row.names = 1, check.names = F) %>% select_if(is.character) %>% rownames_to_column(
                              var = "#OTU ID") %>% dplyr::select(Feature.ID = "#OTU ID", Taxon= taxonomy)

map<- read.csv("Data/coord.csv") %>% mutate_at(
  c(1,2,3,7), as.factor) %>% mutate(SampleID= paste0("P",pol, "S", Sitio,"T", Transecto ))
metadata<-read_excel("Data/Metadatos.xlsx") %>% mutate_if(is.numeric, as.factor)
library(tidyverse)
library(ggh4x)
taxones_color<- read_csv("taxones_color.csv")

data_fun<- function(tab, taxonomy, metadata){
  table_genus<- tab %>%rownames_to_column(
    var = "Feature.ID") %>%  inner_join(taxonomy) %>% separate(
      Taxon, c("k","p","c","o","f","g","s"), sep = ";" ) %>% mutate_at(
        c("g"), ~str_replace(., "g__", ""))%>% 
    dplyr::mutate(g = stringr::str_trim(g, side = "both")) %>% mutate_if(
      is.character, ~replace_na(., "Unassigned")) %>% group_by(
        g) %>% summarise_if(is.numeric, sum) %>% column_to_rownames(
          var = "g") %>%  mutate(
            all= rowSums(.)) %>% dplyr::arrange(
              -all) %>% rel_ab(.) %>%as.data.frame( ) %>%  rownames_to_column(
              var = "Taxon")%>% filter(!Taxon=="unidentified" ,
                                       !Taxon=="Unassigned") %>% slice(
                                         c(1:50))  %>% pivot_longer(
                                           ., cols = -Taxon, names_to ="SampleID", 
                                           values_to = "relab" ) %>% filter(
                                             !SampleID=="all")
  cols<- table_genus %>% inner_join(taxones_color) %>% arrange(Taxon)
  col <- as.character(cols$color)
  names(col) <- as.character(cols$Taxon)
  
  barplot_genus<- table_genus %>% inner_join(metadata)%>% dplyr::select(
    Taxon, SampleID, relab) %>% pivot_wider(
      names_from = Taxon, values_from = relab) %>% column_to_rownames(
        var = "SampleID") %>% t() %>% as.data.frame()}

data_fun2<- function(tab, taxonomy, metadata){
  table_genus<- tab %>%rownames_to_column(
  var = "Feature.ID") %>%  inner_join(taxonomy) %>% separate(
    Taxon, c("k","p","c","o","f","g","s"), sep = "__" ) %>% mutate_at(
      c("g"), ~str_replace(., "g__", "")) %>% mutate_at(
        c("g"), ~str_replace(., "g__", "")) %>% mutate_if(
          is.character, ~replace_na(., "Unassigned")) %>% group_by(
            g) %>% summarise_if(is.numeric, sum) %>% column_to_rownames(
              var = "g") %>%  mutate(
                all= rowSums(.)) %>% dplyr::arrange(-all) %>% rel_ab(.) %>% as.data.frame() %>% rownames_to_column(
                  var = "Taxon")%>% filter(!Taxon=="unidentified" , !Taxon=="Unassigned") %>% slice(
                    c(1:50))  %>% pivot_longer(
                      ., cols = -Taxon, names_to ="SampleID", 
                      values_to = "relab" ) %>% filter(!SampleID=="all")
cols<- table_genus %>% inner_join(taxones_color) %>% arrange(Taxon)
col <- as.character(cols$color)
names(col) <- as.character(cols$Taxon)
barplot_genus<- table_genus %>% inner_join(metadata)%>% dplyr::select(
  Taxon, SampleID, relab) %>% pivot_wider(
    names_from = Taxon, values_from = relab) %>% column_to_rownames(
      var = "SampleID") %>% t() %>% as.data.frame()}



data_qiime2<- data_fun(table_qiime2, taxonomy_qiime2, metadata) 
data_qiime2_order=data_qiime2[, match(vector_order, colnames(data_qiime2))]%>%
  rename_if(is.numeric, ~paste0(.,"_qiime2"))%>% rownames_to_column(var="gen")


data_fungi<- data_fun(table_fungi, taxonomy_fungi, metadata) 
data_fungi_order=data_fungi[, match(vector_order, colnames(data_fungi))]%>%
  rename_if(is.numeric, ~paste0(.,"_kraken2")) %>% rownames_to_column(var="gen")

data_single<- data_fun2(table_single_micop, taxonomy_single_micop, metadata) 
data_single_order=data_single[, match(vector_order, colnames(data_single))]%>%
  rename_if(is.numeric, ~paste0(.,"_single"))%>% rownames_to_column(var="gen")

data_paired<- data_fun2(table_paired_micop, taxonomy_paired_micop, metadata) 
data_paired_order=data_paired[, match(vector_order, colnames(data_paired))]%>%
  rename_if(is.numeric, ~paste0(.,"_paired"))%>% rownames_to_column(var="gen")


merge_data<- data_qiime2_order %>% full_join(
  data_single_order)%>% full_join(
    data_paired_order)%>% full_join(
      data_fungi_order) %>% replace(is.na(.), 0)  %>% mutate(gen=case_when(
        gen=="Leptosphaeria maculans species complex" ~ "Leptosphaeria", 
        TRUE ~ as.character(gen)))%>% column_to_rownames(
        var = "gen") %>% mutate(proms=rowMeans(.)) %>% arrange(-proms) %>% slice(
          1:60)%>% dplyr::select(-proms) %>% mutate_all(., funs(R = case_when(
          . <= 0.001 ~ 0,
          . >  0.001 & .  <= 0.005 ~ 1,
          . >  0.005 & .  <= 0.01 ~ 2,
          . >  0.01 & .  <= 0.10 ~ 3,
          . >  0.10 & .  <= 0.20 ~ 4,
          . >  0.20 & .  <= 1.00 ~ 5,
          . >  1.00 & .  <= 2.00 ~ 6,
          . >  2.00 & .  <= 5.00 ~ 7,
          . >  5.00 & .  <= 10.00 ~ 8,
          . >  10.00 & .  <= 25.00 ~ 9,
          . >  25.00 & .  <= 50.00 ~ 10,
          . >  50.00 & .  <= 75.00 ~ 11,
          . >  75.00 ~ 12))) %>%select_at(
            vars(contains("_R"))) %>% select_all(~str_replace(., "_R", ""))

library(ComplexHeatmap)
library(circlize)
library(viridis)
col_fun2 = colorRamp2(c(0,  1, 1+1e-5,10,50, 100), 
                      viridis(6, option = "F", direction = -1))
my_palette <- viridis::viridis(n = 12, option = "F", direction = -1)
col_fun = colorRamp2(c(0,  1, 1+1e-5,5,5+1e-5,10,10+1e-5,50,50+1e-5, 75, 75+1e-5,100), 
                      viridis(12, option = "F", direction = -1))

#annotatio seccion y origen (columnas)
annotation_columns<- data.frame(id=colnames(merge_data)) 
rownames(annotation_columns) <- colnames(heatmap)

#set.seed(123)
split = rep(1:4, each = 36)

Sites<- c(1,1,1,
          2,2,2,
          3,3,3,
          4,4,4,
          5,5,5,
          6,6,6,
          7,7,7,
          8,8,8,
          9,9,9,
          10,10,10,
          11,11,11,
          12,12,12)

ha = HeatmapAnnotation("Method" = anno_block(gp = gpar(
  fill = c("black" ,"black" ,"black", "black")), 
  labels = c("QIIME2", "SINGLE MICOP", "PAIRED MICOP", "KRAKEN2"), 
  labels_gp = gpar(col = "white", fontsize = 9, fontface= "bold")))

cols_ho<- list("Sites" = c("1"="#30123BFF","2"="#4454C4FF","3"= "#4490FEFF",
                            "4"="#1FC8DEFF", "5"= "#29EFA2FF","6"= "#7DFF56FF",
                            "7"="#C1F334FF","8"="#F1CA3AFF","9"= "#FE922AFF",
                            "10"="#EA4F0DFF","11"= "#BE2102FF","12"= "#7A0403FF"))


ho = HeatmapAnnotation("Sites" = c(rep(Sites, 4)),
                       which = "col", col = cols_ho,
                       annotation_name_gp = gpar(fontsize=8,
                                                 fontface="bold"),
                       show_legend = F, gp = gpar(
                         col = "white", fontize=12), 
                       simple_anno_size = unit(0.25, "cm"),
                       show_annotation_name = T)
#annotatio row (filas)
guilds<- read_tsv("Data/guilds_filtered.tsv") %>% mutate(Guilds=case_when(
  Guild=="Dung Saprotroph-Undefined Saprotroph-Wood Saprotroph" ~ "Undefined Saprotroph", 
  TRUE ~ as.character(Guild)))
annotation_rows<- merge_data %>% rownames_to_column(
  var = "Taxon") %>% left_join(
  guilds) %>% dplyr::select_if(
is.character) %>% replace(
  is.na(.), "Unassigned") %>% column_to_rownames(
    var = "Taxon") %>% dplyr::rename(Trophic=`Trophic Mode`)
cols_guild <- list('Guild' = c("Ectomycorrhizal" = "#0E6655",
                                   "Lichenized"  = "#82E0AA",
                                   "Unassigned"= "#A6ACAF",
                                   "Undefined Saprotroph"= "#A93226",
                                   "Wood Saprotroph"= "#641E16"))

cols_tro <- list('Trophic' = c("Saprotroph" = "#7B241C",
                               "Symbiotroph"  = "#28B463",
                               "Unassigned"= "#D0D3D4"))

annguild = HeatmapAnnotation("Guild" = annotation_rows$Guilds, 
                            which = "row", col = cols_guild,
                            show_legend = T,   
                            show_annotation_name = T,
                            annotation_name_gp =gpar(
                              fontsize = 8, fontface="bold"),
                            annotation_legend_param = list(
                              title_gp = gpar(fontsize = 8, 
                                              fontface="bold"),
                              labels_gp = gpar(fontsize = 6.5),
                             direction ="horizontal"),
                            simple_anno_size = unit(0.3, "cm"),
                            gp = gpar(col = "white"))
anntro = HeatmapAnnotation("Trophic" = annotation_rows$Trophic, 
                             which = "row", col = cols_tro,
                             show_legend = T,   show_annotation_name = T,
                             annotation_name_gp =gpar(fontsize = 8,
                                                      fontface="bold"),
                             annotation_legend_param = list(
                               title_gp = gpar(fontsize = 8, 
                                               fontface="bold"),
                               labels_gp = gpar(fontsize = 7),
                               direction ="horizontal"),
                           simple_anno_size = unit(0.3, "cm"),
                           gp = gpar(col = "white"))

#annotation_rows[is.na(annotation_rows)] <- "Unassigned"

heats<-ComplexHeatmap::Heatmap(
  merge_data,
  col = my_palette,
  heatmap_legend_param = list(direction = "horizontal",
                              title = "Relative\nabund.\n(%)",
                              legend_height = unit(2, "cm"),
                              labels_gp = gpar(fontsize = 8),
                              title_gp = gpar(fontsize = 7, 
                                              fontface="bold"),
                              at = c(0,1, 10,  50, 100), break_dist = 1),
  rect_gp = gpar(col = "white"), 
  cluster_columns = F, cluster_rows = T,
  show_heatmap_legend = TRUE, top_annotation = c(ha, ho),
  left_annotation = c(annguild, anntro),
  column_order = sort(colnames(merge_data)),
  column_split = split, column_title = NULL,
show_column_names = F,
row_names_gp = gpar(fontsize=7.5, fontface="italic"),
column_title_gp = gpar(
  fill = c("#800000" ,"#808000" ,"#008000", "#D35400", "#2E4053" )))

heats

lgd1 = Legend(at = 1:12, title = "Sites", nrow = 1,
              title_position = "leftcenter",
              legend_gp = gpar(fill = viridis(
  n = 12, option = "H", direction = 1)),
  labels_gp = gpar(fontsize = 8),
  title_gp = gpar(fontsize = 9, fontface="bold"))


lgd2 = Legend(at = sort(unique(annotation_rows$Guilds)), 
              legend_gp = gpar(fill = cols_guild$Guild), 
              title = "Guild",  ncol = 2, gap = unit(0.1, "cm"),
              labels_gp = gpar(fontsize = 7),
              title_gp = gpar(fontsize = 7, fontface="bold"))
lgd3 = Legend(at = sort(unique(annotation_rows$`Trophic Mode`)), 
              legend_gp = gpar(fill = cols_tro$`Trophic Mode`),
              title = "Trophic", ncol = 1,gap = unit(0.1, "cm"),
              labels_gp = gpar(fontsize =7),
              title_gp = gpar(fontsize = 7, fontface="bold"))


draw(heats, heatmap_legend_side = "right",
     annotation_legend_side = "top", 
     merge_legend=F,
     annotation_legend_list = list(lgd1))


heatm<-grid.grabExpr(draw(heats, heatmap_legend_side = "right",
                          annotation_legend_side = "top", 
                          merge_legend=F,
                          annotation_legend_list = list(lgd1)))
                     
heatm
ggsave('heat_final.png', width = 11, height = 7, dpi = 300, plot =heatm)

                        