# hitchiking simulation
# simulating the genomic signatures of cultural hitchiking.
# Laurel Fogarty
# 23.11.2023
# Outputs gene-culture data for Figure 4 panel C (change beta and output file name manually)

## model 1 -- 4 neutral alleles, 1 selected allele, no culture

using DataFrames
using Distributions
using CSV
using DelimitedFiles
using StatsBase
using Shuffle
using Plots

include("FogartyOtto_Fig3_Functions.jl")

N = 10000;
reps = 500;
mu = 0.0001;
beta = 0.00001;
SC = 0.01;

rec1 = 10^-2;
rec2 = 10^-4;

burnin_time = 5*N;
selection_time = burnin_time+2*N;

p = Binomial(5*N, mu);
q1 = Binomial(N, rec1);
q2 = Binomial(N, rec2);

pc = Binomial(N,beta);

## simulations

for r in 1:reps

    print(r)
    saveflag=0;
    GENOME = zeros(5,N); # 1 linked, distal, 2 proximate, distal
    CULTOME = zeros(1,N);

    mutation_number = rand(p,selection_time);
    recom1_number = rand(q1,selection_time);
    recom2_number = rand(q2,selection_time);
    recom3_number = rand(q2,selection_time);
    recom4_number = rand(q1,selection_time);

    crecom_number = rand(pc,selection_time);

    for t in 1:selection_time
        # find the parents, 1 is reference
        if t<burnin_time
            local parents = sample(1:N,N,replace=true);
            local fitw = aweights(ones(1,N));
        elseif t==burnin_time
            innovator = sample(1:N,1);
            CULTOME[innovator[1]] = 2;
            lucky = [CULTOME.==2].*SC

            local fitness = ones(N,1)./10+lucky[1];
            local fitw = aweights(fitness);
            local parents = wsample(1:N,fitw,N,replace=true);

        else
            lucky = [CULTOME.==2].*SC
            if sum(lucky[1])==0
                print(":extinct, ")
                saveflag = 0;
                break
            elseif sum(lucky[1])>((N-10)*SC)
                print(":fixed, ")
                #pwd = pairwise_distance_sample(N, GENOME,pairs,npairs);
                # list the haplotypes
                HAPS = countmap(eachcol(GENOME));

                # list frequencies
                HAPS_C = collect(values(HAPS));
                HAPS_F = HAPS_C./sum(HAPS_C);

                # order the list
                HAPS_FS = sort(HAPS_F,rev=true);

                H2H1 =  HAPS_FS[2]./HAPS_FS[1];

                open("FogartyOtto_H2H1_beta00001r001.csv", "a") do io
                    writedlm(io, H2H1,',') end

                break
            end
            local fitness = ones(N,1)./10+lucky[1];
            local fitw = aweights(fitness);
            local parents = wsample(1:N,fitw,N,replace=true);
        end

        kids_genome = GENOME[:,parents];

        # mutation

        if mutation_number[t]>0
            mutants = sample(1:5*N,mutation_number[t],replace=false);
            kids_genome[mutants] = rand(mutation_number[t]); # pop in mutations
        end

        # recombination
        total_recombiners = recom1_number[t]+recom2_number[t]+recom3_number[t]+recom4_number[t];
        recombiners_mainlist = sample(1:N,total_recombiners,replace=false);
        recombiners_mainlist = shuffle(recombiners_mainlist);

        recombiners1 = recombiners_mainlist[1:recom1_number[t]];
        recombiners2 = recombiners_mainlist[recom1_number[t]+1:recom1_number[t]+recom2_number[t]];
        recombiners3 = recombiners_mainlist[recom1_number[t]+recom2_number[t]+1:recom1_number[t]+recom2_number[t]+recom3_number[t]];
        recombiners4 = recombiners_mainlist[recom1_number[t]+recom2_number[t]+recom3_number[t]+1:end];

        if recom4_number[t]>0
            kids_genome,parent24 = recombinationc(recom4_number[t],recombiners4,kids_genome,GENOME,fitw,5);end
        if recom1_number[t]>0
            kids_genome,parent21 = recombinationc(recom1_number[t],recombiners1,kids_genome,GENOME,fitw,1);end
            #samegenomeparent[recombiners1] = parent21;end
        if recom2_number[t]>0
            kids_genome,parent22 = recombinationc(recom2_number[t],recombiners2,kids_genome,GENOME,fitw,2);end
            #samegenomeparent[recombiners2] = parent22;end
        if recom3_number[t]>0
            kids_genome,parent23 = recombinationc(recom3_number[t],recombiners3,kids_genome,GENOME,fitw,4);end

        ## cultural recombination
        #vert1 - copy different genome parent with prob beta
        cultrecombiners = sample(1:N,crecom_number[1],replace=false);

        # who is culturally recombining - these guys want to copy different genome parents OR parents from whom they did not get their genome
        samegenomeparent = parents;
        kids_cultome = CULTOME[samegenomeparent]; # default
        parents2 = wsample(1:N,fitw,crecom_number[1],replace=true); # assuming recombination and cultural recombination rarely co-occur
        kids_cultome[cultrecombiners] = CULTOME[parents2];

        #vert2
        # next gen
        GENOME = kids_genome;
        CULTOME = kids_cultome;

    end

    # plot(LOCI,HetValue, linestyle=:dash, color = "red",dpi=1000)


end
