using Plots
using CSV
using DataFrames
using Statistics
using Colors
using StatsPlots
using LaTeXStrings

HAPS_FS_G1 = CSV.read("FogartyOtto_H2H1_g_r001.csv", CSV.Tables.matrix, header=false);
HAPS_FS_G2 = CSV.read("FogartyOtto_H2H1_g_neutral_r001.csv", CSV.Tables.matrix, header=false);

HAPS_FS_B00001 = CSV.read("FogartyOtto_H2H1_beta00001r001.csv", CSV.Tables.matrix, header=false)
HAPS_FS_B0001= CSV.read("FogartyOtto_H2H1_beta0001r001.csv", CSV.Tables.matrix, header=false)
HAPS_FS_B001 = CSV.read("FogartyOtto_H2H1_beta001r001.csv", CSV.Tables.matrix, header=false)
HAPS_FS_B01 = CSV.read("FogartyOtto_H2H1_beta01r001.csv", CSV.Tables.matrix, header=false)
HAPS_FS_B015 = CSV.read("FogartyOtto_H2H1_beta015r001.csv", CSV.Tables.matrix, header=false)
HAPS_FS_B025 = CSV.read("FogartyOtto_H2H1_beta025r001.csv", CSV.Tables.matrix, header=false)
HAPS_FS_B05 = CSV.read("FogartyOtto_H2H1_beta05r001.csv", CSV.Tables.matrix, header=false)
HAPS_FS_B1 = CSV.read("FogartyOtto_H2H1_beta1r001.csv", CSV.Tables.matrix, header=false)

#HAPS_FS_B003 = CSV.read("FogartyOtto_H2H1_beta003.csv", DataFrame, header=false)
#HAPS_FS_B005 = CSV.read("FogartyOtto_H2H1_beta005.csv", DataFrame, header=false)
#HAPS_FS_B008 = CSV.read("FogartyOtto_H2H1_beta008.csv", DataFrame, header=false)
#HAPS_FS_B01 = CSV.read("FogartyOtto_H2H1_beta01.csv", DataFrame, header=false)

A = mean(HAPS_FS_B00001);
B = mean(HAPS_FS_B0001);
C = mean(HAPS_FS_B001);
D = mean(HAPS_FS_B01);
E = mean(HAPS_FS_B015);
F = mean(HAPS_FS_B025);
H = mean(HAPS_FS_B05);
I = mean(HAPS_FS_B1);

G1 = mean(HAPS_FS_G1);
G2 = mean(HAPS_FS_G2);

HAPS_FS = [A,B,C,D,E,F,H,I];
Beta = [0.00001,0.0001,0.001,0.01,0.015,0.025,0.05,0.1];


# HAPS_FS = [A,B,C,D,E,F,H,I];
# Beta = [0,0.0001,0.0005,0.001,0.0015,0.005,0.01,0.1];

# plot them

PC = plot(xlabel=L"log_{10}(\beta)", ylabel=L"H_2/H_1", ylims=(0,1))

X1 = ones(length(HAPS_FS_B00001),1).*log10(Beta[1]);
scatter!(X1,HAPS_FS_B00001,markersize=2,alpha = 0.025,legend = false)

X2 = ones(length(HAPS_FS_B0001),1).*log10(Beta[2]);
scatter!(X2,HAPS_FS_B0001,markersize=2,alpha = 0.025,legend = false)

X3 = ones(length(HAPS_FS_B001),1).*log10(Beta[3]);
scatter!(X3,HAPS_FS_B001,markersize=2,alpha = 0.025,legend = false)

X4 = ones(length(HAPS_FS_B01),1).*log10(Beta[4]);
scatter!(X4,HAPS_FS_B01,markersize=2,alpha = 0.025,legend = false)

X5 = ones(length(HAPS_FS_B015),1).*log10(Beta[5]);
scatter!(X5,HAPS_FS_B015,markersize=2,alpha = 0.025,legend = false)

X6 = ones(length(HAPS_FS_B025),1).*log10(Beta[6]);
scatter!(X6,HAPS_FS_B025,markersize=2,alpha = 0.025,legend = false)

X7 = ones(length(HAPS_FS_B05),1).*log10(Beta[7]);
scatter!(X7,HAPS_FS_B05,markersize=2,alpha = 0.025,legend = false)

X8 = ones(length(HAPS_FS_B1),1).*log10(Beta[8]);
scatter!(X8,HAPS_FS_B1,markersize=2,alpha = 0.025,legend = false)

scatter!(log10.(Beta),HAPS_FS,markersize=2)

plot!(log10.(Beta),HAPS_FS,line =:black,label ="Gene-culture sweep")
plot!([log10(0.00001),log10(0.1)],[G1,G1],linestyle=:dash,line =:red,label ="Hard genetic sweep")# plot!([-1,0], [3,3])
plot!([log10(0.00001),log10(0.1)],[G2,G2],linestyle=:dash,line =:black,label = "Neutral")# plot!([-1,0], [3,3])


savefig(PC,"GarudTest_BetaFig_log3.png")

PD = ecdfplot(vec(HAPS_FS_B00001),label="beta = 0.00001")
ecdfplot!(vec(HAPS_FS_B0001),label="beta = 0.0001")
ecdfplot!(vec(HAPS_FS_B001),label="beta = 0.001")
ecdfplot!(vec(HAPS_FS_B01),label="beta = 0.01")
ecdfplot!(vec(HAPS_FS_B015),label="beta = 0.015")
ecdfplot!(vec(HAPS_FS_B025),label="beta = 0.025")
ecdfplot!(vec(HAPS_FS_B05),label="beta = 0.05")
ecdfplot!(vec(HAPS_FS_B1),label="beta = 0.1")

ecdfplot!(vec(HAPS_FS_G1),label="hard sweep")
ecdfplot!(vec(HAPS_FS_G2),label="neutral")

savefig(PD,"GarudTest_BetaFig_ecdf.png")
