(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     11374,        314]
NotebookOptionsPosition[      9059,        269]
NotebookOutlinePosition[      9458,        285]
CellTagsIndexPosition[      9415,        282]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["\<\
The recursion equation for the frequency of the C trait when allele a is \
fixed is:\
\>", "Text",
 CellChangeTimes->{{3.91490889027913*^9, 
  3.914908934004821*^9}},ExpressionUUID->"861e04aa-227d-4ba9-a08e-\
55b584ae3a44"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{
      SuperscriptBox["x", "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "+", "sC"}], ")"}], "2"]}], "+", 
     RowBox[{"2", "\[Gamma]2", " ", "x", " ", "y", " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", "sC"}], ")"}]}]}], 
    RowBox[{
     RowBox[{
      SuperscriptBox["x", "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "+", "sC"}], ")"}], "2"]}], "+", 
     RowBox[{"2", "x", " ", "y", " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", "sC"}], ")"}]}], "+", 
     SuperscriptBox["y", "2"], " "}]], "/.", 
   RowBox[{"y", "\[Rule]", 
    RowBox[{"1", "-", "x"}]}]}], ";"}]], "Input",
 CellChangeTimes->{{3.914908563556211*^9, 3.914908629343891*^9}, 
   3.914908765352285*^9, {3.914908834742961*^9, 3.914908887260553*^9}, {
   3.914908937034699*^9, 3.914908939860835*^9}, {3.914909122497534*^9, 
   3.914909138559701*^9}},
 CellLabel->"In[67]:=",ExpressionUUID->"19f5f729-45cf-4a77-ad39-0c0189bc05b8"],

Cell["\<\
This assumes that the population is at Hardy-Weinberg proportions, which is \
true under random mating.  

The change in cultural trait frequency is thus:\
\>", "Text",
 CellChangeTimes->{{3.914908942125381*^9, 3.914908948473135*^9}, {
  3.914908996185677*^9, 3.9149090094335546`*^9}, {3.914909041627215*^9, 
  3.914909117058763*^9}},ExpressionUUID->"aee66e53-4c03-444c-9adf-\
7707b4ae213c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor", "[", 
  RowBox[{"%", "-", "x"}], "]"}]], "Input",
 CellChangeTimes->{{3.9149089529389467`*^9, 3.914908955398574*^9}, {
  3.914909140598798*^9, 3.91490914089328*^9}},
 CellLabel->"In[68]:=",ExpressionUUID->"2a70fddd-0b31-4ae0-8543-5e48e6340b6c"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", "x", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{
       SuperscriptBox["sC", "2"], " ", "x"}], "+", 
      RowBox[{"2", " ", "\[Gamma]2"}], "+", 
      RowBox[{"2", " ", "sC", " ", "\[Gamma]2"}]}], ")"}]}], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"sC", " ", "x"}]}], ")"}], "2"]]}]], "Output",
 CellChangeTimes->{
  3.914908955941938*^9, 3.914909141401325*^9, {3.9149092221556797`*^9, 
   3.914909253153327*^9}, 3.914909294001446*^9, {3.914909442161417*^9, 
   3.9149094731417103`*^9}},
 CellLabel->"Out[68]=",ExpressionUUID->"a1ce6c07-8d73-4677-badc-a3109c4b7238"]
}, Open  ]],

Cell["When selection is weak, this equals:", "Text",
 CellChangeTimes->{{3.914908961745146*^9, 3.914909012274311*^9}, {
  3.914909145654327*^9, 
  3.91490914798909*^9}},ExpressionUUID->"50b5db58-dec5-47d8-804d-\
1cfa56533fa4"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor", "[", 
  RowBox[{"Normal", "[", 
   RowBox[{"Series", "[", 
    RowBox[{"%", ",", 
     RowBox[{"{", 
      RowBox[{"sC", ",", "0", ",", "1"}], "}"}]}], "]"}], "]"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.914908635760357*^9, 3.9149086546077347`*^9}, 
   3.914909150166757*^9},
 CellLabel->"In[69]:=",ExpressionUUID->"f27ea608-fd44-4dfc-b357-7ab0ee015a26"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", "x", " ", 
  RowBox[{"(", 
   RowBox[{"1", "-", 
    RowBox[{"2", " ", "sC", " ", "x"}], "-", 
    RowBox[{"2", " ", "\[Gamma]2"}], "-", 
    RowBox[{"2", " ", "sC", " ", "\[Gamma]2"}], "+", 
    RowBox[{"4", " ", "sC", " ", "x", " ", "\[Gamma]2"}]}], ")"}]}]], "Output",
 CellChangeTimes->{{3.914908646370243*^9, 3.914908655039016*^9}, {
   3.914908775629281*^9, 3.914908779611629*^9}, 3.914909150689436*^9, {
   3.9149092221623783`*^9, 3.914909253160371*^9}, 3.9149092940091553`*^9, {
   3.914909442169585*^9, 3.914909473150539*^9}},
 CellLabel->"Out[69]=",ExpressionUUID->"816e4ecd-daf9-46b7-86cc-c00ac7c222ae"]
}, Open  ]],

Cell["\<\
As the expected frequency change in the haploid model is s x (1-x), we can \
define the selection coefficient (SCtilde) as:\
\>", "Text",
 CellChangeTimes->{{3.914909154813346*^9, 3.914909203652803*^9}, {
  3.914909447581376*^9, 
  3.9149094523716173`*^9}},ExpressionUUID->"3f4fbcd5-ae13-44eb-93fe-\
ab1ae2c89bf7"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"%", "/", 
   RowBox[{"(", 
    RowBox[{"x", " ", 
     RowBox[{"(", 
      RowBox[{"1", "-", "x"}], ")"}]}], ")"}]}], "//", "Factor"}]], "Input",
 CellChangeTimes->{{3.9149092096491413`*^9, 3.91490922838258*^9}},
 CellLabel->"In[70]:=",ExpressionUUID->"7c95a8a7-1a05-4877-84cb-5d83919320f7"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "1"}], "+", 
  RowBox[{"2", " ", "sC", " ", "x"}], "+", 
  RowBox[{"2", " ", "\[Gamma]2"}], "+", 
  RowBox[{"2", " ", "sC", " ", "\[Gamma]2"}], "-", 
  RowBox[{"4", " ", "sC", " ", "x", " ", "\[Gamma]2"}]}]], "Output",
 CellChangeTimes->{{3.914909215978673*^9, 3.914909253186742*^9}, 
   3.914909294034161*^9, {3.914909442193788*^9, 3.9149094731759157`*^9}},
 CellLabel->"Out[70]=",ExpressionUUID->"92b3f043-18ce-4f55-bbfc-846cd2e7e3e5"]
}, Open  ]],

Cell[TextData[{
 "which can be written as ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "sC", "-", 
       RowBox[{"2", " ", "sC", " ", "x"}]}], ")"}], " ", "\[Gamma]2"}], "-", 
    "1", "+", 
    RowBox[{"2", " ", "sC", " ", "x"}]}], TraditionalForm]],ExpressionUUID->
  "d652623c-6d50-4bd4-85b6-d7d2fd43fa84"],
 "."
}], "Text",
 CellChangeTimes->{{3.914909276861766*^9, 3.914909280034596*^9}, {
  3.914909312011794*^9, 
  3.9149093552700033`*^9}},ExpressionUUID->"a3771a44-3f47-4f13-9d71-\
d365ac8f5f2e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SCtilde", "=", 
  RowBox[{"Collect", "[", 
   RowBox[{"%", ",", "\[Gamma]2", ",", "Factor"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.9149092828063707`*^9, 3.914909293379985*^9}, {
  3.9149094337147017`*^9, 3.914909441179895*^9}},
 CellLabel->"In[71]:=",ExpressionUUID->"c93a16f4-fe00-4eb7-b566-2487b393e28c"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "1"}], "+", 
  RowBox[{"2", " ", "sC", " ", "x"}], "-", 
  RowBox[{"2", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "-", "sC", "+", 
     RowBox[{"2", " ", "sC", " ", "x"}]}], ")"}], " ", 
   "\[Gamma]2"}]}]], "Output",
 CellChangeTimes->{
  3.914909294040194*^9, {3.91490944220172*^9, 3.914909473185629*^9}},
 CellLabel->"Out[71]=",ExpressionUUID->"413db84d-bb02-4486-9bf1-69bb946ed2dd"]
}, Open  ]],

Cell["Without drive, selection equals:", "Text",
 CellChangeTimes->{{3.9149092566002617`*^9, 
  3.9149092637334538`*^9}},ExpressionUUID->"4d56d8b0-0dc9-4d8e-8f24-\
7aadd6182a21"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SCtilde", "/.", 
  RowBox[{"\[Gamma]2", "\[Rule]", 
   RowBox[{"1", "/", "2"}]}]}]], "Input",
 CellChangeTimes->{{3.9149086710151854`*^9, 3.9149086738804827`*^9}, {
   3.9149087974124737`*^9, 3.9149088040978928`*^9}, {3.914909247279587*^9, 
   3.914909249079968*^9}, 3.9149094668347807`*^9},
 CellLabel->"In[72]:=",ExpressionUUID->"90521389-0407-4f5b-b83c-2dfa192af078"],

Cell[BoxData["sC"], "Output",
 CellChangeTimes->{
  3.914908674799259*^9, {3.9149087981818113`*^9, 3.914908804479434*^9}, {
   3.914909222193501*^9, 3.914909253194974*^9}, 3.914909294068838*^9, {
   3.914909442209065*^9, 3.914909473212204*^9}},
 CellLabel->"Out[72]=",ExpressionUUID->"b067f8aa-a2d0-4db7-a72e-d25f55461225"]
}, Open  ]],

Cell["\<\
But the equation for SCtilde in the text only works when the cultural trait \
is rare (x low)\
\>", "Text",
 CellChangeTimes->{{3.914909614188964*^9, 
  3.914909629784556*^9}},ExpressionUUID->"361bb14a-92f1-4b86-a434-\
107bc9b6876b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SCtilde", "/.", 
   RowBox[{"x", "\[Rule]", "0"}]}], "//", "Factor"}]], "Input",
 CellChangeTimes->{{3.9149094706271963`*^9, 3.9149094922279463`*^9}},
 CellLabel->"In[76]:=",ExpressionUUID->"6898e867-9167-4470-9307-d0a09e3349df"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "1"}], "+", 
  RowBox[{"2", " ", "\[Gamma]2"}], "+", 
  RowBox[{"2", " ", "sC", " ", "\[Gamma]2"}]}]], "Output",
 CellChangeTimes->{{3.914909473217898*^9, 3.91490949260448*^9}},
 CellLabel->"Out[76]=",ExpressionUUID->"e3343921-ac6f-4c7e-9332-0b6f5e608120"]
}, Open  ]]
},
WindowSize->{1077, 974},
WindowMargins->{{252, Automatic}, {Automatic, 115}},
FrontEndVersion->"13.0 for Mac OS X ARM (64-bit) (December 2, 2021)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"427462f2-a639-47b9-a18b-4c3f22aff509"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 233, 6, 35, "Text",ExpressionUUID->"861e04aa-227d-4ba9-a08e-55b584ae3a44"],
Cell[794, 28, 1046, 29, 55, "Input",ExpressionUUID->"19f5f729-45cf-4a77-ad39-0c0189bc05b8"],
Cell[1843, 59, 401, 9, 81, "Text",ExpressionUUID->"aee66e53-4c03-444c-9adf-7707b4ae213c"],
Cell[CellGroupData[{
Cell[2269, 72, 277, 5, 30, "Input",ExpressionUUID->"2a70fddd-0b31-4ae0-8543-5e48e6340b6c"],
Cell[2549, 79, 780, 22, 59, "Output",ExpressionUUID->"a1ce6c07-8d73-4677-badc-a3109c4b7238"]
}, Open  ]],
Cell[3344, 104, 226, 4, 35, "Text",ExpressionUUID->"50b5db58-dec5-47d8-804d-1cfa56533fa4"],
Cell[CellGroupData[{
Cell[3595, 112, 391, 10, 30, "Input",ExpressionUUID->"f27ea608-fd44-4dfc-b357-7ab0ee015a26"],
Cell[3989, 124, 714, 15, 34, "Output",ExpressionUUID->"816e4ecd-daf9-46b7-86cc-c00ac7c222ae"]
}, Open  ]],
Cell[4718, 142, 324, 7, 35, "Text",ExpressionUUID->"3f4fbcd5-ae13-44eb-93fe-ab1ae2c89bf7"],
Cell[CellGroupData[{
Cell[5067, 153, 326, 8, 30, "Input",ExpressionUUID->"7c95a8a7-1a05-4877-84cb-5d83919320f7"],
Cell[5396, 163, 476, 9, 34, "Output",ExpressionUUID->"92b3f043-18ce-4f55-bbfc-846cd2e7e3e5"]
}, Open  ]],
Cell[5887, 175, 567, 17, 35, "Text",ExpressionUUID->"a3771a44-3f47-4f13-9d71-d365ac8f5f2e"],
Cell[CellGroupData[{
Cell[6479, 196, 334, 6, 30, "Input",ExpressionUUID->"c93a16f4-fe00-4eb7-b566-2487b393e28c"],
Cell[6816, 204, 444, 12, 34, "Output",ExpressionUUID->"413db84d-bb02-4486-9bf1-69bb946ed2dd"]
}, Open  ]],
Cell[7275, 219, 178, 3, 35, "Text",ExpressionUUID->"4d56d8b0-0dc9-4d8e-8f24-7aadd6182a21"],
Cell[CellGroupData[{
Cell[7478, 226, 394, 7, 30, "Input",ExpressionUUID->"90521389-0407-4f5b-b83c-2dfa192af078"],
Cell[7875, 235, 323, 5, 34, "Output",ExpressionUUID->"b067f8aa-a2d0-4db7-a72e-d25f55461225"]
}, Open  ]],
Cell[8213, 243, 243, 6, 35, "Text",ExpressionUUID->"361bb14a-92f1-4b86-a434-107bc9b6876b"],
Cell[CellGroupData[{
Cell[8481, 253, 264, 5, 30, "Input",ExpressionUUID->"6898e867-9167-4470-9307-d0a09e3349df"],
Cell[8748, 260, 295, 6, 34, "Output",ExpressionUUID->"e3343921-ac6f-4c7e-9332-0b6f5e608120"]
}, Open  ]]
}
]
*)

