(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    244974,       4754]
NotebookOptionsPosition[    239582,       4673]
NotebookOutlinePosition[    239978,       4689]
CellTagsIndexPosition[    239935,       4686]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[StyleBox["Fogarty & Otto, Figure 5 ", "Subsection"]], "Subtitle",
 CellChangeTimes->{{3.916480257383506*^9, 
  3.916480320087986*^9}},ExpressionUUID->"ce3ea100-ada9-4aea-a72d-\
78e89106a4b4"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{"Recreating", " ", "Barton", " ", 
   RowBox[{"(", "1995", ")"}], " ", "Figure", " ", "1"}], "*)"}]], "Input",
 CellChangeTimes->{{3.916480364072949*^9, 
  3.9164803778957777`*^9}},ExpressionUUID->"2a13ddbe-cd25-4553-a70d-\
c76cc6156fde"],

Cell[BoxData[
 RowBox[{"(*", "Definitions", "*)"}]], "Input",
 CellChangeTimes->{{3.904872250811696*^9, 3.904872267984021*^9}, {
  3.904874718886427*^9, 
  3.90487471930873*^9}},ExpressionUUID->"790defe2-6b02-419b-b7cc-\
2f37cfedc925"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"u", " ", ":=", " ", 
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"Exp", "[", 
       RowBox[{"-", "T"}], "]"}]}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"v", ":=", 
   RowBox[{"1", "-", "u"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.904872270602913*^9, 3.904872325028329*^9}},
 CellLabel->"In[21]:=",ExpressionUUID->"f65146ff-55a7-42cb-a638-c69e02837880"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{"Equations", " ", "6", "a", " ", "and", " ", "6", "b"}], " ", "-", 
   " ", 
   RowBox[{
   "using", " ", "notation", " ", "from", " ", "Barton", " ", "1995"}]}], 
  "*)"}]], "Input",
 CellChangeTimes->{{3.90487206060431*^9, 3.9048720680356827`*^9}, {
  3.9048722470895443`*^9, 3.904872248137864*^9}, {3.904966695523921*^9, 
  3.904966701029101*^9}},
 CellLabel->"In[3]:=",ExpressionUUID->"6a132bcf-babc-40df-8901-c9526e6bab7d"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"dPIdT", ":=", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "thet"}], " ", 
     RowBox[{"PI", "[", "T", "]"}], 
     RowBox[{"(", 
      RowBox[{"1", "-", 
       RowBox[{"PI", "[", "T", "]"}]}], ")"}]}], "+", 
    RowBox[{"thet", 
     RowBox[{"(", 
      RowBox[{"u", "*", "v"}], ")"}], " ", 
     RowBox[{
      RowBox[{"DEL", "[", "T", "]"}], "^", "2"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dDELdT", ":=", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"DEL", "[", "T", "]"}], 
     RowBox[{"(", 
      RowBox[{"rho", " ", "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "*", 
           RowBox[{"PI", "[", "T", "]"}]}], " ", "-", " ", "1"}], ")"}], 
        "thet"}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"u", "-", "v"}], ")"}], 
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"thet", " ", 
           RowBox[{"DEL", "[", "T", "]"}]}]}], ")"}]}]}], ")"}]}], "-", 
    RowBox[{"PI", "[", "T", "]"}]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.904872081515257*^9, 3.904872238946278*^9}, {
  3.904872339537427*^9, 3.9048723404899273`*^9}, {3.904872730537257*^9, 
  3.9048727578153677`*^9}, {3.904966505337736*^9, 3.904966513413376*^9}},
 CellLabel->"In[23]:=",ExpressionUUID->"1034227c-f664-4b49-894f-4f0ae4acec21"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{"Numerical", " ", "solutions"}], ",", " ", 
   RowBox[{"recreating", " ", 
    RowBox[{"Barton", "'"}], "s", " ", "figure", " ", "1", "A"}]}], 
  "*)"}]], "Input",
 CellChangeTimes->{{3.9048723539504757`*^9, 3.904872388552958*^9}, {
  3.9048744839400663`*^9, 3.9048744878589993`*^9}, {3.90524759663354*^9, 
  3.905247598492544*^9}},ExpressionUUID->"0d53c60a-25c0-4d93-b0bc-\
005291092123"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"PIsolve", " ", "=", " ", 
   RowBox[{"Simplify", "[", 
    RowBox[{"dPIdT", "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"thet", "->", "1"}], ",", " ", 
       RowBox[{"rho", "->", "0.1"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DELsolve", " ", "=", " ", 
   RowBox[{"Simplify", "[", 
    RowBox[{"dDELdT", "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"thet", "->", "1"}], ",", " ", 
       RowBox[{"rho", "->", "0.1"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"s1A", "=", 
   RowBox[{"NDSolve", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"PI", "'"}], "[", "T", "]"}], "==", "PIsolve"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"DEL", "'"}], "[", "T", "]"}], "==", "DELsolve"}], ",", 
       RowBox[{
        RowBox[{"DEL", "[", "10", "]"}], "==", "0"}], ",", 
       RowBox[{
        RowBox[{"PI", "[", "10", "]"}], " ", "==", " ", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"PI", ",", "DEL"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"T", ",", "10", ",", 
       RowBox[{"-", "40"}]}], "}"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.904872549756247*^9, 3.904872549760933*^9}, {
   3.9048726124255466`*^9, 3.9048726378647423`*^9}, {3.904872682217321*^9, 
   3.9048726977194443`*^9}, {3.904872918689548*^9, 3.90487296319888*^9}, {
   3.9048729972401867`*^9, 3.904873005385723*^9}, {3.904873353676889*^9, 
   3.9048733538350573`*^9}, {3.90487355199867*^9, 3.9048735768441973`*^9}, {
   3.904874257561905*^9, 3.904874293402482*^9}, 3.9048746079660997`*^9, {
   3.904966522220409*^9, 3.904966525630322*^9}},
 CellLabel->"In[25]:=",ExpressionUUID->"152073d1-15c5-4def-aad7-7ddf1de1a8c8"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"PIsolve", " ", "=", " ", 
   RowBox[{"Simplify", "[", 
    RowBox[{"dPIdT", "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"thet", "->", "0.1"}], ",", " ", 
       RowBox[{"rho", "->", "0.1"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DELsolve", " ", "=", " ", 
   RowBox[{"Simplify", "[", 
    RowBox[{"dDELdT", "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"thet", "->", "0.1"}], ",", " ", 
       RowBox[{"rho", "->", "0.1"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"s2A", "=", 
   RowBox[{"NDSolve", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"PI", "'"}], "[", "T", "]"}], "==", "PIsolve"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"DEL", "'"}], "[", "T", "]"}], "==", "DELsolve"}], ",", 
       RowBox[{
        RowBox[{"DEL", "[", "10", "]"}], "==", "0"}], ",", 
       RowBox[{
        RowBox[{"PI", "[", "10", "]"}], " ", "==", " ", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"PI", ",", "DEL"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"T", ",", "10", ",", 
       RowBox[{"-", "40"}]}], "}"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.904874273874234*^9, 3.904874277497774*^9}, 
   3.9048746139089203`*^9, {3.904966528162019*^9, 3.9049665341013193`*^9}},
 CellLabel->"In[28]:=",ExpressionUUID->"9b5f4063-a23a-4fb8-9942-1e60d2a06497"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"PIsolve", " ", "=", " ", 
   RowBox[{"Simplify", "[", 
    RowBox[{"dPIdT", "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"thet", "->", "0.01"}], ",", " ", 
       RowBox[{"rho", "->", "0.1"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DELsolve", " ", "=", " ", 
   RowBox[{"Simplify", "[", 
    RowBox[{"dDELdT", "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"thet", "->", "0.01"}], ",", " ", 
       RowBox[{"rho", "->", "0.1"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"s3A", "=", 
   RowBox[{"NDSolve", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"PI", "'"}], "[", "T", "]"}], "==", "PIsolve"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"DEL", "'"}], "[", "T", "]"}], "==", "DELsolve"}], ",", 
       RowBox[{
        RowBox[{"DEL", "[", "10", "]"}], "==", "0"}], ",", 
       RowBox[{
        RowBox[{"PI", "[", "10", "]"}], " ", "==", " ", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"PI", ",", "DEL"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"T", ",", "10", ",", 
       RowBox[{"-", "40"}]}], "}"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.904874275121776*^9, 3.904874306956203*^9}, {
   3.904874361317594*^9, 3.904874361387533*^9}, 3.904874616709448*^9, {
   3.904966529961089*^9, 3.904966535881106*^9}},
 CellLabel->"In[31]:=",ExpressionUUID->"97652ce3-8e85-4528-bd89-1e6858c95380"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Evaluate", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0.002", "*", 
         RowBox[{"PI", "[", "T", "]"}]}], "}"}], "/.", " ", "s1A"}], "]"}], 
     ",", "\[IndentingNewLine]", 
     RowBox[{"Evaluate", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0.002", "*", 
         RowBox[{"PI", "[", "T", "]"}]}], "}"}], "/.", " ", "s2A"}], "]"}], 
     ",", "\[IndentingNewLine]", 
     RowBox[{"Evaluate", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0.002", "*", 
         RowBox[{"PI", "[", "T", "]"}]}], "}"}], "/.", " ", "s3A"}], "]"}]}], 
    "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{"T", ",", 
     RowBox[{"-", "40"}], ",", "10"}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "40"}], ",", "10"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0.00201"}], "}"}]}], "}"}]}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"AxesOrigin", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "40"}], ",", "0"}], "}"}]}], ",", "\[IndentingNewLine]", 
   RowBox[{"AxesLabel", "->", 
    RowBox[{"{", 
     RowBox[{"T", ",", 
      RowBox[{"2", "s\[CapitalPi]"}]}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.904873153800063*^9, 3.9048731761585693`*^9}, {
   3.904873228215217*^9, 3.904873254470806*^9}, {3.904873318526799*^9, 
   3.904873322948452*^9}, {3.90487336149325*^9, 3.904873365715081*^9}, {
   3.904873712498666*^9, 3.904873740892362*^9}, {3.9048743195934668`*^9, 
   3.904874351306569*^9}, {3.904874389969171*^9, 3.904874413604905*^9}, {
   3.9048746206949463`*^9, 3.904874624348497*^9}, {3.904875179872344*^9, 
   3.904875203192885*^9}, {3.9048753969116163`*^9, 3.9048754223441668`*^9}, 
   3.90496331256145*^9, {3.904965891973748*^9, 3.904965907485278*^9}, {
   3.904968542050825*^9, 3.904968570704104*^9}, 3.9049686525133343`*^9},
 CellLabel->"In[34]:=",ExpressionUUID->"fdbfc5d2-4125-454a-b15f-d664987ddd4c"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwl2nc8lV8YAHCbrOy9rp29N+ckJDIico3rhiQSJZSs0kKplFCoVEohK6ty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       "]]},
     Annotation[#, "Charting`Private`Tag$5910#1"]& ], 
    TagBox[
     {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwV13c4lV8cAHAze1/uvea1Slb21jkh99ojK+O6DQ0NSigj0tZGKFI2JRn9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       "]]},
     Annotation[#, "Charting`Private`Tag$5910#2"]& ], 
    TagBox[
     {RGBColor[0.560181, 0.691569, 0.194885], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwV1nc8lV8YAHAze+99cY3smcxzjKR7uWY29yYtRSEU0tBCSra0RYiEhvTj
njQoERlREikjsrMyfuf+9X6+n/d5z3je5zzvqxh02G0PCxMT0xozExPj+vDR
kcWNDVu04kiLv9lDAUf4dI5zrduihx3UPSufKUA/ZHxFeNUWnTJAFE/sx8p7
11WWbNGlpQIl/m4KqM32Y3ectkWnVf+1nuiggDfx9iK5A7ZolYfNLKCVAvoc
ZHX1XtqiKlGar+xrCuAZbNxLO2OLcmOtm/MrKED51iG67ooNaoUyB7UT8f37
/xLZ42zQ40Z95xofChCuhf0+69bI0P7VlLQ+BXT5dijKxVijFM59bmLsFLB/
m0v78BJEb7Im6Zx9TuBpnXSIwhGInIKj6rMrnMD2M1v0yzsASkj6uHsj0Qm8
kuXdq95rhcLv2yXT/HD8p/jQ0+8skeAZ4VCarhMgyTY4jjRboMnefxe8NzkB
2fhIL1KHOSpxVfmg0e8IghfpRilvzNDqXAnxdpUjcNo0ONbzzhSlqgmk8CY7
gnK9G+Fsz7ci1fMGpQqBjoAc/oaoXW6C4N8MHkFDR5C8raEiqHoLmm1UbP3L
7QiAsS9f9D1j9IDDOejCdzLIqnlrk33fCIXdUnvC94wMgrxaSZlZhsi5y9/P
LoUMQnltEq5cNEBqD4U2+dHIQHJnclJOqj6qf99isG8rGZg9D9134oQeOjgR
edqQjwyWd5HNBtZ1kNfqog/3LxJYPpGxSufVRieEJCFTPQmMtAkF+01roJbC
Jo7kTBJoCwvbGjuqgXrteffPZpBADW8zb96ABsq4Yjzqi53scPZJd5sGemYh
TdJKJwFttLDJrVIDeW3yuNN2hQQiK76WOERooEn2HG5CCglspBZOGc9vRjIU
uPztNAlIkE3jBJfUUYP1wPONwyTQ91LD6vyUOrrgRHtxAPv2Vlnm1WF11Ezm
lO8MIwF11Y3zI13qaG1wmLc0lATMmN+k11ero3tW+q99D5JA4DOX0kOH1dHL
yWqz9r0kUKS8v7dpWA0xf500IASSQMg1n+tW/WqowPSL7LUAEtAVIlMfd6mh
i8qHH4hi16xr/7r1Wg0FtR5APP4k8L53bjr6rho6N6ElxeJLApNXTnKqBKqh
Q1/HPIU9ScB4NdvkdJcq4nhU8ryHQgJlHUND8i2qqDX9bMJhbKUHemn/vVZF
x/m8XTiw+X3fjy5WqyJDJm5NMycSGH22lheWroruJrIZlJPx+q+Q7HmTVZGs
Q2S3I3bX3pzZktOq6ELORNkfEgk0iOmTfx1RRYcO6bMbYl+PDF71c1ZFrKx7
Fz84kIAwubJ42V4V3TJMQdHYSUrrHjlWeHwpwrAidnR7TvknbVUklt/sF7+d
BJx1mwN38KoizQ+9F23sSeDtJkmeEVZVZDFGbFvcRgIW/cHPzv5TQYXXrAse
Yqunrgug3yromtcXDkVslnH9l1veqaCOc3PnpexI4FhDQmgnUkF7rxqPfbUl
gam8ZqmIGhV0/qA8323sPoc9EeX3VVD+9pXH2thuhCp58i0V9Djv9fZFGxJo
Wlx/P5qtgiQduGsbsJ8U5SoTz6ug7uPCgVRsrYRfH1+eUEEWAb639bDv7jSI
p0apIJYA9SFW7MtsHzqvBaug5vBdKY+sSYCtT/L0Vn8V9HnYlTkZO656j3a3
uwry29qRuwd7f9DGOSFbFfS+Kd1JGbvf1NGgwkwFSW3NiWPH3imU1+9ooII2
1TFPjkES+DD6K/n3ZhXUmzD7sA3bBhmYXFRUQV/vJTU9x67JOTmkIqWC3D1H
7AqxdQ5/uPJKUAVdqNXUycC+Zy9lsYtTBaGl6MuJ2DLye0fXN4jIfuvY4Wjs
9L9VmdcXiSjw9t2+g9icLRvQbIqI3L1f9e/GTrjn+OfzMBEdvHDwVCD2fFxe
XlQ/Ef3xeNHshx3iPrxNpJuIjP+1v2d4UMNw9lELEWl8173IiPdmOXWT8oaI
nF8MCQRjt/Z+IE38R0QOXq5hh7B/7OwJkH5CRD84L3cz1vO3feiIQzkRZcV8
aWasl5MylRhdSESJ3nbejP3Ivl/JvneDiLpovecY+9W131T6KYuIHm67H1jL
yE+DUB3TZSIy+u/FRDu2p5Vcm855Irp0nGg2gX2gVn3IP4GIvhpMuXDhfMdv
MVpIjsbrubHZfDN2WhXgeh5GRAuhgyyO2AU6ZNmRvUSUU0GsCsd+WuqpK0Yl
oqXAQfdr2O9Vg2xsvYioM3LH/Bvsb3dDd4Y7ExEMLrg1z6iH/LNxLYCIJB7Z
O/jhepGUSLv8z4SIHizKBmZga2bk39msR0RKc+sVrdhuKVWN5whExNq/sdUZ
1+tejvov1ZJ4/ucPLmZiH09892dQEL8vxRPbvmHfjhsQsWImop7QUpPj+Dw8
XhxXPbSsjJyZr537gN0YuWh6bUYZyWYqRCrj8zN5kJ+2MKiMessy9/dhm/tb
lD1sUEYG5Eoq43xSerbT+2qxTyU7TmIHebh/4q5WRpejEl2C8Xm+6BiytLdA
GaWSbvX678D9oCmKJytfGTUm3I//jl1hd1r+VQa+L3stYi/uF90WuXYKZ5VR
F1096zTuL79rCryc4pXRLFvNTzFHElgzqgiJO6qMQjzdmh9iE7Xfpn0OVkae
BlZFk7hfRcjN913ZpozKfPiuFLuQwPm8jak6S2WklCqQsduVBPLEeFgnjJXR
x3kHurIbCSA+pc0Oqsqo7uhiT7U7CfCtO0cxcSijQ+nmRmJeJECI9buos6GE
vnI9uPYP22hhb77/ohLaf9Pxw4g3CfhOnnhZM6KEmp17Rtpx/y3uf8AX3qSE
bmnMBE7hfp5j6CiwQFdC7Sxa/vI0vJ6LE4Jxz5RQSCnxn8cuEgg20BY9V6SE
Lq1RbvfuJgHF8w+l884qoXz+b2J2B0hA8CtFVj4ex7taVVSHkACT3pRcQaQS
6kwPn9Q8hPtBr65ieZASmgXRA1vw9+iadqXaS6iEInT4omujcH8947rZfqsS
knxbLBwZg/vf5xmNZl0lRB0diTE+juv9tIFOl7wS6l+/ZdQTTwIiXdVGY6uK
yG69tCDvLAlcin9qLfRcEZGI4jN62bg/tXvaZj9SRDvuNCrl5eLzrLpoJ1Os
iPit4+l8+STg0GbioJKjiPz+JC/K3iYBduJzimmUIlLrcl3tKcX94JiPS/0h
RZRmnbtWUk4CP1uWXW2DFVGvl8PGxUf4+xFjttPJXRF9F4lqD3+K+0nzC79d
+opIV9socr6BBEIJ/gHD6oqoMea5vflbEvCPWg08SFBEa2H1nVff4e+tgmVQ
lIAietx2j/dwGwksRtTvT/pDQMeo4UHT/SRwRPplVGUJAe1IT1202yCBVRFC
/9s7BOSWabLVh5UMLvKdtO/LIyBjSZ87CRxkcJvJUoIjmYASzUlNawJk0D5c
U+MfQkBVyp9bOxTJIHBAQjEiiID6RvYVx6iSwe/e6KQLvgSUQFC5oKNJBiwt
Rr5VJALKPuBD7jYiA4PqR/84NAmostGhUnQHGdSXCQTLKRPQ2+TmWC8KGZCK
wj4YyBBQ3Y8XNhXuZLA7T+tGAA8BDfbqDN4MJAO1DZcTez8rIPk7tO/novB8
OZC1zlsBKe3ad6HiPp4vZb1jxEEB/Tdq9ynoIRnIJPx3T9hUAUW9U7ys+4QM
HIO32u+XUkB/WSrOi78i4/8/vSSRL/JI99XJ/5QGyODIOwWBED95JLHS3nhM
wRFc/O/b90yyPDprnhc1ouYIblfkP6KbyyP/EzJnjuo5gvYsCTcxWXkk3mrH
NG7tCAyCBLJQnxwaX17qcNvrCP6urEtLBMoh2v5mSe8njiCiIrL+KkUOKR0V
F79FdwSTu0d38QI5lPqCO5DzvSMY/tBezEyQQ9QHV0RtvzuC7pv3tkwMyiLW
9sPcQTxOoMaG5PZyjyxyJs8lpYY4AaPF+r/mnrLo2uOYUIUYJ/DogWHeU3tZ
1NgmWdmD/5+LReUGHqjJImiQd73hhhPIG54KzR6TQRbCi6XxHU4gNjkr6WCo
DDr15EX/B3sKWLDi1h4OkEFtcmfclndSQMRcQhuNIoMmQy78dt1DAQf990t4
6sog8Uc78i6epQB/HfNCOCONvrUkHRZ5QwGWnwaQWJQ00i34+aaH4gyYpLWW
6PFSKEwi44iLrQswOvX+2OhBKVQsdzrtHcUF7BvevyzoJ4U01YfDaL4uoLWq
cGWXqRQqTP2YNBLuAm6QFdZYFyRRb6SJpv9dF2B2QpjF4bAkWpzZwfaT0xUc
HVjiadslgQqlF/+qTLiCYvucS0suEiiix+A35Z8r+FpmzKcIJVD8prX6DG43
YHM8gj9CXgKlRVsYH9nsBoSEJwRFv4ojtLbndNh+N/DQ9ruYt4c46uweSiSP
u4GRojcKA/ZiiOVzop0Piwfw8BwM3Wwihm5vMXO0FPEADexrLyLUxFDNMCVd
j+gBbgYbebNziqHmsNwgW3scr1SQpvFOFL388q9GIAXH3zjFHEUWRfDLdqPf
4jvB9UzzIS4XEcRyxQRUG3kCbjsvfXcogtQuKFx6Yu8JYuYiTl7XE0HT40+z
n3t7Aje3UhldIRHkeVhb7E28J+ASlPLw+CSMbI2+S3x77QmiUxZe3/QQRm6V
5WllHl7A9UxlkaGPECokuA7UHfYG0UML7RoOQkiFJuyVccYbXLezWFM0EULb
dxR3+mZ5g+FNje6CYkJI++LoSl2tN4hN6WP60yaIVORjZxvZfMDdTA6/IgdB
ZBLjpJWS5QNGnV7IGxzhR1mDTL+M7/sCA0H7KAKFHx06UNFy/pkviP/U1syv
xY9S6yoP1zf6AiGv4WPjI3woykt8ZmDEF5jRhDruUfmQ75eLeX9U/UBKxL4L
Es68yEzs3Vam235AJ0dkelWbG43XqdhuP+EPJsZzB7X4udFA8uk81yR/UArl
O/wnuZDJo3uGtln+QO23+tP/HnIh7rgfBn1l/oBgaRUfr8uFpiJ2bx7+4g+E
h/ZzrupxIjo74NptEADaTCaXNYU4UdVU99FfFgHg8qXIcb8ZDnRc6eFn5+0B
gGdLQuuLSg60rGz6sc8vALAlZWTGGXCgNZ/+672JAWBRp57wz3ATemGd2xPx
MQA8TbQV1hTdhPjuUccTegLA0Z4mVr95duTwZHvY0cEAMH26Y7j2MTt6KlMJ
ZOcCwO/O0bJYY3a0GiEfHiQWCPpiRUxXtrAhZJIW+nNnIEBv97sum7Ig618z
YmWNgcD+pt9okzQLUiNn7mVvDQQfoignc/8xo723++SdOgNBD9Go3KSOGc0G
5bsWDwSC6TMbnNGQGVVRYi5fXQoEBJCNZu2ZkMF1qX4nFSooEk/yalBjQnQU
vXxDgwq0JuMmr3IyoafrFcX9ulRwxOzV1qDMDbrgi91OBmZUcGvBZ7r/2jpd
PtzwkCqFCtbDLlB77q/Sn58i5lIjqYBbPjQ15sAqfd+hS4NNMVQg3uL2Qlxz
la61m7eXGE8FOpryEjsf/qNX3dzl8eQsFQSMPG5tf7xCL468zm2RRQX/UX9Y
Nr9cok/OlWiuVlNBE3/TwZDEJbqK2CvyrWdU0FlXnse1bYl+Re6ekMkLKpiQ
Of53e9MiXZDrONu2BiqQ7REof926QGc9ffnRt49UEOdiKVv/dZ5OedLvKjNG
BcFv39WL5s7Tr13yi/ecoAKKheeugx7z9OxxjaDzU1SgpH64SLJljt77RHDs
9V88/8Ztvcj6WXqVNofTABMNiFewbVO/M03f2SlDGeGhASaVqyMJAdP0PMuW
wwZ8NDB2TS65S2qavkUwbvIYPw0c5wu9ya4yRf+W1mmxJEgDb/9rq6rl+EMX
VaivfilGAzSZ3K/EllH61F1H+0vyNGDIUUn4tG2UHto83Z6hQAOb5t7tOVk/
Qm9N+ZGVQ6CB8vf/pnorhulvL31ZyVCigZXjVLYr6T/pK+SyS7tUaSCrR1V7
2WuALspbNuWjTQPtF0/+dLzznf5O2y5PQ4cGjtEqw+6n99PrTVyNlrDfCIgl
+kf10acQdV+yHl5PWN+Dt2Y9dNu2vd9SDGlA06t7xTjlI/2UqmcDjykN1GoP
1bOlt9Dv7L7hUIjtwDZ9piO3mX46/WaphRkN7K3k4gkvaqTPF+TJ7zGnATuJ
2C3eiXT67W6dKzcscb5ubhwRitEFJiWjblXWOB+kOJZjnGkgm/N1g5YNDThn
i/5g/nQLXFynxBRiV2YXtCVXVYCZJtHGq7Y08EN8fPvHu3Qwztlx3XMb3n/3
5cSZax9BUahRb5YDDWxhekkVet8G1A8U6CxiT2bWrpW8bQcx2uPyXjvw/urL
Tb/SO8CdT6k/hEk0YCOUWWlZ9RkI9PfFxJJxvp/R7rDkfAf16ZHf+Cg0MKBS
fqtlxwDg2Z7P6odtMV0yKdU0AMLKl7jvY8+fLbhU9XoQWJ/TbTF3xvt/mN00
VDcEnr9KuuztgvPDfALaPxoB/lNXtwW54fqw1CpSNh0FdRlKHvewk2O/8jA3
jALWuZ2ev7Cb50w/v+gYAwGxXfbB7jRAGV4I1V8cBzvehDp4etDAlFJRB/+p
CXBKUXVPGnYadafpBOcfEG2dkPkOu72nmu2+9CQIkCo0Nd1JA6V7apz4FaZB
m9lPVn5PnC/WNKYTu6eBRZyljDU2+e6+6vH700DrPW1XJPZEv7jUO70ZECoa
cL4LW8c76meizSzwGEhLSvPC74NkELe8Zx58HKHJ/PSmAZYxLp39pfMgbkQn
iceHBtwuDA50T84DMj+fhwH27Ks0+8cxf4GWeRBPAraR5ZTQ4aQFMDjGtIPf
lwbOfn37+lvLAhj1VxvRw+46fjPGUXgRRJVu/HXDjn7q9G1z/iI43hMQloVd
o1tW/LNsCcTkLLGL+tEAZ2uin/vMEmBf6NpjgO1zyI+/wXgZNBhnbXfBXinm
PnqrfhmkerrmJWObKx0Avm0rYLagoWwZu15Utfvj3CpINXOSeeVPAyfLlaw2
tqyBG17n+L5gQ3uFIp3YNcAfzXZ3GrshRjI6lWkdfAireSYbQAONX7jFyXwb
4MB54RdHsC9GciTEumyAxJTZX2exSbxswyUZG4A2MViXiz18c92XjY8JaomY
xtKx97ctauzOYII3Jdt3cAXSQJPsQv/KYyaY5SPHIoO9+cB8eno3E3SWexau
hf2beWblpRQztPorHEfBPmT4+z3hNjN0pGl4XME+kt0X0l/GAqkiB/nYqTTQ
9uOLfHQrC+xMBM+FsfV1ez/xTbNAjswqLQL2bGOXmaUhK+z17ws1wz663Mp9
/TkrpAiKhR/C7tzWUm/4lRX+WX8cfgzbOL05onmVFd5WeAXPYi9oNH1ZAWzw
KLrqlI99zP9lqc9bNniG9YNJI3ZPMT1wZoQN3nfte9mObfq3TjiJix3qbiIR
+rBXUmtjaxzZoQHPov80djy9miTRwQ6vBZWMitNo4JRS0e/O75ugwI9fff7Y
h/pKWDU3NsG7sqzhwdg+2eWyp+U5oNe+VyMHsQ24n1C0AzjgH+pMQiz20Myr
qnNfOKCvNY2Wjd32oLH56zIHHDWfE7uB/d+e5p/6Upxw+tn9ygLszN5P4v1e
nDDG4Pv1R9j2Lwdjt3Rxwl2pexzfMcaP+5VxaZ4Tnvzw0+IjtoLxWNkPES74
+oSXeBf2UvF0/2U3Lvh25eS5AezStA2bkY9ckFBVG7iAzUeT48l9zw1NDg7Z
ye/C+5dSJE6OccM8OYkJJezhDqKlHRcP3HJly2k17PrtWoent/NAblPvaD3s
I7rmHQ5veCA7YSPDGtt/zGri5k8eeFbTq2ob9o4CG/a/rLywgPQc7cBWkiCZ
3LHhhQfopx66Yneue+cv03lhUzC1k4aNavwfO3/nhTOTpOPB2OURtJbCdV4o
eJZbcD/2+eF9G66WfLDv/W+Rw9gmrdG7S2v5YPYENS4e+9qNTE2/J/zw5Mrb
uUxsyXm75J2f+eHzMRueXOws0t9R52V+OPjgiVg+dtriziI7SwHY/G8f2x3s
C64SijpvBOAuU27nMmy24saT6iMCcOySGVsFtvWG+eGrbIJQLW+tvBKbvnOi
JUVVEIoVzX9/il3L4pRyKkQQ3pd63ICwl7ULa0/ECcLh2guKr7C3+qyNxV4S
hGEl1Og32E8qyh2iHgpCJZZWlvfYj/z5N4XMCkLm+cbST9hFTz+eco8VgkdD
3nn9wP41qPbIJUUI5rpPqv/EJvKd+u50XQgulOyd/YV9Z7eelUO9EPR61xw2
hn1d8Oo/CxZhGLNRLziN/dV8TMNMRBganuy+P4Mtvc/a14QoDCUbjLfOYefU
zdTo2wvD6FbbbQvY6SFu0arJwlDVOFZkFbs9q7RQOR8/v/ouZg1b8CVLF6FM
GI4KGHavY6dKVBvKtArDCc0np5mDcP95LTIjICwCqT5G2ZuwE+S7Di7niUAH
i/omAexEpkctXSUiMPVvaqMgI/5Hsm7VcxFY73yoQQj7ahGcC+kVgY5mOWUi
2Pd0ymL7JEXhnSrgIYFdInihr0ZdFNb91DCWxH44u8sqa6soXN6SKyyF/eyp
BAvFWxSGftJ9JY393ioxiZ6Dn2dtX5XD/kgIHM+/LwoJG6RX8tidLKZOx56J
wrWxyvMK2N/eTgrqfxaFzuaRbIrY0xTf3LviYrDv3mqfMrYYVf/+uSwx2GUw
yrMZW9qalyuoUAxK7NhVxLC88kiI1RMx6DQTbqWBrT5yXWexE8enJuzTxDY7
zPl0v6g4JIhsu6mNDVyHJLYRxeG7zlhVHWw7w/rjikbicMzjahnDTouRll/c
xWH3ljNVuti0k99fkzPEYSBte5E+9p5dtarqBeKQOBoob4AdYpt1ka1aHOoM
ZWYyHMlBdqz7JA4Fz8TGGWKfv/K0Q0dYAtY0rRoaY5fdSv0hdFUCqikW7NzK
mA9Vht+8LQE3hQlVMjw50MWk+UgC9rlL8Jhi6ynJK9h9lIDdWuu1DFffe+gX
zScJa8tec5tje7z59JtFThKKN8T7MTz/a+H4FS1JOFY6X8rwFjWQW0yWhG94
t9pbYNeWfOz8kiQJBSUzwiyx/d7P7d6XJwn1/T8+YXj1t8TcXLEkbOyd+sew
lRZNiK9JEsb4TJ61wn75cNoJbJKCa+5eyQC7qVqoseCMFOwNc9prjX2g09hT
L10KSr4sv8Ew91+fX//dkYIr53U7GXbccpe1G0lBn0uFVjaM+qgxgJwbUtBE
4imXLfaRXs+PmfzScM/4CTOGBVdiAxXlpWG0z6kQht3MX8WbWUrDbX2wieHu
Ovfnh+KkoSmNNc4OO6Y/xmE5WRrqnJotZFhyI//zuWvSMJPbsI1hX/jz783n
0jCLUqW0jVF/DUcN2hel4TmlKTrDPxuzHhgflYHW/We/2WO3bkkLED0nA6P/
HGPezqj3wmSBuSwZWJbUTGQ4OfFk5KNnMtCdP+cAw3rggLnmPxm4Kis0wbD0
w91/uHhloVWuDY8DNqtc4K1RWVnInzG8meHuFTfWIitZ+OXv5T0Mxz21aCac
kYXH/97qZjhYxeTERrosTJ4pmGGYkqmv218gCw8oaPHuwCZEqGbkv8HjZbcB
ht9qC/qJc8nBnftu3mFYuHDoN0+aHNTcNOFCwv51pofyrlIOKgZ3HmO4htZS
db5DDjIP2d1iOFD2WSyzhDysUp4eYVh/5UF//VZ52DpkzU3GZuu5bRPvKw/P
y5I0GS7JSOZevCEPZ8eLDzAcH34y7DFdHvL9E7nAMMX56KfwQXlooRhYwPA8
d+C1CaICLDd40sMwPKOv8eOBAmxpDjJxxF6XVP2v97cCNP+TFMhwvxff/VFR
ApwRbjjDsEUBx5FgIwIsYze9x3D+JLPpgDsBNtdJvmJ4xXSV2T+SAIMfJH1n
2PvcwvvP6QSol1C5zPCztukM9yoCdO6uFnLCFpcd9//YToDWhVVqDHdWfZ98
K6gIo3KUKAyn7+g8Ve+sCGMlJ0IZdhloEn56WRE2nR28wDBfTN298hZF+J6K
rjP8Qxa+7B5WgsYllh8Yrmlo+LaxoQxXS2Y+Mfw//bhkyQ==
       "]]},
     Annotation[#, "Charting`Private`Tag$5910#3"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{
    FormBox[
     TagBox["T", HoldForm], TraditionalForm], 
    FormBox[
     RowBox[{"2", " ", "s\[CapitalPi]"}], TraditionalForm]},
  AxesOrigin->{-40., 0.},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{-40., 10.}, {0., 0.00201}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.904873183375781*^9, 3.904873193481228*^9}, {
   3.904873228903338*^9, 3.9048732549583073`*^9}, 3.904873324687694*^9, {
   3.904873358060693*^9, 3.9048733661022253`*^9}, {3.904873560083871*^9, 
   3.9048735806603413`*^9}, 3.904873742201969*^9, {3.904874365996477*^9, 
   3.904874390461873*^9}, 3.904874448673882*^9, 3.904874625699533*^9, {
   3.904875182266406*^9, 3.904875203722095*^9}, {3.9048754148812523`*^9, 
   3.90487542365274*^9}, 3.904963314369766*^9, 3.904965908400234*^9, 
   3.904965947752781*^9, 3.9049665429791613`*^9, {3.904968543908119*^9, 
   3.9049685713453293`*^9}, 3.904968653953176*^9, 3.9049693493131037`*^9, 
   3.907051680842308*^9, 3.9151088755886917`*^9, 3.915674086572607*^9},
 CellLabel->"Out[34]=",ExpressionUUID->"3d19b43e-2f33-4e97-b93b-01979b50dbe3"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{"Numerical", " ", "solutions"}], ",", " ", 
   RowBox[{"recreating", " ", 
    RowBox[{"Barton", "'"}], "s", " ", "figure", " ", "1", "B"}]}], 
  "*)"}]], "Input",
 CellChangeTimes->{{3.904874498439013*^9, 3.904874511323798*^9}, {
  3.905247602843142*^9, 
  3.9052476044115353`*^9}},ExpressionUUID->"a3c6f36c-8c8b-45a6-9c1c-\
2fdb2f89d1a1"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"PIsolve", " ", "=", " ", 
   RowBox[{"Simplify", "[", 
    RowBox[{"dPIdT", "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"thet", "->", "1"}], ",", " ", 
       RowBox[{"rho", "->", "1"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DELsolve", " ", "=", " ", 
   RowBox[{"Simplify", "[", 
    RowBox[{"dDELdT", "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"thet", "->", "1"}], ",", " ", 
       RowBox[{"rho", "->", "1"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"s1B", "=", 
   RowBox[{"NDSolve", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"PI", "'"}], "[", "T", "]"}], "==", "PIsolve"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"DEL", "'"}], "[", "T", "]"}], "==", "DELsolve"}], ",", 
       RowBox[{
        RowBox[{"DEL", "[", "10", "]"}], "==", "0"}], ",", 
       RowBox[{
        RowBox[{"PI", "[", "10", "]"}], " ", "==", " ", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"PI", ",", "DEL"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"T", ",", "10", ",", 
       RowBox[{"-", "40"}]}], "}"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.904872549756247*^9, 3.904872549760933*^9}, {
   3.9048726124255466`*^9, 3.9048726378647423`*^9}, {3.904872682217321*^9, 
   3.9048726977194443`*^9}, {3.904872918689548*^9, 3.90487296319888*^9}, {
   3.9048729972401867`*^9, 3.904873005385723*^9}, {3.904873353676889*^9, 
   3.9048733538350573`*^9}, {3.90487355199867*^9, 3.9048735768441973`*^9}, {
   3.904874257561905*^9, 3.904874293402482*^9}, {3.9048745434778347`*^9, 
   3.904874545716667*^9}, 3.904874629644218*^9, {3.904966552771987*^9, 
   3.904966566539878*^9}},
 CellLabel->"In[35]:=",ExpressionUUID->"ce3bb2ea-2881-4b8a-a502-c9442a124600"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"PIsolve", " ", "=", " ", 
   RowBox[{"Simplify", "[", 
    RowBox[{"dPIdT", "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"thet", "->", "0.1"}], ",", " ", 
       RowBox[{"rho", "->", "1"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DELsolve", " ", "=", " ", 
   RowBox[{"Simplify", "[", 
    RowBox[{"dDELdT", "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"thet", "->", "0.1"}], ",", " ", 
       RowBox[{"rho", "->", "1"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"s2B", "=", 
   RowBox[{"NDSolve", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"PI", "'"}], "[", "T", "]"}], "==", "PIsolve"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"DEL", "'"}], "[", "T", "]"}], "==", "DELsolve"}], ",", 
       RowBox[{
        RowBox[{"DEL", "[", "10", "]"}], "==", "0"}], ",", 
       RowBox[{
        RowBox[{"PI", "[", "10", "]"}], " ", "==", " ", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"PI", ",", "DEL"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"T", ",", "10", ",", 
       RowBox[{"-", "40"}]}], "}"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.904874273874234*^9, 3.904874277497774*^9}, {
   3.9048745467496643`*^9, 3.904874548244882*^9}, 3.904874633364594*^9, {
   3.904966554664205*^9, 3.904966568353211*^9}},
 CellLabel->"In[38]:=",ExpressionUUID->"aa222cc9-053e-4b08-b61c-148caaa3ea53"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"PIsolve", " ", "=", " ", 
   RowBox[{"Simplify", "[", 
    RowBox[{"dPIdT", "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"thet", "->", "0.01"}], ",", " ", 
       RowBox[{"rho", "->", "1"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DELsolve", " ", "=", " ", 
   RowBox[{"Simplify", "[", 
    RowBox[{"dDELdT", "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"thet", "->", "0.01"}], ",", " ", 
       RowBox[{"rho", "->", "1"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"s3B", "=", 
   RowBox[{"NDSolve", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"PI", "'"}], "[", "T", "]"}], "==", "PIsolve"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"DEL", "'"}], "[", "T", "]"}], "==", "DELsolve"}], ",", 
       RowBox[{
        RowBox[{"DEL", "[", "10", "]"}], "==", "0"}], ",", 
       RowBox[{
        RowBox[{"PI", "[", "10", "]"}], " ", "==", " ", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"PI", ",", "DEL"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"T", ",", "10", ",", 
       RowBox[{"-", "40"}]}], "}"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.904874275121776*^9, 3.904874306956203*^9}, {
   3.904874361317594*^9, 3.904874361387533*^9}, {3.904874549621879*^9, 
   3.9048745510209513`*^9}, 3.904874635869874*^9, {3.9049665562414713`*^9, 
   3.904966569898932*^9}},
 CellLabel->"In[41]:=",ExpressionUUID->"c8761349-1089-4c55-84f3-b61ce81ca1ed"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Evaluate", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0.002", "*", 
         RowBox[{"PI", "[", "T", "]"}]}], "}"}], "/.", " ", "s1B"}], "]"}], 
     ",", "\[IndentingNewLine]", 
     RowBox[{"Evaluate", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0.002", "*", 
         RowBox[{"PI", "[", "T", "]"}]}], "}"}], "/.", " ", "s2B"}], "]"}], 
     ",", "\[IndentingNewLine]", 
     RowBox[{"Evaluate", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0.002", "*", 
         RowBox[{"PI", "[", "T", "]"}]}], "}"}], "/.", " ", "s3B"}], "]"}]}], 
    "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{"T", ",", 
     RowBox[{"-", "40"}], ",", "10"}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "40"}], ",", "10"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.0018", ",", "0.00201"}], "}"}]}], "}"}]}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"AxesOrigin", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "40"}], ",", "0.0018"}], "}"}]}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"AxesLabel", "->", 
    RowBox[{"{", 
     RowBox[{"T", ",", 
      RowBox[{"2", "s\[CapitalPi]"}]}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.904873153800063*^9, 3.9048731761585693`*^9}, {
   3.904873228215217*^9, 3.904873254470806*^9}, {3.904873318526799*^9, 
   3.904873322948452*^9}, {3.90487336149325*^9, 3.904873365715081*^9}, {
   3.904873712498666*^9, 3.904873740892362*^9}, {3.9048743195934668`*^9, 
   3.904874351306569*^9}, {3.904874389969171*^9, 3.904874413604905*^9}, {
   3.904874639749733*^9, 3.904874685612629*^9}, {3.904875148901238*^9, 
   3.9048751569836617`*^9}, 3.904875207697083*^9, {3.904875256728545*^9, 
   3.904875280727991*^9}, {3.904875431297865*^9, 3.904875432969178*^9}, {
   3.9049658596981983`*^9, 3.904965880160019*^9}, {3.904968313920435*^9, 
   3.9049683390136147`*^9}, {3.904968579921507*^9, 3.904968584909513*^9}, 
   3.904968620007092*^9},
 CellLabel->"In[44]:=",ExpressionUUID->"3ff8df52-83c9-4d7a-bdcf-3474e5cb1984"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwt2nc8Ve8fAHB7j2vv67r23jvOYyYrWSl0b0Iio0RFGopCS7YkSpRQaEjl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       "]]},
     Annotation[#, "Charting`Private`Tag$6161#1"]& ], 
    TagBox[
     {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwV13c8VW8YAPBL9urea+9rJNlbiPcNSSShUtG9VzslomRmVQotITOVCEVR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       "]]},
     Annotation[#, "Charting`Private`Tag$6161#2"]& ], 
    TagBox[
     {RGBColor[0.560181, 0.691569, 0.194885], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwV13lcTN0bAPD2vTQ1zUzTNE0LorQvWu/RLhVKipKRJcJPitBii7Tw6m1V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       "]]},
     Annotation[#, "Charting`Private`Tag$6161#3"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{
    FormBox[
     TagBox["T", HoldForm], TraditionalForm], 
    FormBox[
     RowBox[{"2", " ", "s\[CapitalPi]"}], TraditionalForm]},
  AxesOrigin->{-40., 0.0018},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{-40., 10.}, {0.0018, 0.00201}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.904874555736734*^9, {3.904874650489348*^9, 3.904874686831294*^9}, 
   3.904875162589649*^9, 3.9048752082567997`*^9, {3.904875261834367*^9, 
   3.9048752816689034`*^9}, 3.904875433570794*^9, {3.904965860626371*^9, 
   3.9049658809533987`*^9}, 3.904965956262679*^9, 3.90496657784623*^9, {
   3.90496832344415*^9, 3.9049683393890457`*^9}, 3.904968586838099*^9, 
   3.9049686218398933`*^9, 3.904969364302309*^9, 3.9070516867080584`*^9, 
   3.9151088814305468`*^9, 3.915674096932701*^9},
 CellLabel->"Out[44]=",ExpressionUUID->"15a1bf42-fb20-455d-94a4-d848591387d6"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{"Vertical", " ", "transmission"}], ",", " ", 
   RowBox[{"affinity", " ", "bias"}]}], "*)"}]], "Input",
 CellChangeTimes->{{3.9164804418334923`*^9, 3.916480453452455*^9}, {
  3.9247678296340437`*^9, 
  3.924767831376994*^9}},ExpressionUUID->"253450ff-0eab-4208-bddc-\
9310e489835b"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"x", " ", ":=", " ", 
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"Exp", "[", 
       RowBox[{"-", "T"}], "]"}]}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"y", ":=", 
   RowBox[{"1", "-", "x"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.904872270602913*^9, 3.904872325028329*^9}, {
  3.904966386519217*^9, 3.904966391470133*^9}},
 CellLabel->
  "In[564]:=",ExpressionUUID->"ab191aad-aed2-45de-8022-74bbb95a4f6d"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"dPIdTC", ":=", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"x", "*", "y"}], ")"}], 
     RowBox[{"(", 
      RowBox[{"rho1", "-", "rho2"}], ")"}], 
     RowBox[{"DEL", "[", "T", "]"}]}], " ", "-", 
    RowBox[{"thet", " ", 
     RowBox[{"PI", "[", "T", "]"}], 
     RowBox[{"(", 
      RowBox[{"1", "-", 
       RowBox[{"PI", "[", "T", "]"}]}], ")"}]}], "+", 
    RowBox[{"thet", 
     RowBox[{"(", 
      RowBox[{"x", "*", "y"}], ")"}], " ", 
     RowBox[{
      RowBox[{"DEL", "[", "T", "]"}], "^", "2"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dDELdTC", ":=", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"DEL", "[", "T", "]"}], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"rho1", " ", "y"}], "+", 
         RowBox[{"rho2", " ", "x"}]}], ")"}], " ", "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "*", 
           RowBox[{"PI", "[", "T", "]"}]}], " ", "-", " ", "1"}], ")"}], 
        "thet"}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"x", "-", "y"}], ")"}], 
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"thet", " ", 
           RowBox[{"DEL", "[", "T", "]"}]}]}], ")"}]}]}], ")"}]}], "-", 
    RowBox[{"PI", "[", "T", "]"}]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.904872081515257*^9, 3.904872238946278*^9}, {
  3.904872339537427*^9, 3.9048723404899273`*^9}, {3.904872730537257*^9, 
  3.9048727578153677`*^9}, {3.9048755233122463`*^9, 3.904875524839315*^9}, {
  3.904876427651627*^9, 3.90487647967521*^9}, {3.904966393886785*^9, 
  3.904966416507242*^9}, {3.904966584552979*^9, 3.904966592904078*^9}},
 CellLabel->
  "In[566]:=",ExpressionUUID->"39d3cbd0-524d-4b82-9240-da82fd0b6b1c"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"r1", "=", "0.01"}], ";", " ", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"r1", " ", "is", " ", "1"}], "-", "gamma1"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"SC", "=", "0.1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"r1", "/", "SC"}]}], "Input",
 CellChangeTimes->{{3.9090494331566067`*^9, 3.909049563112196*^9}, {
   3.909049685905368*^9, 3.909049695555068*^9}, {3.909049819275182*^9, 
   3.909049819409315*^9}, {3.909050309613039*^9, 3.90905036734308*^9}, {
   3.9090503987630167`*^9, 3.909050399216628*^9}, {3.909050492522335*^9, 
   3.9090505346945953`*^9}, {3.915020005402335*^9, 3.9150200337908983`*^9}, {
   3.915674567540655*^9, 3.9156745677194*^9}, {3.915674860677093*^9, 
   3.91567488237071*^9}, {3.915675012028384*^9, 3.915675031330797*^9}, {
   3.915675381701655*^9, 3.915675382181055*^9}, {3.9156758818107243`*^9, 
   3.915675908446219*^9}, {3.9156780490114117`*^9, 3.915678056338784*^9}, 
   3.9156787229144783`*^9, {3.915678882804346*^9, 3.915678917149041*^9}, {
   3.915678957096981*^9, 3.915678965564213*^9}, 3.915679082634117*^9},
 CellLabel->
  "In[568]:=",ExpressionUUID->"39234b39-413a-41d9-92a6-44085db97f83"],

Cell[BoxData["0.1`"], "Output",
 CellChangeTimes->{3.915679044353537*^9, 3.915679084086109*^9, 
  3.915679436376835*^9},
 CellLabel->
  "Out[569]=",ExpressionUUID->"2205374f-e4b8-44b5-a1be-cc93ee51936d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"0.001", "/", "SC"}]], "Input",
 CellLabel->
  "In[513]:=",ExpressionUUID->"b0e5faea-b138-41b2-bffc-a5d36b4b5b9c"],

Cell[BoxData["0.01`"], "Output",
 CellChangeTimes->{{3.9156789596127157`*^9, 3.915678966156397*^9}, 
   3.9156790256515017`*^9, 3.915679087436407*^9},
 CellLabel->
  "Out[513]=",ExpressionUUID->"54406dd1-153a-4684-accc-ddd833bf53b2"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"PIsolve", " ", "=", " ", 
   RowBox[{"Simplify", "[", 
    RowBox[{"dPIdTC", "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"thet", "->", 
        RowBox[{"0.1", "/", "SC"}]}], ",", 
       RowBox[{"rho1", "->", 
        RowBox[{"r1", "/", "SC"}]}], ",", 
       RowBox[{"rho2", "->", 
        RowBox[{"r1", "/", "SC"}]}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DELsolve", " ", "=", " ", 
   RowBox[{"Simplify", "[", 
    RowBox[{"dDELdTC", "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"thet", "->", 
        RowBox[{"0.1", "/", "SC"}]}], ",", 
       RowBox[{"rho1", "->", 
        RowBox[{"r1", "/", "SC"}]}], ",", 
       RowBox[{"rho2", "->", 
        RowBox[{"r1", "/", "SC"}]}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"s1C", "=", 
   RowBox[{"NDSolve", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"PI", "'"}], "[", "T", "]"}], "==", "PIsolve"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"DEL", "'"}], "[", "T", "]"}], "==", "DELsolve"}], ",", 
       RowBox[{
        RowBox[{"DEL", "[", "10", "]"}], "==", "0"}], ",", 
       RowBox[{
        RowBox[{"PI", "[", "10", "]"}], " ", "==", " ", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"PI", ",", "DEL"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"T", ",", "10", ",", 
       RowBox[{"-", "40"}]}], "}"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.904872549756247*^9, 3.904872549760933*^9}, {
   3.9048726124255466`*^9, 3.9048726378647423`*^9}, {3.904872682217321*^9, 
   3.9048726977194443`*^9}, {3.904872918689548*^9, 3.90487296319888*^9}, {
   3.9048729972401867`*^9, 3.904873005385723*^9}, {3.904873353676889*^9, 
   3.9048733538350573`*^9}, {3.90487355199867*^9, 3.9048735768441973`*^9}, {
   3.904874257561905*^9, 3.904874293402482*^9}, 3.9048746079660997`*^9, {
   3.904876496812817*^9, 3.904876519244967*^9}, {3.9048765944806957`*^9, 
   3.90487664354998*^9}, {3.904878248924048*^9, 3.904878253276434*^9}, 
   3.904878451234967*^9, {3.904966636821453*^9, 3.904966651202189*^9}, {
   3.9067863054612713`*^9, 3.906786320574843*^9}, {3.906792087854341*^9, 
   3.906792102381044*^9}, {3.9067924181676073`*^9, 3.9067924191249332`*^9}, {
   3.906792608455905*^9, 3.906792611566052*^9}, {3.906792657357177*^9, 
   3.906792662118952*^9}, {3.906793143742342*^9, 3.906793171735874*^9}, {
   3.906793247160363*^9, 3.9067932539234953`*^9}, {3.9067933369868917`*^9, 
   3.906793342729514*^9}, {3.906793451946694*^9, 3.9067934560009403`*^9}, {
   3.907051774432563*^9, 3.907051789136566*^9}, {3.907051825005147*^9, 
   3.9070518475862923`*^9}, {3.9070522117641773`*^9, 3.90705221769657*^9}, {
   3.907052693290683*^9, 3.9070527033047657`*^9}, {3.9070541611987553`*^9, 
   3.907054177280862*^9}, {3.907311790001951*^9, 3.907311849129178*^9}, {
   3.907311947258919*^9, 3.9073119647617283`*^9}, {3.907312013009848*^9, 
   3.9073120267711267`*^9}, {3.907667958506104*^9, 3.907667991149673*^9}, {
   3.907668056235461*^9, 3.90766812434468*^9}, {3.9076681979431133`*^9, 
   3.9076682060728188`*^9}, {3.9076692579192*^9, 3.907669274117312*^9}, {
   3.909049572755795*^9, 3.909049645502926*^9}, {3.909050440427177*^9, 
   3.909050443546796*^9}, {3.915019980549096*^9, 3.9150199829564657`*^9}, {
   3.915674838198558*^9, 3.91567484146039*^9}, {3.915675016275755*^9, 
   3.915675023420556*^9}, {3.915675265773178*^9, 3.915675268780858*^9}, {
   3.915675915214253*^9, 3.9156759210990458`*^9}, {3.9156780666748857`*^9, 
   3.915678071730101*^9}, {3.915678250587804*^9, 3.915678252054912*^9}, {
   3.915678729679852*^9, 3.915678730574108*^9}, {3.915678983487998*^9, 
   3.91567898625904*^9}},
 CellLabel->
  "In[570]:=",ExpressionUUID->"d545430e-2f4a-4bac-b698-ecaf8aacab53"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"PIsolve", " ", "=", " ", 
   RowBox[{"Simplify", "[", 
    RowBox[{"dPIdTC", "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"thet", "->", 
        RowBox[{"0.01", "/", "SC"}]}], ",", 
       RowBox[{"rho1", "->", 
        RowBox[{"r1", "/", "SC"}]}], ",", 
       RowBox[{"rho2", "->", 
        RowBox[{"r1", "/", "SC"}]}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DELsolve", " ", "=", " ", 
   RowBox[{"Simplify", "[", 
    RowBox[{"dDELdTC", "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"thet", "->", 
        RowBox[{"0.01", "/", "SC"}]}], ",", 
       RowBox[{"rho1", "->", 
        RowBox[{"r1", "/", "SC"}]}], ",", 
       RowBox[{"rho2", "->", 
        RowBox[{"r1", "/", "SC"}]}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"s2C", "=", 
   RowBox[{"NDSolve", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"PI", "'"}], "[", "T", "]"}], "==", "PIsolve"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"DEL", "'"}], "[", "T", "]"}], "==", "DELsolve"}], ",", 
       RowBox[{
        RowBox[{"DEL", "[", "10", "]"}], "==", "0"}], ",", 
       RowBox[{
        RowBox[{"PI", "[", "10", "]"}], " ", "==", " ", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"PI", ",", "DEL"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"T", ",", "10", ",", 
       RowBox[{"-", "40"}]}], "}"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.904874273874234*^9, 3.904874277497774*^9}, 
   3.9048746139089203`*^9, {3.9048765205872297`*^9, 3.904876525390477*^9}, {
   3.904876599160657*^9, 3.904876646277412*^9}, {3.904878255331595*^9, 
   3.904878260018879*^9}, 3.904878453059987*^9, {3.904966638431175*^9, 
   3.904966652855665*^9}, {3.906786323790214*^9, 3.906786328197921*^9}, {
   3.9067920800952*^9, 3.9067921158369703`*^9}, {3.9067924151123247`*^9, 
   3.906792416415338*^9}, {3.906792612502233*^9, 3.9067926155092983`*^9}, {
   3.906792665384075*^9, 3.906792669994688*^9}, {3.9067931490271606`*^9, 
   3.9067931670092583`*^9}, {3.9067932415948477`*^9, 3.906793243763031*^9}, {
   3.9067933252748833`*^9, 3.906793331544113*^9}, {3.906793458978339*^9, 
   3.906793462265483*^9}, {3.907051851716661*^9, 3.907051854442355*^9}, {
   3.9070522294069357`*^9, 3.907052248403158*^9}, {3.907052695191889*^9, 
   3.907052701554744*^9}, {3.9070541651270638`*^9, 3.907054174776421*^9}, {
   3.907311855537239*^9, 3.90731188042229*^9}, {3.907311949310341*^9, 
   3.9073119625944433`*^9}, {3.907312031386229*^9, 3.907312054962866*^9}, {
   3.907667993549411*^9, 3.907668014340146*^9}, 3.907668061163171*^9, {
   3.907668225265152*^9, 3.907668234017829*^9}, {3.907669263574415*^9, 
   3.907669283828974*^9}, {3.909049603463135*^9, 3.9090496144546633`*^9}, {
   3.9090496481215487`*^9, 3.909049657323761*^9}, {3.909050447961809*^9, 
   3.909050450860299*^9}, {3.91501998492268*^9, 3.915019987845848*^9}, {
   3.915674843452585*^9, 3.9156748465033484`*^9}, {3.915675036962928*^9, 
   3.91567504004381*^9}, {3.915675271182386*^9, 3.915675272443675*^9}, {
   3.9156759225553513`*^9, 3.915675925652602*^9}, {3.915678078005327*^9, 
   3.915678086266142*^9}, {3.915678255031661*^9, 3.915678256105812*^9}, {
   3.9156787315985193`*^9, 3.915678732387876*^9}, {3.915678988362501*^9, 
   3.915678989808406*^9}},
 CellLabel->
  "In[573]:=",ExpressionUUID->"7ecf013e-a166-47f3-8353-12aea45fced5"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"PIsolve", " ", "=", " ", 
   RowBox[{"Simplify", "[", 
    RowBox[{"dPIdTC", "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"thet", "->", 
        RowBox[{"0.001", "/", "SC"}]}], ",", " ", 
       RowBox[{"rho1", "->", 
        RowBox[{"r1", "/", "SC"}]}], ",", 
       RowBox[{"rho2", "->", 
        RowBox[{"r1", "/", "SC"}]}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DELsolve", " ", "=", " ", 
   RowBox[{"Simplify", "[", 
    RowBox[{"dDELdTC", "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"thet", "->", 
        RowBox[{"0.001", "/", "SC"}]}], ",", 
       RowBox[{"rho1", "->", 
        RowBox[{"r1", "/", "SC"}]}], ",", 
       RowBox[{"rho2", "->", 
        RowBox[{"r1", "/", "SC"}]}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"s3C", "=", 
   RowBox[{"NDSolve", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"PI", "'"}], "[", "T", "]"}], "==", "PIsolve"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"DEL", "'"}], "[", "T", "]"}], "==", "DELsolve"}], ",", 
       RowBox[{
        RowBox[{"DEL", "[", "10", "]"}], "==", "0"}], ",", 
       RowBox[{
        RowBox[{"PI", "[", "10", "]"}], " ", "==", " ", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"PI", ",", "DEL"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"T", ",", "10", ",", 
       RowBox[{"-", "40"}]}], "}"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.904874275121776*^9, 3.904874306956203*^9}, {
   3.904874361317594*^9, 3.904874361387533*^9}, 3.904874616709448*^9, {
   3.904876527924892*^9, 3.90487653473518*^9}, {3.9048766003303967`*^9, 
   3.904876649189856*^9}, {3.904878261636324*^9, 3.9048782685084257`*^9}, 
   3.904878454451191*^9, {3.904966641969729*^9, 3.904966654446918*^9}, {
   3.906786330885509*^9, 3.9067863341588583`*^9}, {3.906786384746079*^9, 
   3.9067863991724987`*^9}, {3.90679242068841*^9, 3.906792421727631*^9}, {
   3.9067926167185297`*^9, 3.906792619869845*^9}, {3.9067926732867937`*^9, 
   3.906792684486705*^9}, {3.906793154618973*^9, 3.9067931614745607`*^9}, {
   3.906793191825987*^9, 3.906793222161763*^9}, {3.9067933327134323`*^9, 
   3.90679333581719*^9}, {3.906793465337462*^9, 3.906793469064142*^9}, {
   3.9070518572026377`*^9, 3.907051859659306*^9}, {3.907052254269155*^9, 
   3.9070522668911047`*^9}, {3.9070526967055473`*^9, 
   3.9070526996331367`*^9}, {3.907054167439365*^9, 3.9070541724170923`*^9}, {
   3.9073118870323153`*^9, 3.90731190107535*^9}, {3.907311951153818*^9, 
   3.9073119554394007`*^9}, {3.907312036562807*^9, 3.9073120484592543`*^9}, {
   3.9076680016113243`*^9, 3.907668009780011*^9}, {3.90766823747253*^9, 
   3.907668244977449*^9}, {3.907669268491973*^9, 3.907669287971963*^9}, {
   3.909049626411334*^9, 3.909049673387909*^9}, {3.909050454515645*^9, 
   3.9090504576370897`*^9}, {3.915019989827148*^9, 3.915019992607912*^9}, {
   3.915674848765842*^9, 3.915674851484756*^9}, {3.915675041194363*^9, 
   3.9156750442078*^9}, {3.915675273590013*^9, 3.915675274760998*^9}, {
   3.915675927092156*^9, 3.915675930206665*^9}, {3.915678089150484*^9, 
   3.9156780977607613`*^9}, {3.915678257850898*^9, 3.9156782588526297`*^9}, {
   3.915678733168222*^9, 3.915678734022079*^9}, {3.915678991135602*^9, 
   3.915678992279099*^9}},
 CellLabel->
  "In[576]:=",ExpressionUUID->"90eace83-dfe7-4d84-94de-fb98a4261f74"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Evaluate", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", "*", "SC", "*", 
         RowBox[{"PI", "[", "T", "]"}]}], "}"}], "/.", " ", "s1C"}], "]"}], 
     ",", "\[IndentingNewLine]", 
     RowBox[{"Evaluate", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", "*", "SC", "*", 
         RowBox[{"PI", "[", "T", "]"}]}], "}"}], "/.", " ", "s2C"}], "]"}], 
     ",", "\[IndentingNewLine]", 
     RowBox[{"Evaluate", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", "*", "SC", "*", 
         RowBox[{"PI", "[", "T", "]"}]}], "}"}], "/.", " ", "s3C"}], "]"}]}], 
    "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{"T", ",", 
     RowBox[{"-", "40"}], ",", "10"}], "}"}], ",", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "40"}], ",", "10"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0.21"}], "}"}]}], "}"}]}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"AxesOrigin", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "40"}], ",", "0"}], "}"}]}], ",", "\[IndentingNewLine]", 
   " ", 
   RowBox[{"AxesLabel", "->", 
    RowBox[{"{", 
     RowBox[{"T", ",", "\"\<2SB\[CapitalPi]\>\""}], "}"}]}]}], "]"}]], "Input",\

 CellChangeTimes->{{3.904873153800063*^9, 3.9048731761585693`*^9}, {
   3.904873228215217*^9, 3.904873254470806*^9}, {3.904873318526799*^9, 
   3.904873322948452*^9}, {3.90487336149325*^9, 3.904873365715081*^9}, {
   3.904873712498666*^9, 3.904873740892362*^9}, {3.9048743195934668`*^9, 
   3.904874351306569*^9}, {3.904874389969171*^9, 3.904874413604905*^9}, {
   3.9048746206949463`*^9, 3.904874624348497*^9}, {3.904875179872344*^9, 
   3.904875203192885*^9}, {3.9048753969116163`*^9, 3.9048754223441668`*^9}, {
   3.904876629380815*^9, 3.904876632764553*^9}, {3.904878281468905*^9, 
   3.904878281589134*^9}, {3.9048784558178997`*^9, 3.9048784581713753`*^9}, 
   3.904878590802092*^9, {3.904965772257105*^9, 3.9049657878195868`*^9}, {
   3.904967642532712*^9, 3.904967709803529*^9}, {3.90496774679053*^9, 
   3.9049677559456377`*^9}, {3.904967810014143*^9, 3.904967816334544*^9}, {
   3.904967950394342*^9, 3.9049679539982777`*^9}, {3.9049680168332376`*^9, 
   3.9049680616457987`*^9}, 3.904968200738636*^9, {3.904968251950255*^9, 
   3.904968281519992*^9}, {3.904968506994603*^9, 3.9049685119070387`*^9}, {
   3.9049686043672*^9, 3.904968609336738*^9}, {3.906792578622901*^9, 
   3.9067925913864107`*^9}, {3.906793269674049*^9, 3.906793269726478*^9}, {
   3.907311924546071*^9, 3.907311932137597*^9}, {3.907312070324984*^9, 
   3.907312075180005*^9}, {3.907668256530444*^9, 3.907668261801621*^9}, {
   3.90766929854132*^9, 3.9076693046622543`*^9}, {3.915108957467689*^9, 
   3.915108957593938*^9}, {3.915675302075736*^9, 3.915675305356992*^9}, {
   3.915675346000514*^9, 3.915675357178006*^9}, {3.915675394810481*^9, 
   3.915675398380411*^9}, {3.915678129733378*^9, 3.915678166308649*^9}, {
   3.915678744959652*^9, 3.915678794270241*^9}, {3.915678838381522*^9, 
   3.915678838707878*^9}},
 CellLabel->
  "In[579]:=",ExpressionUUID->"fca797a9-0911-46a9-a0b1-d0716b240550"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwt2nk8FV8bAHB7yL7vy7329VpDOCchZakUSZJCSrayZZdQJJXIkvYSlaKE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       "]]},
     Annotation[#, "Charting`Private`Tag$16280#1"]& ], 
    TagBox[
     {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwV13k4VF0YAHBr9p2ZsY+xpOxrSZyTvaztSos+JCqUokREJFSyplBaRFln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       "]]},
     Annotation[#, "Charting`Private`Tag$16280#2"]& ], 
    TagBox[
     {RGBColor[0.560181, 0.691569, 0.194885], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwd13k81M8bAHD3fd/k2F3ryE3IETNRchWly5FUunQpkfsoJFLuXOlQUjmz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       "]]},
     Annotation[#, "Charting`Private`Tag$16280#3"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{
    FormBox[
     TagBox["T", HoldForm], TraditionalForm], 
    FormBox["\"2SB\[CapitalPi]\"", TraditionalForm]},
  AxesOrigin->{-40., 0.},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{-40., 10.}, {0., 0.21}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.91567810251468*^9, {3.9156781349135447`*^9, 3.91567816701093*^9}, 
   3.915678264247869*^9, {3.915678739656769*^9, 3.915678748790085*^9}, 
   3.915678795154213*^9, {3.915678839605421*^9, 3.915678854500824*^9}, {
   3.915678887785277*^9, 3.915678921562952*^9}, 3.915678998668993*^9, 
   3.915679092844936*^9, 3.915679443636286*^9},
 CellLabel->
  "Out[579]=",ExpressionUUID->"e16709f6-9429-4f12-8e84-bccd1adc2cfd"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{"Vertical", " ", "transmission"}], ",", " ", 
   RowBox[{"cultural", " ", "trait", " ", "bias"}]}], "*)"}]], "Input",
 CellChangeTimes->{{3.9164804606827097`*^9, 3.9164804714481792`*^9}, {
  3.924767837837214*^9, 
  3.924767842622284*^9}},ExpressionUUID->"2617a46d-94e2-46dc-959b-\
dd9ea31505f5"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"x", " ", ":=", " ", 
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"Exp", "[", 
       RowBox[{"-", "T"}], "]"}]}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"y", ":=", 
   RowBox[{"1", "-", "x"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.904872270602913*^9, 3.904872325028329*^9}, {
  3.904966386519217*^9, 3.904966391470133*^9}},
 CellLabel->
  "In[619]:=",ExpressionUUID->"d420e323-9288-4988-82b9-c4e1541e05be"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"dPIdTC", ":=", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"x", "*", "y"}], ")"}], 
     RowBox[{"(", 
      RowBox[{"rho1", "-", "rho2"}], ")"}], 
     RowBox[{"DEL", "[", "T", "]"}]}], " ", "-", 
    RowBox[{"thet", " ", 
     RowBox[{"PI", "[", "T", "]"}], 
     RowBox[{"(", 
      RowBox[{"1", "-", 
       RowBox[{"PI", "[", "T", "]"}]}], ")"}]}], "+", 
    RowBox[{"thet", 
     RowBox[{"(", 
      RowBox[{"x", "*", "y"}], ")"}], " ", 
     RowBox[{
      RowBox[{"DEL", "[", "T", "]"}], "^", "2"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dDELdTC", ":=", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"DEL", "[", "T", "]"}], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"rho1", " ", "y"}], "+", 
         RowBox[{"rho2", " ", "x"}]}], ")"}], " ", "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "*", 
           RowBox[{"PI", "[", "T", "]"}]}], " ", "-", " ", "1"}], ")"}], 
        "thet"}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"x", "-", "y"}], ")"}], 
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"thet", " ", 
           RowBox[{"DEL", "[", "T", "]"}]}]}], ")"}]}]}], ")"}]}], "-", 
    RowBox[{"PI", "[", "T", "]"}]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.904872081515257*^9, 3.904872238946278*^9}, {
  3.904872339537427*^9, 3.9048723404899273`*^9}, {3.904872730537257*^9, 
  3.9048727578153677`*^9}, {3.9048755233122463`*^9, 3.904875524839315*^9}, {
  3.904876427651627*^9, 3.90487647967521*^9}, {3.904966393886785*^9, 
  3.904966416507242*^9}, {3.904966584552979*^9, 3.904966592904078*^9}},
 CellLabel->
  "In[621]:=",ExpressionUUID->"34856874-9116-4b68-bf21-0fae4313685f"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"r1", "=", 
   RowBox[{"0.5", "-", "0.05"}]}], ";", " ", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"r1", " ", "is", " ", "1"}], "-", "gamma1"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"gamma2", "=", "0.5"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SC", "=", "0.1"}], ";"}]}], "Input",
 CellChangeTimes->{{3.9090494331566067`*^9, 3.909049563112196*^9}, {
   3.909049685905368*^9, 3.909049695555068*^9}, {3.909049819275182*^9, 
   3.909049819409315*^9}, {3.909050309613039*^9, 3.90905036734308*^9}, {
   3.9090503987630167`*^9, 3.909050399216628*^9}, {3.909050492522335*^9, 
   3.9090505346945953`*^9}, {3.915020005402335*^9, 3.9150200337908983`*^9}, {
   3.915674567540655*^9, 3.9156745677194*^9}, {3.915674860677093*^9, 
   3.91567488237071*^9}, {3.915675012028384*^9, 3.915675031330797*^9}, {
   3.915675381701655*^9, 3.915675382181055*^9}, {3.9156758818107243`*^9, 
   3.915675908446219*^9}, 3.915678500748549*^9, {3.915679123474222*^9, 
   3.91567914630245*^9}},
 CellLabel->
  "In[623]:=",ExpressionUUID->"a70cd7e0-8f1a-4613-849f-3ac67f6b6774"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"PIsolve", " ", "=", " ", 
   RowBox[{"Simplify", "[", 
    RowBox[{"dPIdTC", "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"thet", "->", 
        RowBox[{"0.1", "/", "SC"}]}], ",", 
       RowBox[{"rho1", "->", 
        RowBox[{"r1", "/", "SC"}]}], ",", 
       RowBox[{"rho2", "->", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "-", "r1"}], ")"}], "/", "SC"}]}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DELsolve", " ", "=", " ", 
   RowBox[{"Simplify", "[", 
    RowBox[{"dDELdTC", "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"thet", "->", 
        RowBox[{"0.1", "/", "SC"}]}], ",", 
       RowBox[{"rho1", "->", 
        RowBox[{"r1", "/", "SC"}]}], ",", 
       RowBox[{"rho2", "->", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "-", "r1"}], ")"}], "/", "SC"}]}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"s1C", "=", 
   RowBox[{"NDSolve", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"PI", "'"}], "[", "T", "]"}], "==", "PIsolve"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"DEL", "'"}], "[", "T", "]"}], "==", "DELsolve"}], ",", 
       RowBox[{
        RowBox[{"DEL", "[", "10", "]"}], "==", "0"}], ",", 
       RowBox[{
        RowBox[{"PI", "[", "10", "]"}], " ", "==", " ", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"PI", ",", "DEL"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"T", ",", "10", ",", 
       RowBox[{"-", "40"}]}], "}"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.904872549756247*^9, 3.904872549760933*^9}, {
   3.9048726124255466`*^9, 3.9048726378647423`*^9}, {3.904872682217321*^9, 
   3.9048726977194443`*^9}, {3.904872918689548*^9, 3.90487296319888*^9}, {
   3.9048729972401867`*^9, 3.904873005385723*^9}, {3.904873353676889*^9, 
   3.9048733538350573`*^9}, {3.90487355199867*^9, 3.9048735768441973`*^9}, {
   3.904874257561905*^9, 3.904874293402482*^9}, 3.9048746079660997`*^9, {
   3.904876496812817*^9, 3.904876519244967*^9}, {3.9048765944806957`*^9, 
   3.90487664354998*^9}, {3.904878248924048*^9, 3.904878253276434*^9}, 
   3.904878451234967*^9, {3.904966636821453*^9, 3.904966651202189*^9}, {
   3.9067863054612713`*^9, 3.906786320574843*^9}, {3.906792087854341*^9, 
   3.906792102381044*^9}, {3.9067924181676073`*^9, 3.9067924191249332`*^9}, {
   3.906792608455905*^9, 3.906792611566052*^9}, {3.906792657357177*^9, 
   3.906792662118952*^9}, {3.906793143742342*^9, 3.906793171735874*^9}, {
   3.906793247160363*^9, 3.9067932539234953`*^9}, {3.9067933369868917`*^9, 
   3.906793342729514*^9}, {3.906793451946694*^9, 3.9067934560009403`*^9}, {
   3.907051774432563*^9, 3.907051789136566*^9}, {3.907051825005147*^9, 
   3.9070518475862923`*^9}, {3.9070522117641773`*^9, 3.90705221769657*^9}, {
   3.907052693290683*^9, 3.9070527033047657`*^9}, {3.9070541611987553`*^9, 
   3.907054177280862*^9}, {3.907311790001951*^9, 3.907311849129178*^9}, {
   3.907311947258919*^9, 3.9073119647617283`*^9}, {3.907312013009848*^9, 
   3.9073120267711267`*^9}, {3.907667958506104*^9, 3.907667991149673*^9}, {
   3.907668056235461*^9, 3.90766812434468*^9}, {3.9076681979431133`*^9, 
   3.9076682060728188`*^9}, {3.9076692579192*^9, 3.907669274117312*^9}, {
   3.909049572755795*^9, 3.909049645502926*^9}, {3.909050440427177*^9, 
   3.909050443546796*^9}, {3.915019980549096*^9, 3.9150199829564657`*^9}, {
   3.915674838198558*^9, 3.91567484146039*^9}, {3.915675016275755*^9, 
   3.915675023420556*^9}, {3.915675265773178*^9, 3.915675268780858*^9}, {
   3.915675915214253*^9, 3.9156759210990458`*^9}, {3.9156782882495193`*^9, 
   3.91567829099441*^9}, {3.915678456492173*^9, 3.915678457679064*^9}, {
   3.915679155543366*^9, 3.915679156717554*^9}},
 CellLabel->
  "In[625]:=",ExpressionUUID->"19aa34c8-ae75-415a-8c46-1e3768bbfe2f"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"PIsolve", " ", "=", " ", 
   RowBox[{"Simplify", "[", 
    RowBox[{"dPIdTC", "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"thet", "->", 
        RowBox[{"0.01", "/", "SC"}]}], ",", 
       RowBox[{"rho1", "->", 
        RowBox[{"r1", "/", "SC"}]}], ",", 
       RowBox[{"rho2", "->", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "-", "r1"}], ")"}], "/", "SC"}]}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DELsolve", " ", "=", " ", 
   RowBox[{"Simplify", "[", 
    RowBox[{"dDELdTC", "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"thet", "->", 
        RowBox[{"0.01", "/", "SC"}]}], ",", 
       RowBox[{"rho1", "->", 
        RowBox[{"r1", "/", "SC"}]}], ",", 
       RowBox[{"rho2", "->", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "-", "r1"}], ")"}], "/", "SC"}]}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"s2C", "=", 
   RowBox[{"NDSolve", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"PI", "'"}], "[", "T", "]"}], "==", "PIsolve"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"DEL", "'"}], "[", "T", "]"}], "==", "DELsolve"}], ",", 
       RowBox[{
        RowBox[{"DEL", "[", "10", "]"}], "==", "0"}], ",", 
       RowBox[{
        RowBox[{"PI", "[", "10", "]"}], " ", "==", " ", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"PI", ",", "DEL"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"T", ",", "10", ",", 
       RowBox[{"-", "40"}]}], "}"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.904874273874234*^9, 3.904874277497774*^9}, 
   3.9048746139089203`*^9, {3.9048765205872297`*^9, 3.904876525390477*^9}, {
   3.904876599160657*^9, 3.904876646277412*^9}, {3.904878255331595*^9, 
   3.904878260018879*^9}, 3.904878453059987*^9, {3.904966638431175*^9, 
   3.904966652855665*^9}, {3.906786323790214*^9, 3.906786328197921*^9}, {
   3.9067920800952*^9, 3.9067921158369703`*^9}, {3.9067924151123247`*^9, 
   3.906792416415338*^9}, {3.906792612502233*^9, 3.9067926155092983`*^9}, {
   3.906792665384075*^9, 3.906792669994688*^9}, {3.9067931490271606`*^9, 
   3.9067931670092583`*^9}, {3.9067932415948477`*^9, 3.906793243763031*^9}, {
   3.9067933252748833`*^9, 3.906793331544113*^9}, {3.906793458978339*^9, 
   3.906793462265483*^9}, {3.907051851716661*^9, 3.907051854442355*^9}, {
   3.9070522294069357`*^9, 3.907052248403158*^9}, {3.907052695191889*^9, 
   3.907052701554744*^9}, {3.9070541651270638`*^9, 3.907054174776421*^9}, {
   3.907311855537239*^9, 3.90731188042229*^9}, {3.907311949310341*^9, 
   3.9073119625944433`*^9}, {3.907312031386229*^9, 3.907312054962866*^9}, {
   3.907667993549411*^9, 3.907668014340146*^9}, 3.907668061163171*^9, {
   3.907668225265152*^9, 3.907668234017829*^9}, {3.907669263574415*^9, 
   3.907669283828974*^9}, {3.909049603463135*^9, 3.9090496144546633`*^9}, {
   3.9090496481215487`*^9, 3.909049657323761*^9}, {3.909050447961809*^9, 
   3.909050450860299*^9}, {3.91501998492268*^9, 3.915019987845848*^9}, {
   3.915674843452585*^9, 3.9156748465033484`*^9}, {3.915675036962928*^9, 
   3.91567504004381*^9}, {3.915675271182386*^9, 3.915675272443675*^9}, {
   3.9156759225553513`*^9, 3.915675925652602*^9}, {3.915678292428338*^9, 
   3.915678293329727*^9}, {3.915678461589031*^9, 3.9156784624698143`*^9}, {
   3.915679157721608*^9, 3.9156791586660347`*^9}},
 CellLabel->
  "In[628]:=",ExpressionUUID->"1a9676b3-9095-48da-923b-44629f2e3658"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"PIsolve", " ", "=", " ", 
   RowBox[{"Simplify", "[", 
    RowBox[{"dPIdTC", "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"thet", "->", 
        RowBox[{"0.001", "/", "SC"}]}], ",", " ", 
       RowBox[{"rho1", "->", 
        RowBox[{"r1", "/", "SC"}]}], ",", 
       RowBox[{"rho2", "->", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "-", "r1"}], ")"}], "/", "SC"}]}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DELsolve", " ", "=", " ", 
   RowBox[{"Simplify", "[", 
    RowBox[{"dDELdTC", "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"thet", "->", 
        RowBox[{"0.001", "/", "SC"}]}], ",", 
       RowBox[{"rho1", "->", 
        RowBox[{"r1", "/", "SC"}]}], ",", 
       RowBox[{"rho2", "->", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "-", "r1"}], ")"}], "/", "SC"}]}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"s3C", "=", 
   RowBox[{"NDSolve", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"PI", "'"}], "[", "T", "]"}], "==", "PIsolve"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"DEL", "'"}], "[", "T", "]"}], "==", "DELsolve"}], ",", 
       RowBox[{
        RowBox[{"DEL", "[", "10", "]"}], "==", "0"}], ",", 
       RowBox[{
        RowBox[{"PI", "[", "10", "]"}], " ", "==", " ", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"PI", ",", "DEL"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"T", ",", "10", ",", 
       RowBox[{"-", "40"}]}], "}"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.904874275121776*^9, 3.904874306956203*^9}, {
   3.904874361317594*^9, 3.904874361387533*^9}, 3.904874616709448*^9, {
   3.904876527924892*^9, 3.90487653473518*^9}, {3.9048766003303967`*^9, 
   3.904876649189856*^9}, {3.904878261636324*^9, 3.9048782685084257`*^9}, 
   3.904878454451191*^9, {3.904966641969729*^9, 3.904966654446918*^9}, {
   3.906786330885509*^9, 3.9067863341588583`*^9}, {3.906786384746079*^9, 
   3.9067863991724987`*^9}, {3.90679242068841*^9, 3.906792421727631*^9}, {
   3.9067926167185297`*^9, 3.906792619869845*^9}, {3.9067926732867937`*^9, 
   3.906792684486705*^9}, {3.906793154618973*^9, 3.9067931614745607`*^9}, {
   3.906793191825987*^9, 3.906793222161763*^9}, {3.9067933327134323`*^9, 
   3.90679333581719*^9}, {3.906793465337462*^9, 3.906793469064142*^9}, {
   3.9070518572026377`*^9, 3.907051859659306*^9}, {3.907052254269155*^9, 
   3.9070522668911047`*^9}, {3.9070526967055473`*^9, 
   3.9070526996331367`*^9}, {3.907054167439365*^9, 3.9070541724170923`*^9}, {
   3.9073118870323153`*^9, 3.90731190107535*^9}, {3.907311951153818*^9, 
   3.9073119554394007`*^9}, {3.907312036562807*^9, 3.9073120484592543`*^9}, {
   3.9076680016113243`*^9, 3.907668009780011*^9}, {3.90766823747253*^9, 
   3.907668244977449*^9}, {3.907669268491973*^9, 3.907669287971963*^9}, {
   3.909049626411334*^9, 3.909049673387909*^9}, {3.909050454515645*^9, 
   3.9090504576370897`*^9}, {3.915019989827148*^9, 3.915019992607912*^9}, {
   3.915674848765842*^9, 3.915674851484756*^9}, {3.915675041194363*^9, 
   3.9156750442078*^9}, {3.915675273590013*^9, 3.915675274760998*^9}, {
   3.915675927092156*^9, 3.915675930206665*^9}, {3.915678294413045*^9, 
   3.9156782953507853`*^9}, {3.9156784658304157`*^9, 
   3.9156784667019978`*^9}, {3.915679159642885*^9, 3.9156791606120567`*^9}},
 CellLabel->
  "In[631]:=",ExpressionUUID->"2f247542-34a1-4b6f-9eed-5f09ed3d9138"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Evaluate", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", "*", "SC", "*", 
         RowBox[{"PI", "[", "T", "]"}]}], "}"}], "/.", " ", "s1C"}], "]"}], 
     ",", "\[IndentingNewLine]", 
     RowBox[{"Evaluate", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", "*", "SC", "*", 
         RowBox[{"PI", "[", "T", "]"}]}], "}"}], "/.", " ", "s2C"}], "]"}], 
     ",", "\[IndentingNewLine]", 
     RowBox[{"Evaluate", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", "*", "SC", "*", 
         RowBox[{"PI", "[", "T", "]"}]}], "}"}], "/.", " ", "s3C"}], "]"}]}], 
    "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{"T", ",", 
     RowBox[{"-", "40"}], ",", "10"}], "}"}], ",", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "40"}], ",", "10"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.19", ",", "0.26"}], "}"}]}], "}"}]}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"AxesOrigin", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "40"}], ",", "0.19"}], "}"}]}], ",", "\[IndentingNewLine]",
    " ", 
   RowBox[{"AxesLabel", "->", 
    RowBox[{"{", 
     RowBox[{"T", ",", "\"\<2SB\[CapitalPi]\>\""}], "}"}]}]}], "]"}]], "Input",\

 CellChangeTimes->{{3.904873153800063*^9, 3.9048731761585693`*^9}, {
   3.904873228215217*^9, 3.904873254470806*^9}, {3.904873318526799*^9, 
   3.904873322948452*^9}, {3.90487336149325*^9, 3.904873365715081*^9}, {
   3.904873712498666*^9, 3.904873740892362*^9}, {3.9048743195934668`*^9, 
   3.904874351306569*^9}, {3.904874389969171*^9, 3.904874413604905*^9}, {
   3.9048746206949463`*^9, 3.904874624348497*^9}, {3.904875179872344*^9, 
   3.904875203192885*^9}, {3.9048753969116163`*^9, 3.9048754223441668`*^9}, {
   3.904876629380815*^9, 3.904876632764553*^9}, {3.904878281468905*^9, 
   3.904878281589134*^9}, {3.9048784558178997`*^9, 3.9048784581713753`*^9}, 
   3.904878590802092*^9, {3.904965772257105*^9, 3.9049657878195868`*^9}, {
   3.904967642532712*^9, 3.904967709803529*^9}, {3.90496774679053*^9, 
   3.9049677559456377`*^9}, {3.904967810014143*^9, 3.904967816334544*^9}, {
   3.904967950394342*^9, 3.9049679539982777`*^9}, {3.9049680168332376`*^9, 
   3.9049680616457987`*^9}, 3.904968200738636*^9, {3.904968251950255*^9, 
   3.904968281519992*^9}, {3.904968506994603*^9, 3.9049685119070387`*^9}, {
   3.9049686043672*^9, 3.904968609336738*^9}, {3.906792578622901*^9, 
   3.9067925913864107`*^9}, {3.906793269674049*^9, 3.906793269726478*^9}, {
   3.907311924546071*^9, 3.907311932137597*^9}, {3.907312070324984*^9, 
   3.907312075180005*^9}, {3.907668256530444*^9, 3.907668261801621*^9}, {
   3.90766929854132*^9, 3.9076693046622543`*^9}, {3.915108957467689*^9, 
   3.915108957593938*^9}, {3.915675302075736*^9, 3.915675305356992*^9}, {
   3.915675346000514*^9, 3.915675357178006*^9}, {3.915675394810481*^9, 
   3.915675398380411*^9}, {3.915678327300578*^9, 3.915678327520486*^9}, {
   3.915678405658252*^9, 3.915678410548806*^9}, {3.915678507781495*^9, 
   3.915678509247407*^9}, {3.9156786008054047`*^9, 3.915678626011407*^9}, {
   3.9156787721711407`*^9, 3.915678802561714*^9}, {3.915679173510234*^9, 
   3.915679204468755*^9}, {3.915679411236561*^9, 3.915679424181839*^9}, {
   3.915679520624764*^9, 3.9156795214146757`*^9}},
 CellLabel->
  "In[634]:=",ExpressionUUID->"e60541c9-8e89-4805-b8e6-46245d74fe0d"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwt2nc8Vt8fAHBEZGTv9dh7Zq97QpKIipKVihIZkZFRVIRUkh2irGRmS+5R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       "]]},
     Annotation[#, "Charting`Private`Tag$21888#1"]& ], 
    TagBox[
     {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwV13k4VU0YAHD7vlz7du2SyBIh60xIviwVUlGoaFGihOzaEJUlyk4I2bKl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       "]]},
     Annotation[#, "Charting`Private`Tag$21888#2"]& ], 
    TagBox[
     {RGBColor[0.560181, 0.691569, 0.194885], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwd1nc8ld8fAHB7j+vea++RJDsr4ZzwLdlpKSoNKSWljIxoqJDIiEKUUYRI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       "]]},
     Annotation[#, "Charting`Private`Tag$21888#3"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{
    FormBox[
     TagBox["T", HoldForm], TraditionalForm], 
    FormBox["\"2SB\[CapitalPi]\"", TraditionalForm]},
  AxesOrigin->{-40., 0.19},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{-40., 10.}, {0.19, 0.26}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.9156788032391367`*^9, {3.9156791699155903`*^9, 3.915679205118288*^9}, {
   3.915679412889902*^9, 3.915679424997775*^9}, {3.9156795129459743`*^9, 
   3.915679522142291*^9}, 3.915687629746482*^9},
 CellLabel->
  "Out[634]=",ExpressionUUID->"3b09d086-f9a1-40d7-a97e-5215f42c00e0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Evaluate", "[", 
  RowBox[{
   RowBox[{"2", "*", "SC", "*", 
    RowBox[{"PI", "[", "0", "]"}]}], "/.", " ", 
   RowBox[{"{", "s1C", "}"}]}], "]"}]], "Input",
 CellLabel->
  "In[635]:=",ExpressionUUID->"03d1233b-819b-48a6-8fa5-fd227cfbfe62"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", "0.20503120495919505`", "}"}], "}"}]], "Output",
 CellChangeTimes->{3.9156876323580427`*^9},
 CellLabel->
  "Out[635]=",ExpressionUUID->"97454297-3e74-4be0-a946-e53d20dd5d82"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{
   "Panel", " ", "B", " ", "but", " ", "with", " ", "gamma", " ", "2"}], " ", 
   "=", " ", "0.5"}], "*)"}]], "Input",
 CellChangeTimes->{{3.9156741842723837`*^9, 3.915674204875474*^9}, {
  3.915675762013104*^9, 3.915675778851975*^9}, {3.915675863287314*^9, 
  3.915675863944786*^9}, {3.915676971313176*^9, 3.9156769739747887`*^9}, {
  3.915678017702065*^9, 3.915678019603635*^9}, {3.915680723150466*^9, 
  3.915680723610058*^9}, {3.924767861481986*^9, 
  3.924767869288842*^9}},ExpressionUUID->"e62a7994-786e-43d2-9241-\
6657339f9edd"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"x", " ", ":=", " ", 
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"Exp", "[", 
       RowBox[{"-", "T"}], "]"}]}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"y", ":=", 
   RowBox[{"1", "-", "x"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.904872270602913*^9, 3.904872325028329*^9}, {
  3.904966386519217*^9, 3.904966391470133*^9}},
 CellLabel->
  "In[597]:=",ExpressionUUID->"6d2497ac-74bf-40ab-9bbe-022054146778"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"dPIdTC", ":=", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"x", "*", "y"}], ")"}], 
     RowBox[{"(", 
      RowBox[{"rho1", "-", "rho2"}], ")"}], 
     RowBox[{"DEL", "[", "T", "]"}]}], " ", "-", 
    RowBox[{"thet", " ", 
     RowBox[{"PI", "[", "T", "]"}], 
     RowBox[{"(", 
      RowBox[{"1", "-", 
       RowBox[{"PI", "[", "T", "]"}]}], ")"}]}], "+", 
    RowBox[{"thet", 
     RowBox[{"(", 
      RowBox[{"x", "*", "y"}], ")"}], " ", 
     RowBox[{
      RowBox[{"DEL", "[", "T", "]"}], "^", "2"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dDELdTC", ":=", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"DEL", "[", "T", "]"}], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"rho1", " ", "y"}], "+", 
         RowBox[{"rho2", " ", "x"}]}], ")"}], " ", "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "*", 
           RowBox[{"PI", "[", "T", "]"}]}], " ", "-", " ", "1"}], ")"}], 
        "thet"}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"x", "-", "y"}], ")"}], 
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"thet", " ", 
           RowBox[{"DEL", "[", "T", "]"}]}]}], ")"}]}]}], ")"}]}], "-", 
    RowBox[{"PI", "[", "T", "]"}]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.904872081515257*^9, 3.904872238946278*^9}, {
  3.904872339537427*^9, 3.9048723404899273`*^9}, {3.904872730537257*^9, 
  3.9048727578153677`*^9}, {3.9048755233122463`*^9, 3.904875524839315*^9}, {
  3.904876427651627*^9, 3.90487647967521*^9}, {3.904966393886785*^9, 
  3.904966416507242*^9}, {3.904966584552979*^9, 3.904966592904078*^9}},
 CellLabel->
  "In[599]:=",ExpressionUUID->"c8612ea9-a194-4f2c-ba06-9def54547932"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"r1", "=", 
   RowBox[{"0.5", "+", "0.05"}]}], ";", " ", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"r1", " ", "is", " ", "1"}], "-", "gamma1"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"gamma2", "=", "0.5"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SC", "=", "0.1"}], ";"}]}], "Input",
 CellChangeTimes->{{3.9090494331566067`*^9, 3.909049563112196*^9}, {
  3.909049685905368*^9, 3.909049695555068*^9}, {3.909049819275182*^9, 
  3.909049819409315*^9}, {3.909050309613039*^9, 3.90905036734308*^9}, {
  3.9090503987630167`*^9, 3.909050399216628*^9}, {3.909050492522335*^9, 
  3.9090505346945953`*^9}, {3.915020005402335*^9, 3.9150200337908983`*^9}, {
  3.915674567540655*^9, 3.9156745677194*^9}, {3.915674860677093*^9, 
  3.91567488237071*^9}, {3.915675012028384*^9, 3.915675031330797*^9}, {
  3.915675381701655*^9, 3.915675382181055*^9}, {3.9156758818107243`*^9, 
  3.915675908446219*^9}, {3.915675977715508*^9, 3.915675978240426*^9}, {
  3.915679216162985*^9, 3.915679216849791*^9}},
 CellLabel->
  "In[601]:=",ExpressionUUID->"4cca88f9-feba-4372-8d4a-4c1e26d5e5a9"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"PIsolve", " ", "=", " ", 
   RowBox[{"Simplify", "[", 
    RowBox[{"dPIdTC", "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"thet", "->", 
        RowBox[{"0.1", "/", "SC"}]}], ",", 
       RowBox[{"rho1", "->", 
        RowBox[{"r1", "/", "SC"}]}], ",", 
       RowBox[{"rho2", "->", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "-", "r1"}], ")"}], "/", "SC"}]}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DELsolve", " ", "=", " ", 
   RowBox[{"Simplify", "[", 
    RowBox[{"dDELdTC", "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"thet", "->", 
        RowBox[{"0.1", "/", "SC"}]}], ",", 
       RowBox[{"rho1", "->", 
        RowBox[{"r1", "/", "SC"}]}], ",", 
       RowBox[{"rho2", "->", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "-", "r1"}], ")"}], "/", "SC"}]}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"s1C", "=", 
   RowBox[{"NDSolve", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"PI", "'"}], "[", "T", "]"}], "==", "PIsolve"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"DEL", "'"}], "[", "T", "]"}], "==", "DELsolve"}], ",", 
       RowBox[{
        RowBox[{"DEL", "[", "10", "]"}], "==", "0"}], ",", 
       RowBox[{
        RowBox[{"PI", "[", "10", "]"}], " ", "==", " ", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"PI", ",", "DEL"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"T", ",", "10", ",", 
       RowBox[{"-", "40"}]}], "}"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.904872549756247*^9, 3.904872549760933*^9}, {
   3.9048726124255466`*^9, 3.9048726378647423`*^9}, {3.904872682217321*^9, 
   3.9048726977194443`*^9}, {3.904872918689548*^9, 3.90487296319888*^9}, {
   3.9048729972401867`*^9, 3.904873005385723*^9}, {3.904873353676889*^9, 
   3.9048733538350573`*^9}, {3.90487355199867*^9, 3.9048735768441973`*^9}, {
   3.904874257561905*^9, 3.904874293402482*^9}, 3.9048746079660997`*^9, {
   3.904876496812817*^9, 3.904876519244967*^9}, {3.9048765944806957`*^9, 
   3.90487664354998*^9}, {3.904878248924048*^9, 3.904878253276434*^9}, 
   3.904878451234967*^9, {3.904966636821453*^9, 3.904966651202189*^9}, {
   3.9067863054612713`*^9, 3.906786320574843*^9}, {3.906792087854341*^9, 
   3.906792102381044*^9}, {3.9067924181676073`*^9, 3.9067924191249332`*^9}, {
   3.906792608455905*^9, 3.906792611566052*^9}, {3.906792657357177*^9, 
   3.906792662118952*^9}, {3.906793143742342*^9, 3.906793171735874*^9}, {
   3.906793247160363*^9, 3.9067932539234953`*^9}, {3.9067933369868917`*^9, 
   3.906793342729514*^9}, {3.906793451946694*^9, 3.9067934560009403`*^9}, {
   3.907051774432563*^9, 3.907051789136566*^9}, {3.907051825005147*^9, 
   3.9070518475862923`*^9}, {3.9070522117641773`*^9, 3.90705221769657*^9}, {
   3.907052693290683*^9, 3.9070527033047657`*^9}, {3.9070541611987553`*^9, 
   3.907054177280862*^9}, {3.907311790001951*^9, 3.907311849129178*^9}, {
   3.907311947258919*^9, 3.9073119647617283`*^9}, {3.907312013009848*^9, 
   3.9073120267711267`*^9}, {3.907667958506104*^9, 3.907667991149673*^9}, {
   3.907668056235461*^9, 3.90766812434468*^9}, {3.9076681979431133`*^9, 
   3.9076682060728188`*^9}, {3.9076692579192*^9, 3.907669274117312*^9}, {
   3.909049572755795*^9, 3.909049645502926*^9}, {3.909050440427177*^9, 
   3.909050443546796*^9}, {3.915019980549096*^9, 3.9150199829564657`*^9}, {
   3.915674838198558*^9, 3.91567484146039*^9}, {3.915675016275755*^9, 
   3.915675023420556*^9}, {3.915675265773178*^9, 3.915675268780858*^9}, {
   3.915675915214253*^9, 3.9156759210990458`*^9}, {3.9156792269343243`*^9, 
   3.915679228006884*^9}},
 CellLabel->
  "In[603]:=",ExpressionUUID->"afeb2b85-7aaf-48b2-a1e7-40ac10acce20"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"PIsolve", " ", "=", " ", 
   RowBox[{"Simplify", "[", 
    RowBox[{"dPIdTC", "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"thet", "->", 
        RowBox[{"0.01", "/", "SC"}]}], ",", 
       RowBox[{"rho1", "->", 
        RowBox[{"r1", "/", "SC"}]}], ",", 
       RowBox[{"rho2", "->", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "-", "r1"}], ")"}], "/", "SC"}]}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DELsolve", " ", "=", " ", 
   RowBox[{"Simplify", "[", 
    RowBox[{"dDELdTC", "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"thet", "->", 
        RowBox[{"0.01", "/", "SC"}]}], ",", 
       RowBox[{"rho1", "->", 
        RowBox[{"r1", "/", "SC"}]}], ",", 
       RowBox[{"rho2", "->", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "-", "r1"}], ")"}], "/", "SC"}]}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"s2C", "=", 
   RowBox[{"NDSolve", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"PI", "'"}], "[", "T", "]"}], "==", "PIsolve"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"DEL", "'"}], "[", "T", "]"}], "==", "DELsolve"}], ",", 
       RowBox[{
        RowBox[{"DEL", "[", "10", "]"}], "==", "0"}], ",", 
       RowBox[{
        RowBox[{"PI", "[", "10", "]"}], " ", "==", " ", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"PI", ",", "DEL"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"T", ",", "10", ",", 
       RowBox[{"-", "40"}]}], "}"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.904874273874234*^9, 3.904874277497774*^9}, 
   3.9048746139089203`*^9, {3.9048765205872297`*^9, 3.904876525390477*^9}, {
   3.904876599160657*^9, 3.904876646277412*^9}, {3.904878255331595*^9, 
   3.904878260018879*^9}, 3.904878453059987*^9, {3.904966638431175*^9, 
   3.904966652855665*^9}, {3.906786323790214*^9, 3.906786328197921*^9}, {
   3.9067920800952*^9, 3.9067921158369703`*^9}, {3.9067924151123247`*^9, 
   3.906792416415338*^9}, {3.906792612502233*^9, 3.9067926155092983`*^9}, {
   3.906792665384075*^9, 3.906792669994688*^9}, {3.9067931490271606`*^9, 
   3.9067931670092583`*^9}, {3.9067932415948477`*^9, 3.906793243763031*^9}, {
   3.9067933252748833`*^9, 3.906793331544113*^9}, {3.906793458978339*^9, 
   3.906793462265483*^9}, {3.907051851716661*^9, 3.907051854442355*^9}, {
   3.9070522294069357`*^9, 3.907052248403158*^9}, {3.907052695191889*^9, 
   3.907052701554744*^9}, {3.9070541651270638`*^9, 3.907054174776421*^9}, {
   3.907311855537239*^9, 3.90731188042229*^9}, {3.907311949310341*^9, 
   3.9073119625944433`*^9}, {3.907312031386229*^9, 3.907312054962866*^9}, {
   3.907667993549411*^9, 3.907668014340146*^9}, 3.907668061163171*^9, {
   3.907668225265152*^9, 3.907668234017829*^9}, {3.907669263574415*^9, 
   3.907669283828974*^9}, {3.909049603463135*^9, 3.9090496144546633`*^9}, {
   3.9090496481215487`*^9, 3.909049657323761*^9}, {3.909050447961809*^9, 
   3.909050450860299*^9}, {3.91501998492268*^9, 3.915019987845848*^9}, {
   3.915674843452585*^9, 3.9156748465033484`*^9}, {3.915675036962928*^9, 
   3.91567504004381*^9}, {3.915675271182386*^9, 3.915675272443675*^9}, {
   3.9156759225553513`*^9, 3.915675925652602*^9}, {3.915679230589539*^9, 
   3.915679231546694*^9}},
 CellLabel->
  "In[606]:=",ExpressionUUID->"35246893-c11c-40b6-89bb-16a5778eb82f"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"PIsolve", " ", "=", " ", 
   RowBox[{"Simplify", "[", 
    RowBox[{"dPIdTC", "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"thet", "->", 
        RowBox[{"0.001", "/", "SC"}]}], ",", " ", 
       RowBox[{"rho1", "->", 
        RowBox[{"r1", "/", "SC"}]}], ",", 
       RowBox[{"rho2", "->", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "-", "r1"}], ")"}], "/", "SC"}]}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DELsolve", " ", "=", " ", 
   RowBox[{"Simplify", "[", 
    RowBox[{"dDELdTC", "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"thet", "->", 
        RowBox[{"0.001", "/", "SC"}]}], ",", 
       RowBox[{"rho1", "->", 
        RowBox[{"r1", "/", "SC"}]}], ",", 
       RowBox[{"rho2", "->", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "-", "r1"}], ")"}], "/", "SC"}]}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"s3C", "=", 
   RowBox[{"NDSolve", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"PI", "'"}], "[", "T", "]"}], "==", "PIsolve"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"DEL", "'"}], "[", "T", "]"}], "==", "DELsolve"}], ",", 
       RowBox[{
        RowBox[{"DEL", "[", "10", "]"}], "==", "0"}], ",", 
       RowBox[{
        RowBox[{"PI", "[", "10", "]"}], " ", "==", " ", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"PI", ",", "DEL"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"T", ",", "10", ",", 
       RowBox[{"-", "40"}]}], "}"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.904874275121776*^9, 3.904874306956203*^9}, {
   3.904874361317594*^9, 3.904874361387533*^9}, 3.904874616709448*^9, {
   3.904876527924892*^9, 3.90487653473518*^9}, {3.9048766003303967`*^9, 
   3.904876649189856*^9}, {3.904878261636324*^9, 3.9048782685084257`*^9}, 
   3.904878454451191*^9, {3.904966641969729*^9, 3.904966654446918*^9}, {
   3.906786330885509*^9, 3.9067863341588583`*^9}, {3.906786384746079*^9, 
   3.9067863991724987`*^9}, {3.90679242068841*^9, 3.906792421727631*^9}, {
   3.9067926167185297`*^9, 3.906792619869845*^9}, {3.9067926732867937`*^9, 
   3.906792684486705*^9}, {3.906793154618973*^9, 3.9067931614745607`*^9}, {
   3.906793191825987*^9, 3.906793222161763*^9}, {3.9067933327134323`*^9, 
   3.90679333581719*^9}, {3.906793465337462*^9, 3.906793469064142*^9}, {
   3.9070518572026377`*^9, 3.907051859659306*^9}, {3.907052254269155*^9, 
   3.9070522668911047`*^9}, {3.9070526967055473`*^9, 
   3.9070526996331367`*^9}, {3.907054167439365*^9, 3.9070541724170923`*^9}, {
   3.9073118870323153`*^9, 3.90731190107535*^9}, {3.907311951153818*^9, 
   3.9073119554394007`*^9}, {3.907312036562807*^9, 3.9073120484592543`*^9}, {
   3.9076680016113243`*^9, 3.907668009780011*^9}, {3.90766823747253*^9, 
   3.907668244977449*^9}, {3.907669268491973*^9, 3.907669287971963*^9}, {
   3.909049626411334*^9, 3.909049673387909*^9}, {3.909050454515645*^9, 
   3.9090504576370897`*^9}, {3.915019989827148*^9, 3.915019992607912*^9}, {
   3.915674848765842*^9, 3.915674851484756*^9}, {3.915675041194363*^9, 
   3.9156750442078*^9}, {3.915675273590013*^9, 3.915675274760998*^9}, {
   3.915675927092156*^9, 3.915675930206665*^9}, {3.915679232579114*^9, 
   3.915679233474617*^9}},
 CellLabel->
  "In[609]:=",ExpressionUUID->"71bb1a4e-ba00-482e-b4f9-fd4ae0c3c245"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Evaluate", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", "*", "SC", "*", 
         RowBox[{"PI", "[", "T", "]"}]}], "}"}], "/.", " ", "s1C"}], "]"}], 
     ",", "\[IndentingNewLine]", 
     RowBox[{"Evaluate", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", "*", "SC", "*", 
         RowBox[{"PI", "[", "T", "]"}]}], "}"}], "/.", " ", "s2C"}], "]"}], 
     ",", "\[IndentingNewLine]", 
     RowBox[{"Evaluate", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", "*", "SC", "*", 
         RowBox[{"PI", "[", "T", "]"}]}], "}"}], "/.", " ", "s3C"}], "]"}]}], 
    "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{"T", ",", 
     RowBox[{"-", "40"}], ",", "10"}], "}"}], ",", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "40"}], ",", "10"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.16", ",", "0.22"}], "}"}]}], "}"}]}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"AxesOrigin", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "40"}], ",", "0.16"}], "}"}]}], ",", "\[IndentingNewLine]",
    " ", 
   RowBox[{"AxesLabel", "->", 
    RowBox[{"{", 
     RowBox[{"T", ",", "\"\<2SB\[CapitalPi]\>\""}], "}"}]}]}], "]"}]], "Input",\

 CellChangeTimes->{{3.904873153800063*^9, 3.9048731761585693`*^9}, {
   3.904873228215217*^9, 3.904873254470806*^9}, {3.904873318526799*^9, 
   3.904873322948452*^9}, {3.90487336149325*^9, 3.904873365715081*^9}, {
   3.904873712498666*^9, 3.904873740892362*^9}, {3.9048743195934668`*^9, 
   3.904874351306569*^9}, {3.904874389969171*^9, 3.904874413604905*^9}, {
   3.9048746206949463`*^9, 3.904874624348497*^9}, {3.904875179872344*^9, 
   3.904875203192885*^9}, {3.9048753969116163`*^9, 3.9048754223441668`*^9}, {
   3.904876629380815*^9, 3.904876632764553*^9}, {3.904878281468905*^9, 
   3.904878281589134*^9}, {3.9048784558178997`*^9, 3.9048784581713753`*^9}, 
   3.904878590802092*^9, {3.904965772257105*^9, 3.9049657878195868`*^9}, {
   3.904967642532712*^9, 3.904967709803529*^9}, {3.90496774679053*^9, 
   3.9049677559456377`*^9}, {3.904967810014143*^9, 3.904967816334544*^9}, {
   3.904967950394342*^9, 3.9049679539982777`*^9}, {3.9049680168332376`*^9, 
   3.9049680616457987`*^9}, 3.904968200738636*^9, {3.904968251950255*^9, 
   3.904968281519992*^9}, {3.904968506994603*^9, 3.9049685119070387`*^9}, {
   3.9049686043672*^9, 3.904968609336738*^9}, {3.906792578622901*^9, 
   3.9067925913864107`*^9}, {3.906793269674049*^9, 3.906793269726478*^9}, {
   3.907311924546071*^9, 3.907311932137597*^9}, {3.907312070324984*^9, 
   3.907312075180005*^9}, {3.907668256530444*^9, 3.907668261801621*^9}, {
   3.90766929854132*^9, 3.9076693046622543`*^9}, {3.915108957467689*^9, 
   3.915108957593938*^9}, {3.915675302075736*^9, 3.915675305356992*^9}, {
   3.915675346000514*^9, 3.915675357178006*^9}, {3.915675394810481*^9, 
   3.915675398380411*^9}, {3.915676239909307*^9, 3.915676244649994*^9}, {
   3.91567722766343*^9, 3.915677258703264*^9}, {3.915679245441071*^9, 
   3.9156792455526876`*^9}, {3.9156795620231743`*^9, 3.915679562674881*^9}},
 CellLabel->
  "In[613]:=",ExpressionUUID->"fd612e99-0715-4cfa-97d4-9e89cc62cd95"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwt2nc8ld8fAHBkj+y97nVl772fk5WQSlaRhoZEREZIsrLKyE6hhJQtSfKc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       "]]},
     Annotation[#, "Charting`Private`Tag$21137#1"]& ], 
    TagBox[
     {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwd13k4Vc8bAHDLte/7zuVKyq4s2WZCkT0qa1JSUr5IpWyFylrZkrRJhRZK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       "]]},
     Annotation[#, "Charting`Private`Tag$21137#2"]& ], 
    TagBox[
     {RGBColor[0.560181, 0.691569, 0.194885], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwd13k8lM8fAHD3fezlXueqKGeuKGZCJSJUyN2hUHJFQjkrEcldOVKRyk2i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       "]]},
     Annotation[#, "Charting`Private`Tag$21137#3"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{
    FormBox[
     TagBox["T", HoldForm], TraditionalForm], 
    FormBox["\"2SB\[CapitalPi]\"", TraditionalForm]},
  AxesOrigin->{-40., 0.16},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{-40., 10.}, {0.16, 0.22}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.915675985906932*^9, 3.915676245249941*^9, 3.915676983042391*^9, {
   3.9156772494146013`*^9, 3.9156772591686277`*^9}, {3.91567924042117*^9, 
   3.915679248661602*^9}, {3.91567955825276*^9, 3.915679563566221*^9}},
 CellLabel->
  "Out[613]=",ExpressionUUID->"be0a8145-9bc6-4266-acac-f4c6bf407874"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{808, 911},
WindowMargins->{{293, Automatic}, {Automatic, 0}},
FrontEndVersion->"13.0 for Mac OS X ARM (64-bit) (December 2, 2021)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"da84db10-76fd-4d7a-a45a-88d61171814c"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 205, 3, 48, "Subtitle",ExpressionUUID->"ce3ea100-ada9-4aea-a72d-78e89106a4b4"],
Cell[788, 27, 278, 6, 30, "Input",ExpressionUUID->"2a13ddbe-cd25-4553-a70d-c76cc6156fde"],
Cell[1069, 35, 235, 5, 30, "Input",ExpressionUUID->"790defe2-6b02-419b-b7cc-2f37cfedc925"],
Cell[1307, 42, 450, 12, 52, "Input",ExpressionUUID->"f65146ff-55a7-42cb-a638-c69e02837880"],
Cell[1760, 56, 480, 11, 30, "Input",ExpressionUUID->"6a132bcf-babc-40df-8901-c9526e6bab7d"],
Cell[2243, 69, 1362, 40, 52, "Input",ExpressionUUID->"1034227c-f664-4b49-894f-4f0ae4acec21"],
Cell[3608, 111, 441, 10, 30, "Input",ExpressionUUID->"0d53c60a-25c0-4d93-b0bc-005291092123"],
Cell[4052, 123, 1816, 47, 94, "Input",ExpressionUUID->"152073d1-15c5-4def-aad7-7ddf1de1a8c8"],
Cell[5871, 172, 1470, 42, 94, "Input",ExpressionUUID->"9b5f4063-a23a-4fb8-9942-1e60d2a06497"],
Cell[7344, 216, 1518, 43, 94, "Input",ExpressionUUID->"97652ce3-8e85-4528-bd89-1e6858c95380"],
Cell[CellGroupData[{
Cell[8887, 263, 2137, 52, 178, "Input",ExpressionUUID->"fdbfc5d2-4125-454a-b15f-d664987ddd4c"],
Cell[11027, 317, 35053, 595, 245, "Output",ExpressionUUID->"3d19b43e-2f33-4e97-b93b-01979b50dbe3"]
}, Open  ]],
Cell[46095, 915, 392, 10, 30, "Input",ExpressionUUID->"a3c6f36c-8c8b-45a6-9c1c-2fdb2f89d1a1"],
Cell[46490, 927, 1862, 48, 94, "Input",ExpressionUUID->"ce3bb2ea-2881-4b8a-a502-c9442a124600"],
Cell[48355, 977, 1514, 43, 94, "Input",ExpressionUUID->"aa222cc9-053e-4b08-b61c-148caaa3ea53"],
Cell[49872, 1022, 1568, 44, 94, "Input",ExpressionUUID->"c8761349-1089-4c55-84f3-b61ce81ca1ed"],
Cell[CellGroupData[{
Cell[51465, 1070, 2255, 55, 178, "Input",ExpressionUUID->"3ff8df52-83c9-4d7a-bdcf-3474e5cb1984"],
Cell[53723, 1127, 29800, 510, 242, "Output",ExpressionUUID->"15a1bf42-fb20-455d-94a4-d848591387d6"]
}, Open  ]],
Cell[83538, 1640, 334, 8, 30, "Input",ExpressionUUID->"253450ff-0eab-4208-bddc-9310e489835b"],
Cell[83875, 1650, 503, 14, 52, "Input",ExpressionUUID->"ab191aad-aed2-45de-8022-74bbb95a4f6d"],
Cell[84381, 1666, 1793, 52, 52, "Input",ExpressionUUID->"39d3cbd0-524d-4b82-9240-da82fd0b6b1c"],
Cell[CellGroupData[{
Cell[86199, 1722, 1175, 21, 73, "Input",ExpressionUUID->"39234b39-413a-41d9-92a6-44085db97f83"],
Cell[87377, 1745, 203, 4, 34, "Output",ExpressionUUID->"2205374f-e4b8-44b5-a1be-cc93ee51936d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[87617, 1754, 137, 3, 30, "Input",ExpressionUUID->"b0e5faea-b138-41b2-bffc-a5d36b4b5b9c"],
Cell[87757, 1759, 233, 4, 34, "Output",ExpressionUUID->"54406dd1-153a-4684-accc-ddd833bf53b2"]
}, Open  ]],
Cell[88005, 1766, 3839, 80, 94, "Input",ExpressionUUID->"d545430e-2f4a-4bac-b698-ecaf8aacab53"],
Cell[91847, 1848, 3463, 75, 94, "Input",ExpressionUUID->"7ecf013e-a166-47f3-8353-12aea45fced5"],
Cell[95313, 1925, 3452, 75, 94, "Input",ExpressionUUID->"90eace83-dfe7-4d84-94de-fb98a4261f74"],
Cell[CellGroupData[{
Cell[98790, 2004, 3327, 71, 199, "Input",ExpressionUUID->"fca797a9-0911-46a9-a0b1-d0716b240550"],
Cell[102120, 2077, 37014, 630, 252, "Output",ExpressionUUID->"e16709f6-9429-4f12-8e84-bccd1adc2cfd"]
}, Open  ]],
Cell[139149, 2710, 348, 8, 30, "Input",ExpressionUUID->"2617a46d-94e2-46dc-959b-dd9ea31505f5"],
Cell[139500, 2720, 503, 14, 52, "Input",ExpressionUUID->"d420e323-9288-4988-82b9-c4e1541e05be"],
Cell[140006, 2736, 1793, 52, 52, "Input",ExpressionUUID->"34856874-9116-4b68-bf21-0fae4313685f"],
Cell[141802, 2790, 1101, 22, 73, "Input",ExpressionUUID->"a70cd7e0-8f1a-4613-849f-3ac67f6b6774"],
Cell[142906, 2814, 3911, 83, 94, "Input",ExpressionUUID->"19aa34c8-ae75-415a-8c46-1e3768bbfe2f"],
Cell[146820, 2899, 3537, 78, 94, "Input",ExpressionUUID->"1a9676b3-9095-48da-923b-44629f2e3658"],
Cell[150360, 2979, 3528, 78, 94, "Input",ExpressionUUID->"2f247542-34a1-4b6f-9eed-5f09ed3d9138"],
Cell[CellGroupData[{
Cell[153913, 3061, 3581, 74, 199, "Input",ExpressionUUID->"e60541c9-8e89-4805-b8e6-46245d74fe0d"],
Cell[157497, 3137, 31575, 541, 252, "Output",ExpressionUUID->"3b09d086-f9a1-40d7-a97e-5215f42c00e0"]
}, Open  ]],
Cell[CellGroupData[{
Cell[189109, 3683, 265, 7, 30, "Input",ExpressionUUID->"03d1233b-819b-48a6-8fa5-fd227cfbfe62"],
Cell[189377, 3692, 219, 5, 34, "Output",ExpressionUUID->"97454297-3e74-4be0-a946-e53d20dd5d82"]
}, Open  ]],
Cell[189611, 3700, 589, 12, 30, "Input",ExpressionUUID->"e62a7994-786e-43d2-9241-6657339f9edd"],
Cell[190203, 3714, 503, 14, 52, "Input",ExpressionUUID->"6d2497ac-74bf-40ab-9bbe-022054146778"],
Cell[190709, 3730, 1793, 52, 52, "Input",ExpressionUUID->"c8612ea9-a194-4f2c-ba06-9def54547932"],
Cell[192505, 3784, 1117, 22, 73, "Input",ExpressionUUID->"4cca88f9-feba-4372-8d4a-4c1e26d5e5a9"],
Cell[193625, 3808, 3816, 82, 94, "Input",ExpressionUUID->"afeb2b85-7aaf-48b2-a1e7-40ac10acce20"],
Cell[197444, 3892, 3437, 77, 94, "Input",ExpressionUUID->"35246893-c11c-40b6-89bb-16a5778eb82f"],
Cell[200884, 3971, 3424, 77, 94, "Input",ExpressionUUID->"71bb1a4e-ba00-482e-b4f9-fd4ae0c3c245"],
Cell[CellGroupData[{
Cell[204333, 4052, 3382, 71, 199, "Input",ExpressionUUID->"fd612e99-0715-4cfa-97d4-9e89cc62cd95"],
Cell[207718, 4125, 31836, 544, 252, "Output",ExpressionUUID->"be0a8145-9bc6-4266-acac-f4c6bf407874"]
}, Open  ]]
}, Open  ]]
}
]
*)

