% Date: 24.01.2024
% Project: Signatures  
% Script: Simulation 2 for interference plots (Fogarty & Otto, Figure 5)
% Author: Laurel Fogarty

clear all

PlotColorst = {[0.00,0.45,0.74,0.1],[0.85,0.33,0.10,0.1],[0.9290 0.6940 0.1250,0.1]};
PlotColors = {[0.00,0.45,0.74],[0.85,0.33,0.10],[0.9290 0.6940 0.1250]};

N = 10^3; % population size
SC = 0.1; % fitness increment for cultural trait
SA = 0.1; % fitness increment for allele

wC = 1+SC;
wA = 1+SA;

g1_vec =  [0.1:0.05:0.9];
g2_vec = 0.5;

fixationbProbability_gc = zeros(numel(g1_vec),numel(g2_vec));
fixationbProbability_expected = zeros(numel(g1_vec),numel(g2_vec));
timeToFixation_gc = zeros(numel(g1_vec),numel(g2_vec));

nGen = 500*N; % generations to run for
reps = 100000;

%% No cultural interference, benchmark

GEN = zeros(1,nGen);

for r = 1:reps
    r
    Genes = zeros(N,1);
    
    Fitness = ones(N,1);
    offspringGenes = zeros(N,1);
    
    % initialise
    genIn = randsample(N,1);
    Genes(genIn) = ones;
    
    GEN(1) = sum(Genes)/N;
    
    for t = 2:nGen
        
        % calculate fitness of all individuals in the population
        
        gFitness = (Genes.*wA);
        gFitness(find(gFitness==0)) = ones;
        
        Fitness = gFitness;
        
        % pick parents weighted by fitness
        
        parent1 = randsample(N,N,1,Fitness);%getParents(N,N,Fitness);
        parent2 = randsample(N,N,1,Fitness);%getParents(N,N,Fitness);
        
        % first pick genetic parents with normal proportions
        % parent 1 or parent 2?
        
        geneticParent =  randsample(2,N,1);
        geneticParentOnes = find(geneticParent==1);
        geneticParentTwos = find(geneticParent==2);
        
        offspringGenes(geneticParentOnes) = Genes(parent1(geneticParentOnes));
        offspringGenes(geneticParentTwos) = Genes(parent2(geneticParentTwos));
        
        Genes = offspringGenes;
        
        GEN(t) = sum(Genes)/N;
        
        if GEN(t)==1
            dlmwrite('FIX_gN1000longg1_lrE.csv',t,'delimiter',',','-append')
            dlmwrite('SOU_gN1000longg1_lrE.csv',t,'delimiter',',','-append')
            break
        elseif GEN(t)==0
            dlmwrite('SOU_gN1000longg1_lrE.csv',t,'delimiter',',','-append')
            break
        end
        
    end
    
    
    %% Cultural interference with affinity bias
    % parameters
    
    for g1 = 1:numel(g1_vec)
        gamma_1 = g1_vec(g1);
        
        for g2 = 1:numel(g2_vec)
            gamma_2 = g2_vec(g2);
            
            CULT = zeros(1,nGen);
            GEN = zeros(1,nGen);
            
            Culture = zeros(N,1);
            Genes = zeros(N,1);
            
            Fitness = ones(N,1);
            offspringGenes = zeros(N,1);
            offspringCulture = zeros(N,1);
            
            % initialise
            cultIn = randsample(N,N/2,0);
            Culture(cultIn) = ones;
            
            genIn = randsample(N,1);
            Genes(genIn) = ones;
            
            CULT(1) = sum(Culture)/N;
            GEN(1) = sum(Genes)/N;
            
            for t = 2:nGen
                
                offspringGenes = zeros(N,1);
                offspringCulture = zeros(N,1);
                
                % calculate fitness of all individuals in the population
                cFitness = (Culture.*wC);
                cFitness(find(cFitness==0)) = ones;
                
                gFitness = (Genes.*wA);
                gFitness(find(gFitness==0)) = ones;
                
                Fitness = cFitness.*gFitness;
                
                % pick parents weighted by fitness
                
                parent1 = randsample(N,N,1,Fitness);
                parent2 = randsample(N,N,1,Fitness);
                pars = [parent1 parent2];
                
                % make offspring
                mixedMatings = find(Culture(parent1)~=Culture(parent2)); % all mixed cultural families are mixed matings here. 
                normalMatings = setdiff([1:N],mixedMatings);
                
                X = binornd(1,0.5,[1,numel(normalMatings)])+1;
                offspringGenes(normalMatings) = Genes(pars(sub2ind([N,2],normalMatings,X)));
                offspringCulture(normalMatings) = Culture(pars(sub2ind([N,2],normalMatings,X)));
                
                % tricky mixed matings
                % first genes
                if numel(mixedMatings)>0
                    Y = binornd(1,0.5,[1,numel(mixedMatings)])+1;
                    nY = Y;
                    nY(nY==1)=0;
                    nY(nY==2)=1;
                    nY(nY==0)=2;
                    offspringGenes(mixedMatings) = Genes(pars(sub2ind([N,2],mixedMatings,Y')));
                    % now culture
                    % does cultural parent match genetic parent?
                    
                    for i = 1:numel(mixedMatings)
                        ind = mixedMatings(i);
                        gp = pars(ind,Y(i));
                        ngp = pars(ind,nY(i));
                        
                        if Genes(pars(ind,Y(i)))==0
                            if rand<gamma_2
                                offspringCulture(ind) = 1;
                            else
                                offspringCulture(ind) = 0;
                            end
                        else
                            if rand<gamma_1
                                offspringCulture(ind) = 1;
                            else
                                offspringCulture(ind) = 0;
                            end
                        end
                        
                    end
                end
                Genes = offspringGenes;
                Culture = offspringCulture;
                
                CULT(t) = sum(Culture)/N;
                GEN(t) = sum(Genes)/N;
                label = g1;
                if GEN(t)==1
                    dlmwrite(['FIX_gcN1000longg1_lrE',num2str(label),'.csv'],t,'delimiter',',','-append')
                    dlmwrite(['SOU_gcN1000longg1_lrE',num2str(label),'.csv'],t,'delimiter',',','-append')
                    break
                elseif GEN(t)==0
                    dlmwrite(['SOU_gcN1000longg1_lrE',num2str(label),'.csv'],t,'delimiter',',','-append')
                    break
                end
                
            end
        end
        
    end
    
end



