% Date: 10.01.2024
% Project: Signatures  
% Script: Interference plots (Fogarty & Otto, Figure 5)
% Author: Laurel Fogarty

% Figure 4 is a two panel figure illustrating time to fixation and
% probability of fixation for affinty bias and cultural trait bias relative to the 
% case of no intereference 

% First generate data and ammend paths in dlmread functions and parameters accordingly 
% Data for affinity bias is generated by FogartyOtto_Figure5Sims_Affinity.m 
% Data for cultural trait bias is generated by FogartyOtto_Figure5Sims_Trait.m 

clear all 

PlotColors = {[0.00,0.45,0.74],[0.85,0.33,0.10],[0.9290 0.6940 0.1250]};

%% Affinity bias 
figure

N = 10^3;
reps = 300000;
SA = 0.1; 
SC = 0.1; 
b1_vec = [0:0.001:0.05 0.055:0.005:0.1];
b2_vec = [0.001];
nGen = 500*N;

% gene-only case 
FIXg = dlmread('FIX_gN1000longb1_lr.csv');
SOUg = dlmread('SOU_gN1000longb1_lr.csv');

FIXg = FIXg-1;
SOUg = SOUg-1;

fixationProbability_g = numel(FIXg)/numel(SOUg);
fixationTime_g = mean(FIXg);
sojournTime_g = mean(SOUg);

numel(SOUg)/reps 

% gene-culture cases

fixationbProbability_gc = zeros(1,numel(b1_vec));
fixationTime_gc = zeros(1,numel(b1_vec));
sojournTime_gc = zeros(1,numel(b1_vec));

for b1 = 1:numel(b1_vec)
    
    label = b1;
    FIXgcb2 = dlmread(['FIX_gcN1000longb1_lr',num2str(label),'.csv']);
    SOUgcb2 = dlmread(['SOU_gcN1000longb1_lr',num2str(label),'.csv']);
    
    FIXgcb2 = FIXgcb2-1;
    SOUgcb2 = SOUgcb2-1;
    
    numel(FIXgcb2)
    numel(SOUgcb2)/reps
    
    fixationbProbability_gc(b1) = numel(FIXgcb2)/numel(SOUgcb2);
    fixationTime_gc(b1) = mean(FIXgcb2);
    sojournTime_gc(b1) = mean(SOUgcb2);
    
%     hold on 
%     subplot(1,2,1)
%     scatter(ones(1,numel(FIXgc)).*b1_vec(b1),FIXgc,'MarkerFaceAlpha',.2,'MarkerEdgeAlpha',.2)
end

probability_expectation = (1-exp(-2*SA*N*1/N))/(1-exp(-2*SA*N));% This is derived from the diffusion approximation
probability_expectation_2 = 0.1761; % this is derived from a branching process, numerically solved - best for strong selection and large populations  

subplot(1,2,1)
hold on 
plot(b1_vec(2:end),fixationTime_gc(2:end)./(ones(1,numel(b1_vec)-1).*fixationTime_g),'-.','LineWidth',2,'color',PlotColors{1})
%plot(b1_vec(2:end),sojournTime_gc(2:end)./(ones(1,numel(b1_vec)-1).*sojournTime_g),'-o','LineWidth',2,'color',PlotColors{1}) 
plot(b1_vec(2:end),fixationbProbability_gc(2:end)./(ones(1,numel(b1_vec)-1).*fixationProbability_g),'-s','LineWidth',2,'color',PlotColors{3})
box on 

MathematicaValues = [0.767671,0.794361, 0.8139277517106435,0.835625, 0.8468788947429191, 0.905784, 0.920768,0.9318539882870714, 0.9616456012414745];
vals = [0.001, 0.003, 0.005,0.008, 0.01,0.03, 0.04, 0.05,0.1];
plot(vals,MathematicaValues,'ro--')

ylabel('Relative value','FontSize',14)
xlabel('$\beta_1$','Interpreter', 'latex','FontSize',14)

plot(b1_vec(2:end),ones(1,numel(b1_vec)-1),'k--','LineWidth',2)

legend('Fixation time','Fixation Probability')
title('(A) Affinity bias')

%ylabel('Relative fixation probability','FontSize',14)
%xlabel('$\beta_1$','Interpreter', 'latex','FontSize',14)

%plot(b1_vec,ones(1,numel(b1_vec)).*probability_expectation,'r--','LineWidth',2)

%% Cultural trait bias 

N = 10^3;
reps = 300000;
SA = 0.1; 
SC = 0.1; 
g1_vec = [0.1:0.05:0.9];% 0.1:0.1:0.4
g2_vec = [0.5];

% gene-only case 
FIXg = dlmread('FIX_gN1000longg1_lr.csv');
SOUg = dlmread('SOU_gN1000longg1_lr.csv');

FIXg = FIXg-1;
SOUg = SOUg-1;

fixationProbability_g = numel(FIXg)/numel(SOUg);
fixationTime_g = mean(FIXg);
sojournTime_g = mean(SOUg);

% gene-culture cases

fixationbProbability_gc = zeros(1,numel(g1_vec));
fixationbProbability_expected = ones(1,numel(g1_vec)).*(SA*2);
fixationTime_gc = zeros(1,numel(g1_vec));
sojournTime_gc = zeros(1,numel(g1_vec));

fixationTime_gc_error = zeros(1,numel(g1_vec));
sojournTime_gc_error = zeros(1,numel(g1_vec));

for g1 = 1:numel(g1_vec)
    label = g1;
    FIXgcg2 = dlmread(['FIX_gcN1000longg1_lr',num2str(label),'.csv']);
    SOUgcg2 = dlmread(['SOU_gcN1000longg1_lr',num2str(label),'.csv']);
    
    FIXgcg2 = FIXgcg2-1;
    SOUgcg2 = SOUgcg2-1; 
    
    max(SOUgcg2)
    min(SOUgcg2)
    
    numel(SOUgcg2)/reps

    fixationbProbability_gc(g1) = numel(FIXgcg2)/numel(SOUgcg2);
    fixationTime_gc(g1) = mean(FIXgcg2);
    sojournTime_gc(g1) = mean(SOUgcg2);
    
    fixationTime_gc_error(g1) = std(FIXgcg2)/sqrt(numel(FIXgcg2));
    sojournTime_gc_error(g1) = std(SOUgcg2)/sqrt(numel(SOUgcg2));
%     
% %     hold on 
%     subplot(1,2,1)
%     scatter(ones(1,numel(FIXgcg2)).*g1_vec(g1),FIXgcg2./fixationTime_g,'MarkerEdgeColor',PlotColors{1},'MarkerFaceAlpha',.002,'MarkerEdgeAlpha',.002)
%     scatter(ones(1,numel(SOUgcg2)).*g1_vec(g1),SOUgcg2./sojournTime_g,'MarkerEdgeColor',PlotColors{2},'MarkerFaceAlpha',.002,'MarkerEdgeAlpha',.002)

end

probability_expectation = (1-exp(-2*SA*N*1/N))/(1-exp(-2*SA*N));% This is derived from the diffusion approximation
probability_expectation_2 = 0.1761; % this is derived from a branching process, numerically solved - best for strong selection and large populations  

subplot(1,2,2)
hold on 
plot(g1_vec,fixationTime_gc./(ones(1,numel(g1_vec)).*fixationTime_g),'-.','LineWidth',2,'color',PlotColors{1})
%plot(g1_vec,sojournTime_gc./(ones(1,numel(g1_vec)).*sojournTime_g),'-o','LineWidth',2,'color',PlotColors{2})
plot(g1_vec,ones(1,numel(g1_vec)),'k--','LineWidth',2)
ylabel('Relative value','FontSize',14)
xlabel('$\gamma_1$','Interpreter', 'latex','FontSize',14)
 box on 

subplot(1,2,2)
plot(g1_vec,fixationbProbability_gc./(ones(1,numel(g1_vec)).*fixationProbability_g),'-s','LineWidth',2,'color',PlotColors{3})
%plot(g1_vec,fixationbProbability_gc./(ones(1,numel(g1_vec)).*probability_expectation),'-s','LineWidth',2,'color',PlotColors{3})

hold on 
plot(g1_vec,ones(1,numel(g1_vec)),'k--','LineWidth',2)

%ylabel('Relative fixation probability','FontSize',14)
%xlabel('$\gamma_1$','Interpreter', 'latex','FontSize',14)

MathematicaValues = [0.630367 0.759834 0.853184 0.9294 0.995139 1.05364 1.10676 1.15568 1.20122];
plot([0.1:0.1:0.9],MathematicaValues,'ro--')

box on 
title('(B) Cultural trait bias')
