using Plots
using CSV
using DataFrames
using Statistics
using Colors

HAPS_FS_G1 = CSV.read("FogartyOtto_H2H1_g_r001.csv", CSV.Tables.matrix, header=false);
HAPS_FS_G2 = CSV.read("FogartyOtto_H2H1_g_neutral_r001.csv", CSV.Tables.matrix, header=false);

HAPS_FS_B00001 = CSV.read("FogartyOtto_H2H1_beta00001r001.csv", CSV.Tables.matrix, header=false)
HAPS_FS_B0001= CSV.read("FogartyOtto_H2H1_beta0001r001.csv", CSV.Tables.matrix, header=false)
HAPS_FS_B001 = CSV.read("FogartyOtto_H2H1_beta001r001.csv", CSV.Tables.matrix, header=false)
HAPS_FS_B01 = CSV.read("FogartyOtto_H2H1_beta01r001.csv", CSV.Tables.matrix, header=false)
HAPS_FS_B015 = CSV.read("FogartyOtto_H2H1_beta015r001.csv", CSV.Tables.matrix, header=false)
HAPS_FS_B025 = CSV.read("FogartyOtto_H2H1_beta025r001.csv", CSV.Tables.matrix, header=false)
HAPS_FS_B05 = CSV.read("FogartyOtto_H2H1_beta05r001.csv", CSV.Tables.matrix, header=false)
HAPS_FS_B1 = CSV.read("FogartyOtto_H2H1_beta1r001.csv", CSV.Tables.matrix, header=false)

#HAPS_FS_B003 = CSV.read("FogartyOtto_H2H1_beta003.csv", DataFrame, header=false)
#HAPS_FS_B005 = CSV.read("FogartyOtto_H2H1_beta005.csv", DataFrame, header=false)
#HAPS_FS_B008 = CSV.read("FogartyOtto_H2H1_beta008.csv", DataFrame, header=false)
#HAPS_FS_B01 = CSV.read("FogartyOtto_H2H1_beta01.csv", DataFrame, header=false)

A = mean(HAPS_FS_B00001);
B = mean(HAPS_FS_B0001);
C = mean(HAPS_FS_B001);
D = mean(HAPS_FS_B01);
E = mean(HAPS_FS_B015);
F = mean(HAPS_FS_B025);
H = mean(HAPS_FS_B05);
I = mean(HAPS_FS_B1);

G1 = mean(HAPS_FS_G1);
G2 = mean(HAPS_FS_G2);

HAPS_FS = [A,B,C,D,E,F,H,I];
Beta = [0.00001,0.0001,0.001,0.01,0.015,0.025,0.05,0.1];


# HAPS_FS = [A,B,C,D,E,F,H,I];
# Beta = [0,0.0001,0.0005,0.001,0.0015,0.005,0.01,0.1];

# plot them

PC = plot(xlabel="Beta", ylabel="H2/H1", ylims=(0,1))
plot!((Beta),HAPS_FS)
plot!([(0.00001),(0.1)],[G1,G1])# plot!([-1,0], [3,3])
plot!([(0.00001),(0.1)],[G2,G2])# plot!([-1,0], [3,3])
scatter!((Beta),HAPS_FS,markersize=2,legend=:bottomleft)

savefig(PC,"GarudTest_BetaFig_log3.png")
