# hitchiking simulation
# simulating the genomic signatures of cultural hitchiking.
# Laurel Fogarty
# 23.11.2023
## model 1 -- 4 neutral alleles, 1 selected allele, no culture

using DataFrames
using Distributions
using CSV
using DelimitedFiles
using StatsBase
using Shuffle

include("FogartyOtto_Fig3_Functions.jl")

N = 10000;
reps = 500;
mu = 0.0001;
SC = 0.01;

rec1 = 10^-2;
rec2 = 10^-4;

burnin_time = 5*N;
selection_time =burnin_time+2*N;

p = Binomial(5*N, mu);
q1 = Binomial(N, rec1);
q2 = Binomial(N, rec2);

## simulations

for r in 1:reps

    print(r)
    saveflag=0;
    GENOME = zeros(5,N); # 1 selected, distal, 2 proximate, distal
    mutation_number = rand(p,selection_time);
    recom1_number = rand(q1,selection_time);
    recom2_number = rand(q2,selection_time);
    recom3_number = rand(q2,selection_time);
    recom4_number = rand(q1,selection_time);

    for t in 1:selection_time
        # Some efficient Wright Fisher stuff here
        # find the parents, 1 is reference
        if t<burnin_time
            global parents = sample(1:N,N,replace=true);
            global fitw = aweights(ones(1,N));
        elseif t==burnin_time
            mutant = sample(1:N,1);
            GENOME[3,mutant[1]] = 2;
            lucky = [GENOME[3,:].==2].*SC
            local fitness = ones(N,1)./10+lucky[1];
            global fitw = aweights(fitness);
            global parents = wsample(1:N,fitw,N,replace=true);

        else
            lucky = [GENOME[3,:].==2].*SC
            if sum(lucky[1])==0
                print(":extinct, ")
                saveflag = 0;
                break
            elseif sum(lucky[1])>((N-10)*SC)
                print(":fixed, ")
                #pwd = pairwise_distance_sample(N, GENOME,pairs,npairs);
                # list the haplotypes
                HAPS = countmap(eachcol(GENOME));

                # list frequencies
                HAPS_C = collect(values(HAPS));
                HAPS_F = HAPS_C./sum(HAPS_C);

                # order the list
                HAPS_FS = sort(HAPS_F,rev=true);

                H1 = sum(HAPS_FS.^2);
                H2 = sum(HAPS_FS[2:end].^2);

                H2H1 =  H2./H1;

                open("FogartyOtto_H2H1_postReview_g_r001.csv", "a") do io
                    writedlm(io, H2H1,',') end

                break
            end
            local fitness = ones(N,1)./10+lucky[1];
            global fitw = aweights(fitness);
            global parents = wsample(1:N,fitw,N,replace=true);
        end

        kids_genome = GENOME[:,parents];

        # mutation

        if mutation_number[t]>0
            mutants = sample(1:5*N,mutation_number[t],replace=false);
            kids_genome[mutants] = rand(mutation_number[t]); # pop in mutations
        end

        # recombination
        total_recombiners = recom1_number[t]+recom2_number[t]+recom3_number[t]+recom4_number[t];
        recombiners_mainlist = sample(1:N,total_recombiners,replace=false);
        recombiners_mainlist = shuffle(recombiners_mainlist);

        recombiners1 = recombiners_mainlist[1:recom1_number[t]];
        recombiners2 = recombiners_mainlist[recom1_number[t]+1:recom1_number[t]+recom2_number[t]];
        recombiners3 = recombiners_mainlist[recom1_number[t]+recom2_number[t]+1:recom1_number[t]+recom2_number[t]+recom3_number[t]];
        recombiners4 = recombiners_mainlist[recom1_number[t]+recom2_number[t]+recom3_number[t]+1:end];

        if recom4_number[t]>0
            kids_genome = recombination(recom4_number[t],recombiners4,kids_genome,GENOME,fitw,5);end
        if recom1_number[t]>0
            kids_genome = recombination(recom1_number[t],recombiners1,kids_genome,GENOME,fitw,1);end
        if recom2_number[t]>0
            kids_genome = recombination(recom2_number[t],recombiners2,kids_genome,GENOME,fitw,2);end
        if recom3_number[t]>0
            kids_genome = recombination(recom3_number[t],recombiners3,kids_genome,GENOME,fitw,4);end

        # next gen
        GENOME = kids_genome;

    end

    # #pwd = pairwise_distance_sample(N, GENOME,pairs,npairs);
    # if saveflag==1
    #     local het = heterozygosity(GENOME,N);#(GENOME);
    #     open("FogartyOtto_Fig3_Genetic_N104mu14.csv", "a") do io
    #         writedlm(io, het,',') end
    # end
end
