using Plots
using CSV
using DataFrames
using Random
using Statistics
using Colors

D1 = CSV.read("FogartyOtto_Fig3_Genetic_N104mu14.csv", DataFrame, header=false);
D2 = CSV.read("FogartyOtto_Fig3_N104mu14_beta01.csv", DataFrame, header=false)
D3 = CSV.read("FogartyOtto_Fig3_N104mu14_beta005.csv", DataFrame, header=false)
D4 = CSV.read("FogartyOtto_Fig3_N104mu14_beta0001.csv", DataFrame, header=false)

PD1 = Matrix(D1);
MPD1 = mean(PD1,dims=1);

PD2 = Matrix(D2);
MPD2 = mean(PD2,dims=1);

PD3 = Matrix(D3);
MPD3 = mean(PD3,dims=1);

PD4 = Matrix(D4);
MPD4 = mean(PD4,dims=1);

LOCI = collect(-2:2);
#LOCI = [-0.2,-0.001,0,0.001,0.2];

N = 10000;
mu = 0.0001;
THET = 2*N*mu;
HetValue = repeat([1-1/(1+THET)],5,1);
#alpha = 0.01,

plot(LOCI,HetValue, linestyle=:dash, color = "red",dpi=1000)

plot!(LOCI, PD1', seriestype=:line, markersize=3, alpha = 0.02, color="black",markerstrokewidth=0,dpi=1000)
plot!(LOCI, PD2', seriestype=:line, markersize=3, alpha = 0.02, color="red",markerstrokewidth=0,dpi=1000)
plot!(LOCI, PD3', seriestype=:line, markersize=3, alpha = 0.02, color="gold1",markerstrokewidth=0,dpi=1000)
plot!(LOCI, PD4', seriestype=:line, markersize=3, alpha = 0.02, color="darkorange",markerstrokewidth=0,dpi=1000)

plot!(LOCI, MPD1', seriestype=:line, marker = :circle, markersize=2, color="black",markerstrokewidth=0.2,legend=false,dpi=1000 )
plot!(LOCI, MPD2', seriestype=:line, marker = :circle, markersize=2, color="red",markerstrokewidth=0.2,legend=false,dpi=1000 )
plot!(LOCI, MPD3', seriestype=:line, marker = :circle, markersize=2, color="gold1",markerstrokewidth=0.2,legend=false,dpi=1000 )
OutPlot = plot!(LOCI, MPD4', seriestype=:line, marker = :circle, markersize=2, color="darkorange",xlabel = "Chromosome", xguidefonthalign = :left, ylabel = "Average heterozygosity", xticks = [-1,-2,0,1,2], markerstrokewidth=0.2,legend=false,dpi=1000)

savefig(OutPlot,"Hitchhiking_N104mu14_seltest_30NOV_julia_compare3Line.png")
savefig(OutPlot,"Hitchhiking_N104mu14_seltest_30NOV_julia_compare3Line.svg")
