% Date: 11.09.2023
% Project: Signatures  
% Script: Hitchhiking plots (Fogarty & Otto, Figure 1)
% Author: Laurel Fogarty

% Figure 1 is a two panel figure illustrating hitchiking of a neutral
% genetic allele on a cultural trait under selection. 

clear all

%% Initialise figure

figure;
PlotColors = {[0.00,0.45,0.74],[0.85,0.33,0.10],[0.9290 0.6940 0.1250]};

% blue: 0.00,0.45,0.74
% Red:0.85,0.33,0.10
% Yellow: 0.9290 0.6940 0.1250

%% Comparison - gene-only system

nGen = 300;
N = 10^6;
SB = 0.001;
r = 0.00001;

Precord = zeros(1,nGen);
Qrecord = zeros(1,nGen);
Acrecord = zeros(1,nGen);
ACrecord = zeros(1,nGen);
Arecord = zeros(1,nGen);

p0 = 1/N;
Q0 = 1;
R0 = 0.5;

p = p0;
Q = Q0;
R = R0;

for t = 1:nGen
    
    % Find P'
    
    WBAR =1+p*SB;
    Pprime = p*(1+SB)*(1+p*SB)/(WBAR^2);
    
    % Find Q', R'
    
    f1 = (p^2)*(Q^2);
    f2 = 2*(p^2)*Q*(1 - Q);
    f3 = 2*p*(1 - p)*Q*R;
    f4 = 2*p*(1 - p)*Q*(1 - R);
    f5 = (p^2)*((1-Q)^2);
    f6 = 2*p*(1 - p)*(1 - Q)*R;
    f7 = 2*p*(1 - p)*(1 - Q)*(1 - R);
    f8 = ((1 - p)^2)*(R^2);
    f9 = 2*((1 - p)^2)*R*(1 - R);
    f10 = ((1 - p)^2)*((1 - R)^2);
    
    ACprime = ((f1*((1+SB)^2) + f2*((1+SB)^2)/2 + f3*(1+SB)/2 + f4*((1 - r)/2)*(1+SB) + f6*(r/2)*(1+SB)))/(WBAR^2);
    Acprime = (f3*(1+SB)/2 + f4*(1+SB)*r/2 + f6*(1+SB)*(1-r)/2 + f8 + f9/2)/(WBAR^2);
    
    Qprime = ((1+p*SB)*Q + r*(1-p)*(R-Q))/(1+p*SB); %ACprime/Pprime;
    Rprime = Acprime/(1-Pprime);
    
    % Find frequency of A allele
    
    freqAprime = ACprime+Acprime;
    
    % update and record everything
    Precord(t) = Pprime;
    Qrecord(t) = Qprime;
    ACrecord(t) = ACprime;
    Acrecord(t) = Acprime;
    
    Arecord(t) = freqAprime;
    
    p = Pprime; % update
    Q = Qprime;
    R = Rprime;
    
end

HH0 = Q*(1-Q)/(R0*(1-R0)); % heterozygosity

% subplot(3,1,1)
% 
% hold on
% plot(1:nGen, Precord,'LineWidth',2)
% plot(1:nGen, Arecord,'LineWidth',2)
% 
% % legend('Frequency of B', 'Frequency of A') % toggle on and off legend
% title('(A) Genetic','Interpreter','latex')
% ylabel('Frequency')
% 
% box on

%% Panel A - gene-culture system, vertical transmission with affinity bias, 3 values

% beta_1_vec = [5*10^-2,6*10^-2,7*10^-2];
% beta_2_vec = [10^-3,10^-4,10^-5];
% beta_1_vec = [0.05 0.06 0.07];
% beta_2_vec = [10^-3 10^-4 10^-5];

beta_1_vec = [0.05 0.06 0.07];
beta_2_vec = [10^-4 10^-4 10^-4];


for ii = 1:numel(beta_1_vec)
    
    Precord_c = zeros(1,nGen);
    Qrecord_c = zeros(1,nGen);
    Acrecord_c = zeros(1,nGen);
    ACrecord_c = zeros(1,nGen);
    Arecord_c = zeros(1,nGen);
    
    beta_1 = beta_1_vec(ii);
    beta_2 = beta_2_vec(ii);
    
    SC = 0.1;
    p0 = 1/N;
    Q0 = 1;
    R0 = 0.5;
    
    p = p0;
    Q = Q0;
    R = R0;
    
    for t = 1:nGen
                
        WBAR =1+p*SC;
        
        % Find Q', R', p'
        
        f1 = (p^2)*(Q^2);
        f2 = 2*(p^2)*Q*(1 - Q);
        f3 = 2*p*(1 - p)*Q*R;
        f4 = 2*p*(1 - p)*Q*(1 - R);
        f5 = (p^2)*((1-Q)^2);
        f6 = 2*p*(1 - p)*(1 - Q)*R;
        f7 = 2*p*(1 - p)*(1 - Q)*(1 - R);
        f8 = ((1 - p)^2)*(R^2);
        f9 = 2*((1 - p)^2)*R*(1 - R);
        f10 = ((1 - p)^2)*((1 - R)^2);
        
        ACprime = ((f1*((1+SC)^2) + f2*((1+SC)^2)/2 + f3*(1+SC)/2 + f4*((1 - beta_1)/2)*(1+SC) + f6*(beta_1/2)*(1+SC)))/(WBAR^2);
        Acprime = (f3*(1+SC)/2 + f4*(1+SC)*beta_1/2 + f6*(1+SC)*(1-beta_1)/2 + f8 + f9/2)/(WBAR^2);
        
        aCprime = (f2*((1+SC)^2)/2 + f4*((beta_2)/2)*(1+SC) + f5*((1+SC)^2) + f6*(1-beta_2)*(1+SC)/2 + f7*(1+SC)/2)/(WBAR^2);
        acprime = (f4*(1+SC)*(1-beta_2)/2 + f6*(1+SC)*(beta_2)/2 + f7*(1+SC)/2 + f9/2 + f10)/(WBAR^2);
        
        Pprime = ACprime+aCprime;
        
        Qprime = ACprime/Pprime;
        Rprime = Acprime/(1-Pprime);
        
        % Find frequency of A allele
        
        freqAprime = ACprime+Acprime;
        
        % update and record everything
        Precord_c(t) = Pprime;
        Qrecord_c(t) = Qprime;
        ACrecord_c(t) = ACprime;
        Acrecord_c(t) = Acprime;
        
        Arecord_c(t) = ACprime+Acprime;
        
        p = Pprime; % update p
        Q = Qprime;
        R = Rprime;
        
    end
    
    HH0_c = Q*(1-Q)/(R0*(1-R0))
    
    subplot(2,1,1)
    hold on
    plot(1:nGen, Precord_c,'--','LineWidth',2,'color',PlotColors{ii})
    plot(1:nGen, Arecord_c,'LineWidth',2,'color',PlotColors{ii})
    
end

%legend('Frequency of C', 'Frequency of A')

title('(A) Vertical cultural transmission (affinity bias)','Interpreter','latex')
ylabel('Frequency')

box on

%% Panel B = gene-culture system, vertical transmission with cultural trait bias,3 values

nGen = 100;

% gamma_1_vec = 0.5+[0.1,0.2,0.3]; 
% gamma_2_vec = 0.5-[0.1,0.2,0.3]; 

gamma_1_vec = [0.75 0.85 0.95]; 
gamma_2_vec = [0.5 0.5 0.5]; 

for ii = 1:numel(gamma_1_vec)
    
    Precord_c = zeros(1,nGen);
    Qrecord_c = zeros(1,nGen);
    Acrecord_c = zeros(1,nGen);
    ACrecord_c = zeros(1,nGen);
    Arecord_c = zeros(1,nGen);
    
    p0 = 1/N;
    Q0 = 1;
    
    gamma_1 = gamma_1_vec(ii);
    gamma_2 = gamma_2_vec(ii);
    
    p = p0;
    Q = Q0;
    R = R0;
    
    for t = 1:nGen
        
        % Find P'
        
        WBAR =1+p*SC;
        Pprime = (p*(1+SC)*((1+SC)*p+(1-p)*(gamma_1*(Q+R)+gamma_2*(2-R-Q))))/(WBAR^2);
        
        % Find Q'
        
        f1 = (p^2)*(Q^2);
        f2 = 2*(p^2)*Q*(1 - Q);
        f3 = 2*p*(1 - p)*Q*R;
        f4 = 2*p*(1 - p)*Q*(1 - R);
        f5 = (p^2)*((1-Q)^2);
        f6 = 2*p*(1 - p)*(1 - Q)*R;
        f7 = 2*p*(1 - p)*(1 - Q)*(1 - R);
        f8 = ((1 - p)^2)*(R^2);
        f9 = 2*((1 - p)^2)*R*(1 - R);
        f10 = ((1 - p)^2)*((1 - R)^2);
        

        ACprime = (f1*((1+SC)^2)+(f2/2)*(1+SC)^2+f3*(1+SC)*gamma_1+(f4/2)*(1+SC)*gamma_1+(f6/2)*(1+SC)*gamma_1)/(WBAR^2);
        Acprime = (f3*(1+SC)*(1-gamma_1) + f4*(1+SC)*(1-gamma_1)/2 + f6*(1+SC)*(1-gamma_1)/2 + f8 + f9/2)/(WBAR^2);
        
        aCprime = ((f2/2)*((1+SC)^2)+(f4/2)*(1+SC)*gamma_2+f5*((1+SC)^2)+(f6/2)*gamma_2*(1+SC)+f7*(1+SC)*gamma_2)/(WBAR^2);
        acprime = ((f4/2)*(1-gamma_2)*(1+SC)+(f6/2)*(1-gamma_2)*(1+SC)+f7*(1+SC)*(1-gamma_2)+f9/2+f10)/(WBAR^2);

        Qprime = ACprime/Pprime;
        Rprime = Acprime/(1-Pprime);
        
        % Find frequency of A allele
        
        freqAprime = ACprime+Acprime;
        
        % update and record everything
        
        Precord_c(t) = Pprime;
        Qrecord_c(t) = Qprime;
        ACrecord_c(t) = ACprime;
        Acrecord_c(t) = Acprime;
        
        p = Pprime; % update p
        Q = Qprime;
        R = Rprime;
        
        Arecord_c(t) = p*(Q)+(1-p)*R;%ACprime+Acprime;
        
    end
    
    HH0_c = Q*(1-Q)/(R0*(1-R0))
    
    subplot(2,1,2)
    
    plot(1:nGen, Precord_c,'--','color',PlotColors{ii},'LineWidth',2)
    hold on
    plot(1:nGen, Arecord_c,'color',PlotColors{ii},'LineWidth',2)
    
end

title('(B) Vertical cultural transmission (cultural trait bias)','Interpreter','latex')
xlabel('Time (generations)')
ylabel('Frequency')
