ListCases:=[];
IntSelect:=[2,3,4];
for iSelfHed in [2..4]
do
  Add(ListCases, []);
od;
for nSelfHed in [1..20]
do
  Print("nSelfHed=", nSelfHed, "\n");
  for iSelfHed in IntSelect
  do
    iSelfHedPos:=iSelfHed-1;
    FileName:=Concatenation("DataHedrites/", String(iSelfHed), "-SelfHedrite", String(nSelfHed));
    if IsExistingFile(FileName) then
      LPLori:=ReadAsFunction(FileName)();
    else
      LPLori:=[];
    fi;
    nbG:=Length(LPLori);
    Print("  iSelfHed=", iSelfHed, " |LPLori|=", nbG, "\n");
    for iPLori in [1..nbG]
    do
      ePLori:=LPLori[iPLori];
      GRPinfo:=GroupPlanOriented(ePLori);
      if GRPinfo.SchoenfliesSymbol="C1" then
        PLoriMed:=MedialGraphOriented(ePLori);
        GRPinfo2:=GroupPlanOriented(PLoriMed);
        if Order(GRPinfo2.SymmetryGroup)<>2 then
          Error("Order should be 2");
        fi;
        eSymb:=GRPinfo2.SchoenfliesSymbol;
        if eSymb="C2" then
          eStable:=GRPinfo2.TotalGroup.RotationAxis[1].ListStable;
          ListStableNat:=[0,0,0];
          for eNat in eStable
          do
            eStat:=GRPinfo2.CC.VectStat[eNat];
            ListStableNat[eStat]:=ListStableNat[eStat] + 1;
          od;
          eCase:=rec(eSymb:="C2", ListStableNat:=ListStableNat);
        else
          eCase:=rec(eSymb:=eSymb);
        fi;
        Add(ListCases[iSelfHedPos], eCase);
      fi;
    od;
  od;
od;
