FileOutput:="InformationSelfDualGrid";
RemoveFileIfExist(FileOutput);

output:=OutputTextFile(FileOutput, true);

ListGroupFound:=[];
ListGroupFound2:=[];
ListMinimalRepresentative:=[];
ListPairGroupFound:=[];
ListPosOrder:=[2,4,8];

nbV:=3;
while(true)
do
  nbV:=nbV+1;
  FileName:=Concatenation("DataHedrites/SelfDualGrid",String(nbV));
  if IsExistingFile(FileName)=false then
    break;
  fi;
  LPL:=ReadAsFunction(FileName)();
  Print("Treating the self-dual grids with ", nbV, " vertices\n");
  ListFound:=[0,0,0];
  for iGraph in [1..Length(LPL)]
  do
    PL:=LPL[iGraph];
    ZZ:=ZigZag(PL);
    GRP:=GroupPlan(PL);
    PL2:=MedialGraph(PL).PlanGraph;
    GRP2:=GroupPlan(PL2);
    MinOrder:=340000;
    MedToOrig:=MedialToOriginals(PL2);
    ListFaces1:=MedToOrig[1].Faces;
    ListFaces2:=MedToOrig[2].Faces;
    ListPos1:=List(ListFaces1, x->Position(GRP2.CC.ListCells, x));
    ListPos2:=List(ListFaces2, x->Position(GRP2.CC.ListCells, x));
    nb1:=Length(ListPos1);
    nb2:=Length(ListPos2);
    nbInv:=0;
    nbCons:=0;
    for eElt in GRP2.SymmetryGroup
    do
      ListStat:=ListWithIdenticalEntries(nb1,-1);
      for i1 in [1..nb1]
      do
        i2:=OnPoints(ListPos1[i1], eElt);
        if Position(ListPos1, i2)<>fail then
          ListStat[i1]:=0;
        elif Position(ListPos2, i2)<>fail then
          ListStat[i1]:=1;
        else
          Print("Inconsistency in ListPos1, ListPos2\n");
          Print(NullMat(5));
        fi;
      od;
      if Length(Set(ListStat))<>1 then
        Print("Error!!!!!\n");
        Print(NullMat(5));
      fi;
      eStat:=ListStat[1];
      TheOrd:=Order(eElt);
      if eStat=1 then
        if TheOrd < MinOrder then
          MinOrder:=TheOrd;
          eEltFound:=eElt;
        fi;
        nbInv:=nbInv+1;
      else
        nbCons:=nbCons+1;
      fi;
    od;
    if nbInv<>nbCons then
      Print("One inconsistency has been found\n");
      Print(NullMat(5));
    fi;
#    Print("eEltFound=", eEltFound, "\n");
    pos:=Position(ListPosOrder, MinOrder);
    ListFound[pos]:=ListFound[pos]+1;
  od;
  Print("ListFound=", ListFound, "\n");
od;