nbCol:=4;

ListEntries:=[];
for nbV in [2..40]
do
  eFile2:=Concatenation("DataHedrites/2SelfHedrite", String(nbV));
  eFile3:=Concatenation("DataHedrites/3SelfHedrite", String(nbV));
  eFile4:=Concatenation("DataHedrites/SelfDualGrid", String(nbV));
  if IsExistingFile(eFile2)=false then
    nb2:=0;
  else
    nb2:=Length(ReadAsFunction(eFile2)());
  fi;
  eStr2:=String(nb2);
  if IsExistingFile(eFile3)=false then
    nb3:=0;
  else
    nb3:=Length(ReadAsFunction(eFile3)());
  fi;
  eStr3:=String(nb3);
  if IsExistingFile(eFile4)=false then
    nb4:=0;
  else
    nb4:=Length(ReadAsFunction(eFile4)());
  fi;
  eStr4:=String(nb4);
  eStr:=String(nbV);
  eEntry:=[eStr, eStr2, eStr3, eStr4];
  Add(ListEntries, eEntry);
  Print("nbV=", nbV, " eEntry=", eEntry, "\n");
od;
HeaderPart:="n & {\\bf 2} & {\\bf 3} & {\\bf 4}";

FileOutput:="LatexFiles/TheSelfHedriteTable";
RemoveFileIfExist(FileOutput);
output:=OutputTextFile(FileOutput, true);
PrintLatexFileHeader(output, ListEntries, nbCol, HeaderPart);
CloseStream(output);
#
FinalFileTex:="LatexFiles/TheSelfHedriteTable.tex";
FinalFileDVI:="LatexFiles/TheSelfHedriteTable.dvi";
FileTex:="TheSelfHedriteTable.tex";
FileDVI:="TheSelfHedriteTable.dvi";
RemoveFileIfExist(FinalFileTex);
RemoveFileIfExist(FinalFileDVI);
Exec("cat Header.tex ", FileOutput, " Footer.tex > ", FinalFileTex);
Exec("(cd LatexFiles && latex ", FileTex, ")");
Exec("(cd LatexFiles && dvips ", FileDVI, " -o )");
#

