FileOutput:="InformationSelfDualGrid";
RemoveFileIfExist(FileOutput);

output:=OutputTextFile(FileOutput, true);

IsReducedGraphSimple:=function(PL, GRPperm)
  local nbV, WeightMat, O, iO, jO, iVert, jVert, nbO, FindPos;
  nbV:=Length(PL);
  O:=Orbits(GRPperm, [1..nbV], OnPoints);
  nbO:=Length(O);
  WeightMat:=NullMat(nbO, nbO);
  FindPos:=function(iVert)
    local iO;
    for iO in [1..nbO]
    do
      if Position(O[iO], iVert)<>fail then
        return iO;
      fi;
    od;
  end;
  for iVert in [1..nbV]
  do
    iO:=FindPos(iVert);
    for jVert in PL[iVert]
    do
      jO:=FindPos(jVert);
      WeightMat[iO][jO]:=WeightMat[iO][jO]+1;
    od;
  od;
  for iO in [1..nbO]
  do
    if WeightMat[iO][iO]>0 then
      Print("Kill 1\n");
      return false;
    fi;
  od;
  for iO in [1..nbO-1]
  do
    for jO in [iO+1..nbO]
    do
      if WeightMat[iO][jO]>Order(GRPperm) then
        return false;
      fi;
    od;
  od;
  return true;
end;


ListGroupFound:=[];
ListGroupFound2:=[];
ListMinimalRepresentative:=[];
ListPairGroupFound:=[];
nbV:=3;
while(true)
do
  if nbV=10 then
#    break;
  fi;
  nbV:=nbV+1;
  FileName:=Concatenation("DataHedrites/SelfDualGrid",String(nbV));
  if IsExistingFile(FileName)=false then
    break;
  fi;
  LPL:=ReadAsFunction(FileName)();
  Print("Treating the self-dual grids with ", nbV, " vertices\n");
  for iGraph in [1..Length(LPL)]
  do
    PL:=LPL[iGraph];
    ZZ:=ZigZag(PL);
    GRP:=GroupPlan(PL);
    eSymb:=GRP.SchoenfliesSymbol;
    AppendTo(output, nbV, ":", iGraph, " ");
    AppendTo(output, "(", eSymb, ")");
    AppendTo(output, " z=", ZZ.Zvector);
    AppendTo(output, "\n");
    PL2:=MedialGraph(PL).PlanGraph;
    GRP2:=GroupPlan(PL2);
    eSymb2:=GRP2.SchoenfliesSymbol;
    eInv:=GRP.TotalGroup.Inversion;
    if eInv<>false then
      GrpAnti:=Group([eInv]);
      test:=IsReducedGraphSimple(PL, GrpAnti);
      if test=true then
        FileAnti:=Concatenation("PLselfanti", String(nbV), "_", String(iGraph));
        PlanGraphToCaGe(FileAnti, PL);
        Print("Find one at FileAnti=", FileAnti, " G=", GRP.SchoenfliesSymbol, "\n");
      fi;
    fi;
    ePair:=rec(eSymb:=eSymb, eSymb2:=eSymb2);
    if Position(ListGroupFound, eSymb)=fail then
      Add(ListGroupFound, eSymb);
      Add(ListMinimalRepresentative, PL);
      eFileOut:=Concatenation("PictureFiles/MinimalSelfDual", eSymb, "_", String(nbV));
      PlanGraphToCaGe(eFileOut, PL);
#      Print("ListGroupFound=", ListGroupFound, "\n");
    fi;
    if Position(ListGroupFound2, eSymb2)=fail then
      Add(ListGroupFound2, eSymb2);
    fi;
    if Position(ListPairGroupFound, ePair)=fail then
      Add(ListPairGroupFound, ePair);
      for eGroup in ListGroupFound
      do
        LSel:=Filtered(ListPairGroupFound, x->x.eSymb=eGroup);
        LSel2:=List(LSel, x->x.eSymb2);
#        Print("G=", eGroup, " Cand=", LSel2, "\n");
      od;
      for eGroup2 in ListGroupFound2
      do
        LSel:=Filtered(ListPairGroupFound, x->x.eSymb2=eGroup2);
        LSel2:=List(LSel, x->x.eSymb);
#        Print("G2=", eGroup2, " Cand=", LSel2, "\n");
      od;
    fi;
  od;
od;