ListLPL:=[];
IntSelect:=[2,4];
ListOutput:=[];
for iSelf in [2..4]
do
  Add(ListLPL, []);
  eFile:=Concatenation("ProjectiveSelfDual_", String(iSelf));
  RemoveFileIfExist(eFile);
  Add(ListOutput, OutputTextFile(eFile, true));
od;


TestProjectivity:=function(PLori)
  local GRPinfo, eInv, nbVert, ListSel, ListMapping, idx, iVert, jVert, NewListVert, NewNbVert, ListListAdj, TheAnswer, iVertNew, eDE, iEdge, LInc, pos, OthPos, nbAdj, ListStatus, j, i, ListIdx, ListAdjRed, ListAdj, fDE, jVertNew;
  GRPinfo:=GroupPlanOriented(PLori);
  eInv:=GRPinfo.TotalGroup.Inversion;
  if eInv=false then
    return rec(answer:=false);
  fi;
  nbVert:=Length(GRPinfo.CC.VEF.VertSet);
  ListSel:=ListWithIdenticalEntries(nbVert, 1);
  ListMapping:=ListWithIdenticalEntries(nbVert, 1);
  idx:=0;
  for iVert in [1..nbVert]
  do
    if ListSel[iVert]=1 then
      jVert:=OnPoints(iVert, eInv);
      ListSel[jVert]:=0;
      idx:=idx+1;
      ListMapping[iVert]:=idx;
      ListMapping[jVert]:=idx;
    fi;
  od;
  NewListVert:=Filtered([1..nbVert], x->ListSel[x]=1);
  NewNbVert:=Length(NewListVert);
  ListListAdj:=[];
  TheAnswer:=true;
  for iVertNew in [1..NewNbVert]
  do
    iVert:=NewListVert[iVertNew];
    ListAdj:=[];
    for eDE in GRPinfo.CC.VEF.VertSet[iVert]
    do
      iEdge:=GRPinfo.CC.VEF.ListOriginEdge[eDE];
      LInc:=[];
      for fDE in GRPinfo.CC.VEF.EdgeSet[iEdge]
      do
        jVert:=GRPinfo.CC.VEF.ListOriginVert[fDE];
        Add(LInc, jVert);
      od;
      pos:=Position(LInc, iVert);
      if pos=fail then
        Error("iVert should be present");
      fi;
      OthPos:=3-pos;
      jVert:=LInc[OthPos];
      jVertNew:=ListMapping[jVert];
      if jVertNew=iVertNew then
#        Print("False assignment iVertNew=", iVertNew, " jVertNew=", jVertNew, "\n");
        TheAnswer:=false;
      fi;
      Add(ListAdj, jVertNew);
    od;
    nbAdj:=Length(ListAdj);
    ListStatus:=ListWithIdenticalEntries(nbAdj,1);
    for i in [1..nbAdj]
    do
      j:=NextIdx(nbAdj,i);
      if ListAdj[i]=ListAdj[j] then
        ListStatus[j]:=0;
      fi;
    od;
    ListIdx:=Filtered([1..nbAdj], x->ListStatus[x]=1);
    ListAdjRed:=ListAdj{ListIdx};
    if Length(Set(ListAdjRed))<>Length(ListAdjRed) then
#      Print("False assignment ListAdj=", ListAdj, "\n");
      TheAnswer:=false;
    fi;
    Add(ListListAdj, ListAdj);
  od;
  return rec(answer:=TheAnswer, ListListAdj:=ListListAdj);
end;

PrintListAdj:=function(output, ListAdj)
  local nbVert, iVert, eAdj;
  nbVert:=Length(ListAdj);
  AppendTo(output, "  nbVert=", nbVert, "\n");
  for iVert in [1..nbVert]
  do
    AppendTo(output, "  ", iVert, " :");
    for eAdj in ListAdj[iVert]
    do
      AppendTo(output, " ", eAdj);
    od;
    AppendTo(output, "\n");
  od;
end;

for nSelfHed in List([1..20], x->2*x)
do
  Print("nSelfHed=", nSelfHed, "\n");
  for iSelfHed in IntSelect
  do
    iSelfHedPos:=iSelfHed-1;
    FileName:=Concatenation("DataHedrites/", String(iSelfHed), "-SelfHedrite", String(nSelfHed));
    if IsExistingFile(FileName) then
      LPLori:=ReadAsFunction(FileName)();
    else
      LPLori:=[];
    fi;
    Print("  iSelfHed=", iSelfHed, " |LPLori|=", Length(LPLori), "\n");
    for ePLori in LPLori
    do
      eTest:=TestProjectivity(ePLori);
#      if IsBound(eTest.ListListAdj) then
#        Print("    ListListAdj=", eTest.ListListAdj, "\n");
#      fi;
      if eTest.answer=true then
        GRPinfo:=GroupPlanOriented(ePLori);
        eSymb:=GRPinfo.SchoenfliesSymbol;
        Print("    Found PL, G=", eSymb, "\n");
        NewRec:=rec(PLori:=ePLori, GRP:=eSymb, ListListAdj:=eTest.ListListAdj);
        Add(ListLPL[iSelfHedPos], NewRec);
        nbFound:=Length(ListLPL[iSelfHedPos]);
        AppendTo(ListOutput[iSelfHedPos], "iFound=", nbFound, "\n");
        AppendTo(ListOutput[iSelfHedPos], "  nSelfHed=", nSelfHed, " iSelfHed=", iSelfHed, "\n");
        AppendTo(ListOutput[iSelfHedPos], "  Original graph\n");
        AppendTo(ListOutput[iSelfHedPos], "  G=", eSymb, "\n");
        PL:=PlanGraphOrientedToPlanGraph(ePLori);
        PrintListAdj(ListOutput[iSelfHedPos], PL);
        AppendTo(ListOutput[iSelfHedPos], "  Projective graph\n");
        PrintListAdj(ListOutput[iSelfHedPos], eTest.ListListAdj);
      fi;
    od;
  od;
od;
for iSelf in [2..4]
do
  iSelfHedPos:=iSelfHed-1;
  CloseStream(ListOutput[iSelfHedPos]);
od;
