#TheInterval:=[3..82];
#TheInterval:=[2..10];
#TheInterval:=[78..82];
TheInterval:=[2..80];

ListDo:=[[4, 2], [6, 3], [8, 4]];
#ListDo:=[[4, 2], [6, 3]];
#ListDo:=[[8, 4]];
#ListDo:=[[4, 2]];



GenerateSingleExtension:=function(PLori, eDE)
  local rDE, nbP, NewNbP, NewListInvers, NewListNext, i, ePermInvers, ePermNext, NewPLori;
  rDE:=OnPoints(eDE, PLori.invers);
  nbP:=PLori.nbP;
  NewNbP:=nbP + 4;
  NewListInvers:=ListWithIdenticalEntries(NewNbP,0);
  NewListNext  :=ListWithIdenticalEntries(NewNbP,0);
  for i in [1..nbP]
  do
    NewListInvers[i]:=OnPoints(i, PLori.invers);
    NewListNext[i]  :=OnPoints(i, PLori.next);
  od;
  NewListInvers[eDE]:=nbP+1;
  NewListInvers[nbP+1]:=eDE;
  NewListInvers[rDE]:=nbP+2;
  NewListInvers[nbP+2]:=rDE;
  NewListInvers[nbP+3]:=nbP+4;
  NewListInvers[nbP+4]:=nbP+3;
  NewListNext[nbP+1]:=nbP+2;
  NewListNext[nbP+2]:=nbP+3;
  NewListNext[nbP+3]:=nbP+4;
  NewListNext[nbP+4]:=nbP+1;
  ePermInvers:=PermList(NewListInvers);
  ePermNext:=PermList(NewListNext);
  if ePermInvers=fail or ePermNext=fail then
    Error("Wrong construction of the graph");
  fi;
  NewPLori:=rec(invers:=ePermInvers, next:=ePermNext, nbP:=NewNbP);
  return NewPLori;
end;



GenerateAllExtension_1gon:=function(PLori, MaxNbVert)
  local LPLori, ListStatus, FuncInsert, nbG, IsFinished, iG, VEFori, nbP, iDE, jDE, iFace, jFace, iLen, jLen, NewPLori;
  LPLori:=[];
  ListStatus:=[];
  FuncInsert:=function(ePLori)
    local fPLori;
    for fPLori in LPLori
    do
      if IsIsomorphicPlanGraphOriented(ePLori, fPLori)=true then
        return;
      fi;
    od;
    Add(LPLori, ePLori);
    Add(ListStatus, 1);
  end;
  FuncInsert(PLori);
  while(true)
  do
    nbG:=Length(LPLori);
    IsFinished:=true;
    for iG in [1..nbG]
    do
      if ListStatus[iG]=1 then
        ListStatus[iG]:=0;
        IsFinished:=false;
        PLori:=LPLori[iG];
        VEFori:=PlanGraphOrientedToVEF(PLori);
        if Length(VEFori.VertSet)<=MaxNbVert then
          nbP:=PLori.nbP;
          for iDE in [1..nbP]
          do
            jDE:=OnPoints(iDE, PLori.invers);
            iFace:=VEFori.ListOriginFace[iDE];
            jFace:=VEFori.ListOriginFace[jDE];
            iLen:=Length(VEFori.FaceSet[iFace]);
            jLen:=Length(VEFori.FaceSet[jFace]);
            if iLen <= 2 and jLen <=3 then
              NewPLori:=GenerateSingleExtension(PLori, iDE);
              FuncInsert(NewPLori);
            fi;
          od;
        fi;
      fi;
    od;
    if IsFinished then
      break;
    fi;
  od;
  return LPLori;
end;


TotalListLPLori:=[];
FuncInsertGlobal:=function(ePLori)
  local fPLori;
  for fPLori in TotalListLPLori
  do
    if IsIsomorphicPlanGraphOriented(ePLori, fPLori)=true then
      return;
    fi;
  od;
  Add(TotalListLPLori, ePLori);
end;


MaxNbVert:=20;
for nHed in [1..MaxNbVert]
do
  Print("nHed=", nHed, "\n");
  for iHed in [4..8]
  do
    Print("  Considering graphs arising from ", iHed, "-hedrites with ", nHed, " vertices\n");
    FileName:=Concatenation("DataHedrites/", String(iHed), "-Hedrite",String(nHed));
    if IsExistingFile(FileName)=true then
      ListPlanGraph:=ReadAsFunction(FileName)();
    else
      ListPlanGraph:=[];
    fi;
    ApplyLPLori:=List(ListPlanGraph, PlanGraphToPlanGraphOriented);
    if iHed=2 then
      Add(ApplyLPLori, SpecialFamily4hedrite(nHed));
    fi;
    nbGraph:=Length(ListPlanGraph);
    for iGraph in [1..nbGraph]
    do
      PLori:=ApplyLPLori[iGraph];
      Print("iGraph=", iGraph, "/", nbGraph, "\n");
      GenLPLori:=GenerateAllExtension_1gon(PLori, MaxNbVert);
      Print("  |GenLPLori|=", Length(GenLPLori), "\n");
      for ePLori in GenLPLori
      do
        VEFori:=PlanGraphOrientedToVEF(ePLori);
        nb1gon:=Length(Filtered(VEFori.FaceSet, x->Length(x)=1));
        nb3gon:=Length(Filtered(VEFori.FaceSet, x->Length(x)=3));
        nbGreater4gon:=Length(Filtered(VEFori.FaceSet, x->Length(x)>4));
        if nbGreater4gon>0 then
          Print("Inconsistency in obtained graph");
        fi;
        if nb1gon=2 and nb3gon=2 then
          PairPLori:=MedialToOriginalsOriented(ePLori);
          test:=IsIsomorphicPlanGraphOriented(PairPLori[1], PairPLori[2]);
          if test=true then
            FuncInsertGlobal(PairPLori[1]);
          fi;
        fi;
      od;
    od;
  od;
od;
