DoesItComeFromSelfDualGrid:=function(PL)
  local CC, nb3, Grp, LLE, PL1, PL2, eFac, nb2, TotCurv;
  CC:=CentralCircuit(PL);
  if Length(CC.ListOdd)<>Length(CC.ListEven) then
    return false;
  fi;
  nb2:=0;
  nb3:=0;
  for eFac in CC.ListOdd
  do
    if Length(eFac)=2 then
      nb2:=nb2+1;
    fi;
    if Length(eFac)=3 then
      nb3:=nb3+1;
    fi;
  od;
  TotCurv:=2*nb2+nb3;
  if TotCurv<>4 then
    return false;
  fi;
  Grp:=GroupPlan(PL).SymmetryGroup;
  if Order(Grp)=1 then
    return false;
  fi;
  LLE:=MedialToOriginals(PL);
  PL1:=LLE[1].PlanGraph;
  PL2:=LLE[2].PlanGraph;
  if IsIsomorphicPlanGraph(PL1, PL2)=true then
    return PL1;
  fi;
  return false;
end;

TheInterval:=[8..30];

ListDo:=[
[4, 2], 
[6, 3], 
[8, 4]];
for nHed in TheInterval
do
  for eCase in ListDo
  do
    iHed:=eCase[1];
    iSelfHed:=eCase[2];
    if iSelfHed=2 then
      nSelf:=(nHed + 2)/2;
    elif iSelfHed=3 then
      nSelf:=(nHed + 1)/2;
    elif iSelfHed=4 then
      nSelf:=(nHed + 2)/2;
    else
      Print("Error\n");
      Print(NullMat(5));
    fi;
    if IsInt(nSelf)=true then
      Print("Considering graphs arising from ", iHed, "-hedrites with ", nHed, " vertices\n");
      FileName:=Concatenation("DataHedrites/", String(iHed), "-Hedrite",String(nHed));
      ListPlanGraph:=ReadAsFunction(FileName)();
      LPL:=[];
      for iGraph in [1..Length(ListPlanGraph)]
      do
        PL:=ListPlanGraph[iGraph];
        Print("PL=", PL, "\n");
        NewPL:=DoesItComeFromSelfDualGrid(PL);
        if NewPL<>false then
          Add(LPL, NewPL);
        fi;
      od;
      Print("Found ", Length(LPL), " ", iSelfHed, "-self hedrites with ", nSelf, " vertices among ", Length(ListPlanGraph), " graphs\n");
      FileName:=Concatenation("DataHedrites/", String(iSelfHed), "SelfHedrite",String(nSelf));
      SaveDataToFile(FileName, LPL);
    fi;
  od;
od;
