FileOutput4:="HH4hedrite_structure";
FileOutput5:="HH5hedrite_structure";
FileOutput6:="HH6hedrite_structure";
FileOutput7:="HH7hedrite_structure";
FileOutput8:="HH8hedrite_structure";
ListFileOutput:=[FileOutput4, FileOutput5, FileOutput6, FileOutput7, FileOutput8];

ListOutput:=[];
for i in [1..5]
do
  Add(ListOutput, OutputTextFile(ListFileOutput[i], true));
od;

MaxNbV:=[66,66,66,66,79];
#
for nbV in [5..400]
do
  #
  for i in [4..8]
  do
    j:=i-3;
    if nbV=MaxNbV[j]+1 then
      CloseStream(ListOutput[j]);
    elif nbV<=MaxNbV[j] then
      output:=ListOutput[j];
      FileName:=Concatenation("DataHedrites/", String(i), "-Hedrite",String(nbV));
      ListPlanGraph:=ReadAsFunction(FileName)();
      Print("Searching infos for ", i, "-hedrite with nbV=", nbV, "\n");
      #
      for iGraph in [1..Length(ListPlanGraph)]
      do
        PlanGraph:=ListPlanGraph[iGraph];
        CC:=CentralCircuit(PlanGraph);
        nbCC:=Length(CC.ListCircuit);
        #
        AppendTo(output, nbV, ":", iGraph);
        GrpInfo:=GroupPlan(PlanGraph);
        Grp:=GrpInfo.SymmetryGroup;
        AppendTo(output, "(", GrpInfo.SchoenfliesSymbol, ")");
        #
        AppendTo(output, " cc=", CC.CCvector);
#        AppendTo(output, "CCuniform=", CC.CCuniformity);
        if CC.CCbalancedness=false then
          AppendTo(output, "  unbalanced");
        fi;
        if CC.Tightness=true then
          word:="  Irr";
        else
          word:="  red";
        fi;
        AppendTo(output, word);
        #
        if CC.SelfIntRailroad=true then
          AppendTo(output, "  self intersecting railroad");
        fi;
        #
        test:=true;
        for iCC in [1..nbCC]
        do
          INTS:=CC.MatrixIntersectionWithTypes[iCC][iCC];
          if INTS[1]+INTS[2]>0 then
            test:=false;
          fi;
        od;
        if test=true then
          AppendTo(output, "  has simple central circuit");
        fi;
        #
        if nbCC>=2 then
          test:=IsBorromean(PlanGraph, CC);
          if test=true then
            AppendTo(output, "  boromean link");
          fi;
        fi;
        #
        if nbCC=1 then
          AppendTo(output, "  knot");
        fi;
        #
#        U:=ZZorbits(ZZ.ListZigZag, Grp);
#        AppendTo(output, "   Orb=");
#        AppendTo(output, U.SizeOrbits);
        AppendTo(output, "\n");
      od;
    fi;
  od;
od;

