ListPlanGraph:=ReadAsFunction("Octahedrite/RES.Plan2")();

VertexAsk:=15;
FileName:=Concatenation("i-hedritesTEX", String(VertexAsk));
output:=OutputTextFile(FileName, true);

for i in [4..8]
do
  AppendTo(output, "{\\bf List of ", i, "-Hedrites}\\\\\n");

  FileName:=Concatenation("DataHedrites/", String(i), "-Hedrite", String(VertexAsk));
  ListPlanGraph:=ReadAsFunction(FileName)();

  for iGraph in [1..Length(ListPlanGraph)]
  do
    PlanGraph:=ListPlanGraph[iGraph];
    U:=CentralCircuit(PlanGraph);
    DBL:=DoubleEdge(PlanGraph);
    nbDoubl:=Length(DBL[1]);


    AppendTo(output, "{\\bf ", i, "-hedrite", VertexAsk,"-", iGraph, "}\n");
    AppendTo(output, "\\begin{center}\n");
    AppendTo(output, "\\epsfxsize=80mm\n");
    AppendTo(output, "\\epsfbox{",i,"-hedrite", VertexAsk,"-", iGraph, ".ps}\n");
    AppendTo(output, "\\end{center}\n");
    AppendTo(output, "Double Edges=", DBL[2], "\n\n");
    AppendTo(output, "CentralCircuit symbol=", U.CCvector, "\n\n");
    GrpInfo:=GroupPlan(PlanGraph);
    AppendTo(output, "PointGroup=", GrpInfo.SchoenfliesSymbol, "\n\n");
  od;
od;
CloseStream(output);


