ListPlanGraph:=ReadAsFunction("Octahedrite/RES.Plan2")();

output4:=OutputTextFile("Octahedrite/4-hedrites", true);;
output5:=OutputTextFile("Octahedrite/5-hedrites", true);;
output6:=OutputTextFile("Octahedrite/6-hedrites", true);;
output7:=OutputTextFile("Octahedrite/7-hedrites", true);;
output8:=OutputTextFile("Octahedrite/8-hedrites", true);;
AppendTo(output4, "List of 4-hedrites\n");
AppendTo(output5, "List of 5-hedrites\n");
AppendTo(output6, "List of 6-hedrites\n");
AppendTo(output7, "List of 7-hedrites\n");
AppendTo(output8, "List of 8-hedrites\n");

for i in [1..1]
do
  PlanGraph:=ListPlanGraph[i];
  U:=CentralCircuit(PlanGraph);
  SpaceGroupInfo:=GroupPlanSecond(PlanGraph);
  VertexSet:=SpaceGroupInfo[2];
  GP:=AutGroupGraph(SpaceGroupInfo[1]);
  nbVert:=Length(PlanGraph);
  DBL:=DoubleEdge(PlanGraph);
  nbDoubl:=Length(DBL[1]);
  #
  Print(U,"\n");
  Print(GP,"\n");
  Print("GrpSize=", Order(GP),"\n");
  Print("Nb Reflexion=", Length(SpaceGroupInfo[3]),"\n");
  Print("List Angle Rotation=", SpaceGroupInfo[4], "\n");
  Print("List Rotation Axises=", SpaceGroupInfo[5], "\n");
  Print("List Angle Symmetry Rotation=", SpaceGroupInfo[6], "\n");
  Print("\n");
  #
  if nbDoubl=0 then
    output:=output8;
    code:=8;
  fi;
  if nbDoubl=1 then
    output:=output7;
    code:=7;
  fi;
  if nbDoubl=2 then
    output:=output6;
    code:=6;
  fi;
  if nbDoubl=3 then
    output:=output5;
    code:=5;
  fi;
  if nbDoubl=4 then
    output:=output4;
    code:=4;
  fi;
  #
  AppendTo(output, code,"-",nbVert);
  #
  AppendTo(output, "\\begin{center}\n");
  AppendTo(output, "\\epsfxsize=80mm\n");
  AppendTo(output, "\\epsfbox{RES",i,".ps}\n");
  AppendTo(output, "\\end{center}\n");
  #
  AppendTo(output, "Double Edges=", DBL[2], "\n\n");
  #
  AppendTo(output, "CentralCircuit=", U[1], "\n\n");
  #
  AppendTo(output, "CentralCircuit symbol=", U[2], "\n\n");
  #
  #
  AppendTo(output, "GroupSize=", Order(GP), "\n\n");
  #
  AppendTo(output, "Group=", GP, "\n\n");
  #
#  AppendTo(output, "Schonflies Symbol=");
#  AppendTo(output, SymbolPlanarGroup(GP));
#  AppendTo(output, "\n\n");
  #
od;
CloseStream(output4);
CloseStream(output5);
CloseStream(output6);
CloseStream(output7);
CloseStream(output8);



