RequirePackage("plangraph");

#
FileOutput:="HH8-stat";
#
ListInfo:=[];
for nbV in Union([6],[8..89])
do
  #
  FileName:=Concatenation("./DataHedrites/8-Hedrite",String(nbV));
  ListPlanGraph:=ReadAsFunction(FileName)();
  Print("Searching infos for 8-hedrite with nbV=", nbV, "\n");
  #
  nbTight:=0;
  nbG:=Length(ListPlanGraph);
  for iGraph in [1..nbG]
  do
    PlanGraph:=ListPlanGraph[iGraph];
    CC:=CentralCircuit(PlanGraph);
    if CC.Tightness=true then
      nbTight:=nbTight+1;
    fi;
  od;
  Print("    nbGraph=", nbG, "  nbTight=", nbTight, "\n");
  Add(ListInfo, [nbV, nbG, nbTight]);
  SaveDataToFile(FileOutput, ListInfo);
od;

