ListPlanGraph:=ReadAsFunction("Octahedrite/RES.Plan2")();

VertexAsk:=15;
FileName:="DataHedrites/HedritesGroup";
output:=OutputTextFile(FileName, true);


TotalListGrp:=[[],[],[],[],[]];




for nbV in [6..VertexAsk]
do
  AppendTo(output, "Groups for nbV=", nbV,"\n");
  ParticularGroupList:=[[],[],[],[],[]];
  for i in [4..8]
  do
    FileName:=Concatenation("DataHedrites/", String(i), "-Hedrite", String(nbV));
    ListPlanGraph:=ReadAsFunction(FileName)();
    for iGraph in [1..Length(ListPlanGraph)]
    do
      PlanGraph:=ListPlanGraph[iGraph];
      GrpInfo:=GroupPlan(PlanGraph);
      GroupName:=GrpInfo.SchoenfliesSymbol;
      AddSet(TotalListGrp[i-3],GroupName);
      AddSet(ParticularGroupList[i-3],GroupName);
    od;
    AppendTo(output, "Groups for ",i,"-hedrites:", ParticularGroupList[i-3],"\n");
  od;
od;
#
AppendTo(output, "Total list of groups\n");
for i in [4..8]
do
  AppendTo(output, "Groups for ",i,"-hedrites", TotalListGrp[i-3],"\n");
od;
CloseStream(output);


