i:=6;



for VertexAsk in [6..15]
do
  FileName:=Concatenation("DataHedrites/", String(i), "-Hedrite", String(VertexAsk));
  ListPlanGraph:=ReadAsFunction(FileName)();
  for iGraph in [1..Length(ListPlanGraph)]
  do
    Print("Treating ", i, "-hedrite", VertexAsk, "-", iGraph, "\n");
    PlanGraph:=ListPlanGraph[iGraph];
#    Print("PlanGraph=", PlanGraph, "\n");
    U:=CentralCircuit(PlanGraph);
    ListLength:=[];
    for eCirc in U.ListCircuit
    do
      AddSet(ListLength, Length(eCirc));
    od;
    for eLength in ListLength
    do
      ListINTV:=ShallowCopy([]);
      for iCirc in [1..Length(U.ListCircuit)]
      do
        eCirc:=U.ListCircuit[iCirc];
        if Length(eCirc)=eLength then
          AddSet(ListINTV, U.ListIntersectionVector[iCirc]);
        fi;
      od;
      if Length(ListINTV)>1 then
        Print("------------------------------------\n");
        Print("Find unbalanced", i, "-hedrite", VertexAsk, "-",iGraph, "\n");
        Print("Group ", GroupPlan(PlanGraph).SchoenfliesSymbol, "\n");
        Print("CCvector=", CentralCircuit(PlanGraph).CCvector, "\n");
        Print("------------------------------------\n");
      fi;
    od;
  od;
od;
