FileOutput:="HH8hedrite_structure";
output:=OutputTextFile(FileOutput, true);;
#
for nbV in Union([6],[8..79])
do
  #
  FileName:=Concatenation("./DataHedrites/8-Hedrite",String(nbV));
  ListPlanGraph:=ReadAsFunction(FileName)();
  Print("Searching infos for 8-hedrite with nbV=", nbV, "\n");
  #
  for iGraph in [1..Length(ListPlanGraph)]
  do
    PlanGraph:=ListPlanGraph[iGraph];
    CC:=CentralCircuit(PlanGraph);
    nbCC:=Length(CC.ListCircuit);
    #
    AppendTo(output, nbV, ":", iGraph);
    GrpInfo:=GroupPlan(PlanGraph);
    Grp:=GrpInfo.SymmetryGroup;
    AppendTo(output, "(", GrpInfo.SchoenfliesSymbol, ")");
    #
    AppendTo(output, " cc=", CC.CCvector);
#    AppendTo(output, "CCuniform=", CC.CCuniformity);
    if CC.CCbalancedness=false then
      AppendTo(output, "  unbalanced");
    fi;
    if CC.Tightness=true then
      word:="  Irr";
    else
      word:="  red";
    fi;
    #
    AppendTo(output, word);
    if CC.SelfIntRailroad=true then
      AppendTo(output, "  has Self Intersecting Railroad");
    fi;
    #
    test:=true;
    for iCC in [1..nbCC]
    do
      INTS:=CC.MatrixIntersectionWithTypes[iCC][iCC];
      if INTS[1]+INTS[2]>0 then
	test:=false;
      fi;
    od;
    if test=true then
      AppendTo(output, "  has simple central circuit");
    fi;
    #
    if nbCC=1 then
      AppendTo(output, "  knot");
    fi;
    #
    U:=CCorbits(CC.ListCircuit, Grp);
    AppendTo(output, "   Orb=");
    AppendTo(output, U.SizeOrbits);
    AppendTo(output, "\n");
  od;
od;
CloseStream(output);

