FileOutput:="CCofMfoil";
output:=OutputTextFile(FileOutput, true);;

Foil:=function(m)
  local iVert, PlanGraphNew, iPrev, iNext;
  PlanGraphNew:=[];
  for iVert in [1..m]
  do
    iPrev:=PrevIdx(m, iVert);
    iNext:=NextIdx(m, iVert);
    PlanGraphNew[iVert]:=[iPrev, iPrev, iNext, iNext];
  od;  
  return PlanGraphNew;
end;


for iFoil in [3..15]
do
  PlanGraph:=Foil(iFoil);
  Print("Treating the Foil ", iFoil, "\n");
  AppendTo(output, "\n\n\n\n");
  AppendTo(output, "Treating the Foil ", iFoil, "\n");
  nbV:=Length(PlanGraph);
  for i in [1..30]
  do
    for j in [0..i]
    do
      nbNV:=nbV*(i*i+j*j);
      nU:=i*i+j*j;
      if (nbNV in [1..2000]) and Gcd(i,j)=1 then
        Print("Treating for i=", i, "  j=", j, "  and nbV=", nbV,"\n");
        PlanGold:=OctahedriteConstruction(PlanGraph, i, j);
        CCgold:=CentralCircuit(PlanGold);
        AppendTo(output, "k=", i, " l=", j, " CC=", CCgold.CCvector);
        #
        AppendTo(output, "Int=", Set(CCgold.ListIntersectionVector));
        #
        nbCC:=Length(CCgold.ListCircuit);
        PlanProjection:=CentralCircuitDeletionHedrite(PlanGold, CCgold, [1..nbCC-1]);
        if Length(PlanProjection)>1 then
          FileSave:=Concatenation("CCprojection_", String(iFoil), "foil_", String(i),":",String(j));
          PlanGraphToCaGe(FileSave, PlanProjection);
          AppendTo(output, " GroupProj=", GroupPlan(PlanProjection).SchoenfliesSymbol);
        fi;
        AppendTo(output, "\n");
      fi;
    od;
  od;
od;
