ListPlanGraph:=ReadAsFunction("Octahedrite/RES.Plan2")();



VertexAsk:=14;

Print("VertexAsk=", VertexAsk, "\n");


FuncInsertEdge:=function(PlanGraph, Edge)
  local NewPlanGraph, nbDE, a, b;
  NewPlanGraph:=ShallowCopy(PlanGraph);
  nbDE:=Length(NewPlanGraph.Struct);
  a:=Edge[1];
  b:=Edge[2];
#  Print("a=", a, "b=", b, "\n");
  NewPlanGraph.Struct[a][1]:=nbDE+1;
  NewPlanGraph.Struct[b][1]:=nbDE+2;
  NewPlanGraph.Struct[nbDE+1]:=[a, nbDE+2, nbDE+2];
  NewPlanGraph.Struct[nbDE+2]:=[b, nbDE+1, nbDE+1];
  return NewPlanGraph;
end;



IsIhedrite:=function(PlanGraph)
  local VEF2, eVertex, eFace;
  VEF2:=PlanGraphToVEFthird(PlanGraph);
  for eVertex in VEF2.VertexSet
  do
    if Length(eVertex)>4 then
      return false;
    fi;
  od;
  for eFace in VEF2.FaceSet
  do
    if Length(eFace)>4 then
      return false;
    fi;
  od;
  return true;
end;

FuncNextTuple:=function(TTuple, nbelt)
  local Wor, len, iPos, jPos;
  Wor:=TTuple;
  if TTuple=[] then
    return "last";
  fi;
  len:=Length(TTuple);
  if TTuple[len]<nbelt then
    Wor[len]:=TTuple[len]+1;
    return Wor;
  else
    for iPos in Reversed([1..len-1])
    do
      if TTuple[iPos] +1< TTuple[iPos+1] then
        Wor[iPos]:=TTuple[iPos]+1;
        for jPos in [iPos+1..len]
        do
          Wor[jPos]:=Wor[jPos-1]+1;
        od;
        return Wor;
      fi;
    od;
    return "last";
  fi;
end;



ListPlanGraph:=[];
for iSecond in [5..12]
do
  FileIN:=Concatenation("./Hedrites/PlanGraphSecondReduced",String(iSecond));
  ListGraphForProd:=ReadAsFunction(FileIN)();
  for OrdAdj in ListGraphForProd
  do
    PlanGraph:=OrdAdjToPlanGraph(OrdAdj);
    VEF:=PlanGraphToVEFthird(PlanGraph);
    VertexSet:=VEF.VertexSet;
    EdgeSet:=VEF.EdgeSet;
    FaceSet:=VEF.FaceSet;
    nbEd:=Length(VertexSet)+Length(FaceSet);
    if nbEd in [VertexAsk-4, VertexAsk] then
      # find the list of admissible edges.
      DeltaAdd:=VertexAsk-nbEd;
      ListAdmissible:=[];
      for eEdge in EdgeSet
      do
        Pair:=[];
        for eFac in FaceSet
        do
          if Intersection(eFac, eEdge)<>[] then
            Add(Pair, eFac);
          fi;
        od;
        if Length(Pair[1])<=3 and Length(Pair[2])<=3 then
          Add(ListAdmissible, eEdge);
        fi;
      od;
      # consider the addition of vertices of valency 2
      nbAdd:=Length(ListAdmissible);
      Print("nbadmissible=", nbAdd, "\n");
      if nbAdd>=DeltaAdd then
        Element:=[];
        for iC in [1..DeltaAdd]
        do
          Element[iC]:=iC;
        od;
        repeat
          NewPlanGraph:=StructuralCopy(PlanGraph);
          for iSS in [1..DeltaAdd]
          do
            NewPlanGraph:=FuncInsertEdge(NewPlanGraph, ListAdmissible[Element[iSS]]);
          od;
          if IsIhedrite(NewPlanGraph)=true then
            Print("Find an inverse medial graph\n");
            Add(ListPlanGraph, NewPlanGraph);
          fi;
          Element:=FuncNextTuple(Element, nbAdd);
        until Element="last";
      fi;
    fi;
  od;
od;


# raffinage by i-hedriteness
List4Hedrites:=[];
List5Hedrites:=[];
List6Hedrites:=[];
List7Hedrites:=[];
List8Hedrites:=[];



for PlanGraph in ListPlanGraph
do
  MGraph:=MedialGraphSecond(PlanGraph);
  VEF:=PlanGraphToVEFsecond(MGraph);
  FaceSet:=VEF[3];
  Triangles:=[];
  for eFac in FaceSet
  do
    if Length(eFac)=3 then
      Add(Triangles, eFac);
    fi;
  od;
  if Length(Triangles)=8 then
    AddSet(List8Hedrites, MGraph);
  fi;
  if Length(Triangles)=6 then
    AddSet(List7Hedrites, MGraph);
  fi;
  if Length(Triangles)=4 then
    AddSet(List6Hedrites, MGraph);
  fi;
  if Length(Triangles)=2 then
    AddSet(List5Hedrites, MGraph);
  fi;
  if Length(Triangles)=0 then
    AddSet(List4Hedrites, MGraph);
  fi;
od;



# isomorphy breaking


