ListPlanGraph:=ReadAsFunction("Octahedrite/RES.Plan2")();



VertexAsk:=15;

Print("VertexAsk=", VertexAsk, "\n");



FuncTestHedriteness:=function(PlanGraph)
  local Faces, eFac, i;
  for i in [1..Length(PlanGraph)]
  do
    if Length(PlanGraph[i])<>4 then
      return false;
    fi;
  od;
  Faces:=PlanGraphToVEFsecond(PlanGraph)[3];
  for eFac in Faces
  do
    if not(Length(eFac) in [2,3,4]) then
      return false;
    fi;
  od;
  return true;
end;



FuncIsomorphy:=function(PlanGraph1, PlanGraph2)
  return IsIsomorphicGraph(GroupPlan(PlanGraph1)[1], GroupPlan(PlanGraph2)[1]);
end;


FuncSplitEdgeInOneDigon:=function(PlanGraph, TwoVertices)
  local NewPlanGraph, ListAdj, LOADJ, iVert, k, Pos;
  NewPlanGraph:=[];
  for iVert in [1..Length(PlanGraph)]
  do
    if not(iVert in TwoVertices) then
      NewPlanGraph[iVert]:=PlanGraph[iVert];
    fi;
    if iVert=TwoVertices[1] then
      ListAdj:=PlanGraph[iVert];
      Pos:=Position(ListAdj, TwoVertices[2]);
      LOADJ:=[TwoVertices[2],TwoVertices[2]];
      for k in [1..Length(ListAdj)-1]
      do
        Pos:=NextIdx(Length(ListAdj),Pos);
        LOADJ[Length(LOADJ)+1]:=ListAdj[Pos];
      od;
      NewPlanGraph[iVert]:=LOADJ;
    fi;
    if iVert=TwoVertices[2] then
      ListAdj:=PlanGraph[iVert];
      Pos:=Position(ListAdj, TwoVertices[1]);
      LOADJ:=[TwoVertices[1],TwoVertices[1]];
      for k in [1..Length(ListAdj)-1]
      do
        Pos:=NextIdx(Length(ListAdj),Pos);
        LOADJ[Length(LOADJ)+1]:=ListAdj[Pos];
      od;
      NewPlanGraph[iVert]:=LOADJ;
    fi;
  od;
  return NewPlanGraph;
end;






FuncSplitEdgeInTwoDigons:=function(PlanGraph, TwoVertices)
  local NewPlanGraph, ListAdj, LOADJ, iVert, k, Pos, nbVert;
  NewPlanGraph:=[];
  nbVert:=Length(PlanGraph);
  for iVert in [1..nbVert]
  do
    if not(iVert in TwoVertices) then
      NewPlanGraph[iVert]:=PlanGraph[iVert];
    fi;
    if iVert=TwoVertices[1] then
      ListAdj:=PlanGraph[iVert];
      Pos:=Position(ListAdj, TwoVertices[2]);
      LOADJ:=[nbVert+1,nbVert+1];
      for k in [1..Length(ListAdj)-1]
      do
        Pos:=NextIdx(Length(ListAdj),Pos);
        LOADJ[Length(LOADJ)+1]:=ListAdj[Pos];
      od;
      NewPlanGraph[iVert]:=LOADJ;
    fi;
    if iVert=TwoVertices[2] then
      ListAdj:=PlanGraph[iVert];
      Pos:=Position(ListAdj, TwoVertices[1]);
      LOADJ:=[nbVert+1,nbVert+1];
      for k in [1..Length(ListAdj)-1]
      do
        Pos:=NextIdx(Length(ListAdj),Pos);
        LOADJ[Length(LOADJ)+1]:=ListAdj[Pos];
      od;
      NewPlanGraph[iVert]:=LOADJ;
    fi;
  od;
  NewPlanGraph[nbVert+1]:=[TwoVertices[1],TwoVertices[1],TwoVertices[2],TwoVertices[2]];
  return NewPlanGraph;
end;



FuncSetPairs:=function(n)
  local ePart, Part, test, eSet, PartReturn;
  Part:=PartitionsSet([1..n],n/2);
  PartReturn:=[];
  for ePart in Part
  do
    test:=1;
    for eSet in ePart
    do
      if Length(eSet)<>2 then
	test:=0;
      fi;
    od;
    if test=1 then
      AddSet(PartReturn, ePart);
    fi;
  od;
  return PartReturn;
end;



#
#
#
# creating the 8-hedrites, i.e. octahedrites
#Print("Treating the 8-hedrites\n");
FileIN:=Concatenation("./Hedrites/ListPlanGraphBis",String(VertexAsk));
FileOUT:=Concatenation("./Hedrites/8-Hedrite",String(VertexAsk));

ListPlanGraph:=ReadAsFunction(FileIN)();
ListSelectedPlanGraph:=[];

for ePlanGraph in ListPlanGraph
do
  test:=1;
  for eAdj in ePlanGraph
  do
    if Length(eAdj)<>4 then
      test:=0;
    fi;
  od;
  if test=1 then
    ListSelectedPlanGraph[Length(ListSelectedPlanGraph)+1]:=ePlanGraph;
  fi;
od;
SaveDataToFile(FileOUT, ListSelectedPlanGraph);
Print("Find ", Length(ListSelectedPlanGraph), " different 8-hedrites\n");

for iPlan in [1..Length(ListSelectedPlanGraph)]
do
  FileName:=Concatenation("./Hedrites/8-hedrite", String(VertexAsk),"-", String(iPlan));
  PlanGraphToCaGe(FileName, ListSelectedPlanGraph[iPlan]);
od;





#
#
#
# creating the 7-hedrites
#Print("Treating the 7-hedrites\n");
FileOUT:=Concatenation("./Hedrites/7-Hedrite",String(VertexAsk));
FileIN:=Concatenation("./Hedrites/ListPlanGraphBis",String(VertexAsk));

ListPlanGraph:=ReadAsFunction(FileIN)();
ListSelectedPlanGraph:=[];

for ePlanGraph in ListPlanGraph
do
  Val3:=[];
  for iV in [1..Length(ePlanGraph)]
  do
    ListAdj:=ePlanGraph[iV];
    if Length(ListAdj)<>4 then
      AddSet(Val3, iV);
    fi;
  od;
  if Length(Val3)=2 and Val3[2] in ePlanGraph[Val3[1]] then
    ListSelectedPlanGraph[Length(ListSelectedPlanGraph)+1]:=FuncSplitEdgeInOneDigon(ePlanGraph, Val3);
  fi;
od;
SaveDataToFile(FileOUT, ListSelectedPlanGraph);
Print("Find ", Length(ListSelectedPlanGraph), " different 7-hedrites\n");

for iPlan in [1..Length(ListSelectedPlanGraph)]
do
  FileName:=Concatenation("./Hedrites/7-hedrite", String(VertexAsk),"-", String(iPlan));
  PlanGraphToCaGe(FileName, ListSelectedPlanGraph[iPlan]);
od;






#
#
#
# creating the 6-hedrites
#Print("Treating the 6-hedrites\n");
FileOUT:=Concatenation("./Hedrites/6-Hedrite",String(VertexAsk));

ListSelectedPlanGraph:=[];

# first case: two digons sharing a common vertex
FileIN:=Concatenation("./Hedrites/ListPlanGraphBis",String(VertexAsk-1));
ListPlanGraph:=ReadAsFunction(FileIN)();

for ePlanGraph in ListPlanGraph
do
  Val3:=[];
  for iVert in [1..Length(ePlanGraph)]
  do
    ListAdj:=ePlanGraph[iVert];
    if Length(ListAdj)<>4 then
      AddSet(Val3, iVert);
    fi;
  od;
  if Length(Val3)=2 and Val3[2] in ePlanGraph[Val3[1]] then
    NewPlanGraph:=FuncSplitEdgeInTwoDigons(ePlanGraph, Val3);
    if FuncTestHedriteness(NewPlanGraph)=true then
      ListSelectedPlanGraph[Length(ListSelectedPlanGraph)+1]:=NewPlanGraph;
    fi;
  fi;
od;





#second cases two digons not sharing a vertex
FileIN:=Concatenation("./Hedrites/ListPlanGraphBis",String(VertexAsk));
ListPlanGraph:=ReadAsFunction(FileIN)();

CL:=[[[1,2],[3,4]],[[1,3],[2,4]],[[1,4],[2,3]]];

for ePlanGraph in ListPlanGraph
do
  Val3:=[];
  for iVert in [1..Length(ePlanGraph)]
  do
    ListAdj:=ePlanGraph[iVert];
    if Length(ListAdj)<>4 then
      AddSet(Val3, iVert);
    fi;
  od;
  if Length(Val3)=4 then
    for eSol in CL
    do
      Vert1:=Val3[eSol[1][1]];
      Vert2:=Val3[eSol[1][2]];
      Vert3:=Val3[eSol[2][1]];
      Vert4:=Val3[eSol[2][2]];
      if Vert1 in ePlanGraph[Vert2] and Vert3 in ePlanGraph[Vert4] then
        NewPlanGraph:=ShallowCopy(ePlanGraph);
        NewPlanGraph:=ShallowCopy(FuncSplitEdgeInOneDigon(NewPlanGraph, [Vert1,Vert2]));
        NewPlanGraph:=ShallowCopy(FuncSplitEdgeInOneDigon(NewPlanGraph, [Vert3,Vert4]));
        if FuncTestHedriteness(NewPlanGraph)=true then
          ListSelectedPlanGraph[Length(ListSelectedPlanGraph)+1]:=NewPlanGraph;
	fi;
      fi;
    od;
  fi;
od;


ListInvariant:=[];
for iS in [1..Length(ListSelectedPlanGraph)]
do
  ZZ:=ZigZag(ListSelectedPlanGraph[iS]);
  ZZinfo:=ZZ[4];
  Sort(ZZinfo);
  ListInvariant[iS]:=ZZinfo;
od;





CLAS:=RemoveByIsomorphy(ListSelectedPlanGraph, ListInvariant, FuncIsomorphy);

SaveDataToFile(FileOUT, CLAS[1]);
Print("Find ", Length(CLAS[1]), " different 6-hedrites\n");

for iPlan in [1..Length(CLAS[1])]
do
  FileName:=Concatenation("./Hedrites/6-hedrite", String(VertexAsk),"-", String(iPlan));
  PlanGraphToCaGe(FileName, CLAS[1][iPlan]);
od;





#
#
#
# creating the 5-hedrites
#Print("Treating the 5-hedrites\n");
FileOUT:=Concatenation("./Hedrites/5-Hedrite",String(VertexAsk));
ListSelectedPlanGraph:=[];


# first case: the three digons don't share any vertices
FileIN:=Concatenation("./Hedrites/ListPlanGraphBis",String(VertexAsk));
ListPlanGraph:=ReadAsFunction(FileIN)();


CL:=FuncSetPairs(6);

for ePlanGraph in ListPlanGraph
do
  Val3:=[];
  for iVert in [1..Length(ePlanGraph)]
  do
    ListAdj:=ePlanGraph[iVert];
    if Length(ListAdj)<>4 then
      AddSet(Val3, iVert);
    fi;
  od;
  if Length(Val3)=6 then
    for eSol in CL
    do
      Vert1:=Val3[eSol[1][1]];
      Vert2:=Val3[eSol[1][2]];
      Vert3:=Val3[eSol[2][1]];
      Vert4:=Val3[eSol[2][2]];
      Vert5:=Val3[eSol[3][1]];
      Vert6:=Val3[eSol[3][2]];
      if Vert1 in ePlanGraph[Vert2] and Vert3 in ePlanGraph[Vert4] and Vert5 in ePlanGraph[Vert6] then
        NewPlanGraph:=ePlanGraph;
        NewPlanGraph:=FuncSplitEdgeInOneDigon(NewPlanGraph, [Vert1,Vert2]);
        NewPlanGraph:=FuncSplitEdgeInOneDigon(NewPlanGraph, [Vert3,Vert4]);
        NewPlanGraph:=FuncSplitEdgeInOneDigon(NewPlanGraph, [Vert5,Vert6]);
        if FuncTestHedriteness(NewPlanGraph)=true then
          ListSelectedPlanGraph[Length(ListSelectedPlanGraph)+1]:=NewPlanGraph;
	fi;
      fi;
    od;
  fi;
od;



#second case, two digons share a vertex while the other do not share anything
FileIN:=Concatenation("./Hedrites/ListPlanGraphBis",String(VertexAsk-1));
ListPlanGraph:=ReadAsFunction(FileIN)();


CL:=[];
for eP in FuncSetPairs(4)
do
  AddSet(CL, [eP[1],eP[2]]);
  AddSet(CL, [eP[2],eP[1]]);
od;


for ePlanGraph in ListPlanGraph
do
  Val3:=[];
  for iVert in [1..Length(ePlanGraph)]
  do
    ListAdj:=ePlanGraph[iVert];
    if Length(ListAdj)<>4 then
      AddSet(Val3, iVert);
    fi;
  od;
  if Length(Val3)=4 then
    for eSol in CL
    do
      Vert1:=Val3[eSol[1][1]];
      Vert2:=Val3[eSol[1][2]];
      Vert3:=Val3[eSol[2][1]];
      Vert4:=Val3[eSol[2][2]];
      if Vert1 in ePlanGraph[Vert2] and Vert3 in ePlanGraph[Vert4] then
        NewPlanGraph:=ePlanGraph;
        NewPlanGraph:=FuncSplitEdgeInOneDigon(NewPlanGraph, [Vert1,Vert2]);
        NewPlanGraph:=FuncSplitEdgeInTwoDigons(NewPlanGraph, [Vert3,Vert4]);
        if FuncTestHedriteness(NewPlanGraph)=true then
          ListSelectedPlanGraph[Length(ListSelectedPlanGraph)+1]:=NewPlanGraph;
	fi;
      fi;
    od;
  fi;
od;








ListInvariant:=[];
for iS in [1..Length(ListSelectedPlanGraph)]
do
  ZZ:=ZigZag(ListSelectedPlanGraph[iS]);
  ZZinfo:=ZZ[4];
  Sort(ZZinfo);
  ListInvariant[iS]:=ZZinfo;
od;

CLAS:=RemoveByIsomorphy(ListSelectedPlanGraph, ListInvariant, FuncIsomorphy);
SaveDataToFile(FileOUT, CLAS[1]);
Print("Find ", Length(CLAS[1]), " different 5-hedrites\n");

for iPlan in [1..Length(CLAS[1])]
do
  FileName:=Concatenation("./Hedrites/5-hedrite", String(VertexAsk),"-", String(iPlan));
  PlanGraphToCaGe(FileName, CLAS[1][iPlan]);
od;











#
#
#
# creating the 4-hedrites
#Print("Treating the 4-hedrites\n");
FileOUT:=Concatenation("./Hedrites/4-Hedrite",String(VertexAsk));
ListSelectedPlanGraph:=[];



#first case, all four digons share no vertices
FileIN:=Concatenation("./Hedrites/ListPlanGraphBis",String(VertexAsk));
ListPlanGraph:=ReadAsFunction(FileIN)();
CL:=FuncSetPairs(8);

for ePlanGraph in ListPlanGraph
do
  Val3:=[];
  for iVert in [1..Length(ePlanGraph)]
  do
    ListAdj:=ePlanGraph[iVert];
    if Length(ListAdj)<>4 then
      AddSet(Val3, iVert);
    fi;
  od;
  if Length(Val3)=8 then
    for eSol in CL
    do
      Vert1:=Val3[eSol[1][1]];
      Vert2:=Val3[eSol[1][2]];
      Vert3:=Val3[eSol[2][1]];
      Vert4:=Val3[eSol[2][2]];
      Vert5:=Val3[eSol[3][1]];
      Vert6:=Val3[eSol[3][2]];
      Vert7:=Val3[eSol[4][1]];
      Vert8:=Val3[eSol[4][2]];
      if Vert1 in ePlanGraph[Vert2] and Vert3 in ePlanGraph[Vert4] and Vert5 in ePlanGraph[Vert6] and Vert7 in ePlanGraph[Vert8] then
        NewPlanGraph:=ePlanGraph;
        NewPlanGraph:=FuncSplitEdgeInOneDigon(NewPlanGraph, [Vert1,Vert2]);
        NewPlanGraph:=FuncSplitEdgeInOneDigon(NewPlanGraph, [Vert3,Vert4]);
        NewPlanGraph:=FuncSplitEdgeInOneDigon(NewPlanGraph, [Vert5,Vert6]);
        NewPlanGraph:=FuncSplitEdgeInOneDigon(NewPlanGraph, [Vert7,Vert8]);
        if FuncTestHedriteness(NewPlanGraph)=true then
          ListSelectedPlanGraph[Length(ListSelectedPlanGraph)+1]:=NewPlanGraph;
	fi;
      fi;
    od;
  fi;
od;








#second case, two of the four digons share a vertex
FileIN:=Concatenation("./Hedrites/ListPlanGraphBis",String(VertexAsk-1));
ListPlanGraph:=ReadAsFunction(FileIN)();


CL:=[];
for eP in FuncSetPairs(6)
do
  AddSet(CL, [eP[1],eP[2], eP[3]]);
  AddSet(CL, [eP[2],eP[3], eP[1]]);
  AddSet(CL, [eP[3],eP[1], eP[2]]);
od;


for ePlanGraph in ListPlanGraph
do
  Val3:=[];
  for iVert in [1..Length(ePlanGraph)]
  do
    ListAdj:=ePlanGraph[iVert];
    if Length(ListAdj)<>4 then
      AddSet(Val3, iVert);
    fi;
  od;
  if Length(Val3)=6 then
    for eSol in CL
    do
      Vert1:=Val3[eSol[1][1]];
      Vert2:=Val3[eSol[1][2]];
      Vert3:=Val3[eSol[2][1]];
      Vert4:=Val3[eSol[2][2]];
      Vert5:=Val3[eSol[3][1]];
      Vert6:=Val3[eSol[3][2]];
      if Vert1 in ePlanGraph[Vert2] and Vert3 in ePlanGraph[Vert4] and Vert5 in ePlanGraph[Vert6] then
        NewPlanGraph:=ePlanGraph;
        NewPlanGraph:=FuncSplitEdgeInTwoDigons(NewPlanGraph, [Vert1,Vert2]);
        NewPlanGraph:=FuncSplitEdgeInOneDigon(NewPlanGraph, [Vert3,Vert4]);
        NewPlanGraph:=FuncSplitEdgeInOneDigon(NewPlanGraph, [Vert5,Vert6]);
        if FuncTestHedriteness(NewPlanGraph)=true then
          ListSelectedPlanGraph[Length(ListSelectedPlanGraph)+1]:=NewPlanGraph;
	fi;
      fi;
    od;
  fi;
od;







#third case, the four digons are organized in two by two
FileIN:=Concatenation("./Hedrites/ListPlanGraphBis",String(VertexAsk-2));
ListPlanGraph:=ReadAsFunction(FileIN)();


CL:=FuncSetPairs(4);

for ePlanGraph in ListPlanGraph
do
  Val3:=[];
  for iVert in [1..Length(ePlanGraph)]
  do
    ListAdj:=ePlanGraph[iVert];
    if Length(ListAdj)<>4 then
      AddSet(Val3, iVert);
    fi;
  od;
  if Length(Val3)=4 then
    for eSol in CL
    do
      Vert1:=Val3[eSol[1][1]];
      Vert2:=Val3[eSol[1][2]];
      Vert3:=Val3[eSol[2][1]];
      Vert4:=Val3[eSol[2][2]];
      if Vert1 in ePlanGraph[Vert2] and Vert3 in ePlanGraph[Vert4] then
        NewPlanGraph:=ePlanGraph;
        NewPlanGraph:=FuncSplitEdgeInTwoDigons(NewPlanGraph, [Vert1,Vert2]);
        NewPlanGraph:=FuncSplitEdgeInTwoDigons(NewPlanGraph, [Vert3,Vert4]);
        if FuncTestHedriteness(NewPlanGraph)=true then
          ListSelectedPlanGraph[Length(ListSelectedPlanGraph)+1]:=NewPlanGraph;
	fi;
      fi;
    od;
  fi;
od;








ListInvariant:=[];
for iS in [1..Length(ListSelectedPlanGraph)]
do
  ZZ:=ZigZag(ListSelectedPlanGraph[iS]);
  ZZinfo:=ZZ[4];
  Sort(ZZinfo);
  ListInvariant[iS]:=ZZinfo;
od;

CLAS:=RemoveByIsomorphy(ListSelectedPlanGraph, ListInvariant, FuncIsomorphy);
SaveDataToFile(FileOUT, CLAS[1]);
Print("Find ", Length(CLAS[1]), " different 4-hedrites\n");

for iPlan in [1..Length(CLAS[1])]
do
  FileName:=Concatenation("./Hedrites/4-hedrite", String(VertexAsk),"-", String(iPlan));
  PlanGraphToCaGe(FileName, CLAS[1][iPlan]);
od;
