nbCol:=3;

TabList:=[];
for nbV in [2..70]
do
  FileNb:=Concatenation("DataHedrites/TheNb", String(nbV));
  ListNb:=ReadAsFunction(FileNb)();
  eList:=[String(nbV)];
  res:=nbV mod 2;
  if nbV = 4 or nbV=2 or res=1 then
    Add(eList, String(ListNb[1]));
  else
    Add(eList, String(ListNb[1]+1));
  fi; 
  for eVal in ListNb{[2..5]}
  do
    Add(eList, String(eVal));
  od;
  Add(TabList, eList);
od;
HeaderPart:="n & {\\bf 4} & {\\bf 5} & {\\bf 6} & {\\bf 7} & {\\bf 8}";

FileOutput:="LatexFiles/TheTable";
RemoveFileIfExist(FileOutput);
output:=OutputTextFile(FileOutput, true);
PrintLatexFileHeader(output, TabList, nbCol, HeaderPart);
CloseStream(output);
#
FinalFileTex:="LatexFiles/TheTable.tex";
FinalFileDVI:="LatexFiles/TheTable.dvi";
FileTex:="TheTable.tex";
FileDVI:="TheTable.dvi";
RemoveFileIfExist(FinalFileTex);
RemoveFileIfExist(FinalFileDVI);
Exec("cat Header.tex ", FileOutput, " Footer.tex > ", FinalFileTex);
Exec("(cd LatexFiles && latex ", FileTex, ")");
Exec("(cd LatexFiles && dvips ", FileDVI, " -o )");
#

