TotalVal:=Union([6],[8..80]);
for nbV in [4..80]
do
  ListPlanGraph:=[];
  Print("Creating i-hedrites from Octahedrite with nbV=", nbV, "\n");
  #
  FileName:="DataHedrites/GenerateFoil3";
  for ePL in ReadAsFunction(FileName)()
  do
    if Length(ePL)=nbV then
      AddSet(ListPlanGraph, ePL);
    fi;
  od;
  Print("Foil3 part finished\n");
  #
  FileName:="DataHedrites/Generation2connected";
  for ePL in ReadAsFunction(FileName)()
  do
    if Length(ePL)=nbV then
#      VEF:=PlanGraphToVEF(ePL);
#      PV:=Pvector(VEF).Pvector;
#      Print("PV=", PV, "\n");
      AddSet(ListPlanGraph, ePL);
    fi;
  od;
  Print("2connected part finished\n");
  #
  for nbVSec in Intersection(TotalVal, [1..nbV-1])
  do
    FileName:=Concatenation("DataHedrites/GenerationFrom8hedrite",String(nbVSec));
    for ePL in ReadAsFunction(FileName)()
    do
      if Length(ePL)=nbV then
        AddSet(ListPlanGraph, ePL);
      fi;
    od;
  od;
  Print("Octahedrite part finished\n");
  #
  Class4hedrite:=[];
  Class5hedrite:=[];
  Class6hedrite:=[];
  Class7hedrite:=[];
  Print("Found ", Length(ListPlanGraph), "  planar graphs\n");
  for ePL in ListPlanGraph
  do
    VEF:=PlanGraphToVEF(ePL);
    PV:=Pvector(VEF).Pvector;
    if PV[2]=4 and PV[3]=0 then
      Add(Class4hedrite, ePL);
    fi;
    if PV[2]=3 and PV[3]=2 then
      Add(Class5hedrite, ePL);
    fi;
    if PV[2]=2 and PV[3]=4 then
      Add(Class6hedrite, ePL);
    fi;
    if PV[2]=1 and PV[3]=6 then
      Add(Class7hedrite, ePL);
    fi;
  od;
  Print("Refinery part finished\n");
  #
  FileName:=Concatenation("DataHedrites/4-Hedrite",String(nbV));
  Print("Found ", Length(Class4hedrite), "  4-hedrites\n");
  SaveDataToFile(FileName, Class4hedrite);
  #
  Print("Found ", Length(Class5hedrite), "  5-hedrites\n");
  FileName:=Concatenation("DataHedrites/5-Hedrite",String(nbV));
  SaveDataToFile(FileName, Class5hedrite);
  #
  Print("Found ", Length(Class6hedrite), "  6-hedrites\n");
  FileName:=Concatenation("DataHedrites/6-Hedrite",String(nbV));
  SaveDataToFile(FileName, Class6hedrite);
  #
  Print("Found ", Length(Class7hedrite), "  7-hedrites\n");
  FileName:=Concatenation("DataHedrites/7-Hedrite",String(nbV));
  SaveDataToFile(FileName, Class7hedrite);
  #
  Print("\n");
od;

