#TheInterval:=[10..39];
#TheInterval:=[40..80];
TheInterval:=[6..9];
MaxNbVert:=80;

for nbV in TheInterval
do
  #
  FileSave:=Concatenation("DataHedrites/GenerationFrom8hedrite",String(nbV));
  if IsExistingFile(FileSave)=false then
    FileName:=Concatenation("DataHedrites/8-Hedrite",String(nbV));
    ListPlanGraph:=ReadAsFunction(FileName)();
    Print("Creating i-hedrites from Octahedrite with nbV=", nbV, "\n");
    Print("|ListPlanGraph|=", Length(ListPlanGraph), "\n");
    #
    ListGenerated:=[];
    for iGraph in [1..Length(ListPlanGraph)]
    do
      PlanGraph:=ListPlanGraph[iGraph];
      PartialGen:=GenerateAllDigonSplitting(PlanGraph, MaxNbVert);
      Print("  |PartialGen|=", Length(PartialGen), "\n");
      Append(ListGenerated, PartialGen);
    od;
    Print("|ListGenerated|=", Length(ListGenerated), "\n");
    SaveDataToFile(FileSave, ListGenerated);
  fi;
od;
