CheckEquality:=function(List1, List2)
  local StatusList1, StatusList2, i, j, WeFound;
  StatusList1:=[];
  StatusList2:=[];
  for i in [1..Length(List1)]
  do
    StatusList1[i]:=0;
    StatusList2[i]:=0;
  od;
  for i in [1..Length(List1)]
  do
    StatusList1[i]:=1;
    WeFound:=false;
    for j in [1..Length(List2)]
    do
      if StatusList2[j]=0 then
        if IsIsomorphicPlanGraph(List1[i], List2[j])=true then
          StatusList2[j]:=1;
          WeFound:=true;
        fi;
      fi;
    od;
    if WeFound=false then
      return false;
    fi;
  od;
  return true;
end;

for nbV in [3..15]
do
  Print("Considering for nbV=", nbV, "\n");
  Print("Checking for 4-hedrites\n");
  File1:=Concatenation("DataHedrites/4-Hedrite", String(nbV));
  File2:=Concatenation("DataHedrites/GenerationFrom8hedrite4_", String(nbV));
  test:=CheckEquality(ReadAsFunction(File1)(), ReadAsFunction(File2)());
  Print("Result=", test, "\n");

  Print("Checking for 5-hedrites\n");
  File1:=Concatenation("DataHedrites/5-Hedrite", String(nbV));
  File2:=Concatenation("DataHedrites/GenerationFrom8hedrite5_", String(nbV));
  test:=CheckEquality(ReadAsFunction(File1)(), ReadAsFunction(File2)());
  Print("Result=", test, "\n");

  Print("Checking for 6-hedrites\n");
  File1:=Concatenation("DataHedrites/6-Hedrite", String(nbV));
  File2:=Concatenation("DataHedrites/GenerationFrom8hedrite6_", String(nbV));
  test:=CheckEquality(ReadAsFunction(File1)(), ReadAsFunction(File2)());
  Print("Result=", test, "\n");

  Print("Checking for 7-hedrites\n");
  File1:=Concatenation("DataHedrites/7-Hedrite", String(nbV));
  File2:=Concatenation("DataHedrites/GenerationFrom8hedrite7_", String(nbV));
  test:=CheckEquality(ReadAsFunction(File1)(), ReadAsFunction(File2)());
  Print("Result=", test, "\n");

  Print("\n");
od;