ListGraphFound:=[];
nbV:=3;
while(true)
do
  nbV:=nbV+1;
  FileName:=Concatenation("./DataHedrites/8-Hedrite",String(nbV));
  if IsExistingFile(FileName)=false or nbV > 75 then
    break;
  fi;
  LPL:=ReadAsFunction(FileName)();
  Print("Searching infos for 8-hedrite with nbV=", nbV, " nbF=", Length(ListGraphFound), "\n");
  for iGraph in [1..Length(LPL)]
  do
    PL:=LPL[iGraph];
    CCinf:=CentralCircuit(PL);
    nbCC:=Length(CCinf.ListCircuit);
    TheSumCoeff:=[0,0];
    for iCC in [1..nbCC]
    do
      TheSumCoeff:=TheSumCoeff + CCinf.MatrixIntersectionWithTypes[iCC][iCC];
    od;
    if CCinf.Tightness=true and TheSumCoeff=[0,0] then
      Add(ListGraphFound, PL);
      GrpInfo:=GroupPlan(PL);
      eSymb:=GrpInfo.SchoenfliesSymbol;
      len:=Length(PL);
      TheFileName:=Concatenation("PictureSimpleCC/SimpleCC", String(len), "_", eSymb, "_", String(iGraph));
      SaveDataToFile(TheFileName, PL);
    fi;
  od;
od;
