PL:=AntiPrism(5);
#
FileOutput:="CCap5Goldberg";
output:=OutputTextFile(FileOutput, true);;
#
for k in [1..40]
do
  for l in [0..k]
  do
    nbV:=20*(k*k+l*l);
    nU:=k*k+l*l;
    if (nU in [0..200]) and Gcd(k,l)=1 then
      Print("Treating for k=", k, "  l=", l, "  and nU=", nU, "\n");
      PlanGraph:=OctahedriteConstruction(PL, k, l);
      CC:=CentralCircuit(PlanGraph);
      nbCC:=Length(CC.ListCircuit);
      #
      AppendTo(output, "k=", k, " l=", l);
      AppendTo(output, " CC=", CC.CCvector);
      INTV:=Set(CC.ListIntVectorWithType);
      AppendTo(output, " Int=", INTV);
      AppendTo(output, "\n");
    fi;
  od;
od;


