Knot31:=[[2,2,3,3],[1,1,3,3],[2,2,1,1]];
#
FileOutput:="CCknot31Goldberg";
output:=OutputTextFile(FileOutput, true);;
#
ListProjection:=[];
List2uples:=[];
ListInvariant:=[];
#
for k in [1..40]
do
  for l in [0..k]
  do
    nbV:=20*(k*k+l*l);
    nU:=k*k+l*l;
    if (nU in [0..200]) and Gcd(k,l)=1 then
      Print("Treating for k=", k, "  l=", l, "  and nU=", nU, "\n");
      PlanGraph:=OctahedriteConstruction(Knot31, k, l);
      CC:=CentralCircuit(PlanGraph);
      nbCC:=Length(CC.ListCircuit);
      if nbCC = 3 and CC.MatrixIntersection[1][1]>0 then
        PlanProjection:=CentralCircuitDeletionHedrite(PlanGraph, CC, [1..nbCC-1]);
        Add(ListProjection, PlanProjection);
        Add(List2uples, [k, l]);
        Add(ListInvariant, 0);
      fi;
      #
      AppendTo(output, "k=", k, " l=", l);
      AppendTo(output, " CC=", CC.CCvector);
      INTV:=Set(CC.ListIntVectorWithType);
      AppendTo(output, " Int=", INTV);
      AppendTo(output, "\n");
    fi;
  od;
od;

Print("Doing the extraction By isomorphy\n");
PP:=RemoveByIsomorphy(ListProjection, ListInvariant, IsIsomorphicPlanGraph);

for u in [1..Length(PP.ListSample)]
do
  ListPairs:=[];
  StringAppend:="";
  for eElt in PP.IsomorphyClass[u]
  do
    Add(ListPairs, List2uples[eElt]);
    ks:=List2uples[eElt][1];
    ls:=List2uples[eElt][2];
    StringAppend:=Concatenation(StringAppend, "_", String(ks),":",String(ls));
  od;
  FileSave:=Concatenation("CCprojection31_", StringAppend);
  PlanGraphToCaGe(FileSave, ListProjection[PP.ListSample[u]]);
od;
