ListSymmetry4hedrites:=["D4h", "D4", "D2h", "D2d", "D2"];
ListSymmetry5hedrites:=["C1", "C2", "Cs", "C2v", "D3", "D3h"];
ListSymmetry6hedrites:=["D2d", "D2h", "D2", "C2h", "C2v", "Ci", "C2", "Cs", "C1"];
ListSymmetry7hedrites:=["C2v", "C2", "Cs", "C1"];
ListSymmetry8hedrites:=["C1", "Cs", "C2", "C2v", "Ci", "C2h", "S4", "D2", "D2d", "D2h", "D3", "D3d", "D3h", "D4", "D4d", "D4h", "O", "Oh"];

ListP:=[4,5,6,7,8];
ListSymmetryTotal:=[
   ListSymmetry4hedrites, 
   ListSymmetry5hedrites, 
   ListSymmetry6hedrites, 
   ListSymmetry7hedrites, 
   ListSymmetry8hedrites];

ListNbSym:=List(ListSymmetryTotal, Length);
ListListStatus:=[];
ListListRepresentative:=[];
ListNbDone:=[];
ListInfos:=[];
for nbSym in ListNbSym
do
  Add(ListListStatus, ListWithIdenticalEntries(nbSym,0));
  Add(ListListRepresentative, []);
  Add(ListNbDone, 0);
  Add(ListInfos, []);
od;

IsReducedGraphSimple:=function(PL, GRPperm)
  local nbV, WeightMat, O, iO, jO, iVert, jVert, nbO, FindPos;
  nbV:=Length(PL);
  O:=Orbits(GRPperm, [1..nbV], OnPoints);
  nbO:=Length(O);
  WeightMat:=NullMat(nbO, nbO);
  FindPos:=function(iVert)
    local iO;
    for iO in [1..nbO]
    do
      if Position(O[iO], iVert)<>fail then
        return iO;
      fi;
    od;
  end;
  for iVert in [1..nbV]
  do
    iO:=FindPos(iVert);
    for jVert in PL[iVert]
    do
      jO:=FindPos(jVert);
      WeightMat[iO][jO]:=WeightMat[iO][jO]+1;
    od;
  od;
  for iO in [1..nbO]
  do
    if WeightMat[iO][iO]>0 then
      Print("Kill 1\n");
      return false;
    fi;
  od;
  for iO in [1..nbO-1]
  do
    for jO in [iO+1..nbO]
    do
      if WeightMat[iO][jO]>Order(GRPperm) then
        return false;
      fi;
    od;
  od;
  return true;
end;
#PL:=ArchimedeanPolyhedra("Octahedron");
#PL2:=OctahedriteConstruction(PL, 4, 0);GrpInfo:=GroupPlan(PL2); 
#eInv:=GrpInfo.TotalGroup.Inversion;
#GRPanti:=Group([eInv]); 
#test:=IsReducedGraphSimple(PL2, GRPanti);
#Print(NullMat(5));

nbV:=3;
while(true)
do
  nbV:=nbV+1;
  IsAllDone:=true;
#  for iHed in [4..8]
  for iHed in [8]
  do
    iHedPos:=iHed-3;
    FileName:=Concatenation("./DataHedrites/", String(iHed), "-Hedrite",String(nbV));
    if IsExistingFile(FileName)=false then
      break;
    fi;
    ListPlanGraph:=ReadAsFunction(FileName)();
    Print("Searching infos for ", iHed, "-hedrite with nbV=", nbV, 
        " nbDone=", ListNbDone[iHedPos], "\n");
    #
    for iGraph in [1..Length(ListPlanGraph)]
    do
      PlanGraph:=ListPlanGraph[iGraph];
      GrpInfo:=GroupPlan(PlanGraph);
      eSymb:=GrpInfo.SchoenfliesSymbol;
      pos:=Position(ListSymmetryTotal[iHedPos], eSymb);
      eInv:=GrpInfo.TotalGroup.Inversion;
      if eInv<>false then
#        Print(" eInv=", eInv, "\n");
        GrpAnti:=Group([eInv]);
        test:=IsReducedGraphSimple(PlanGraph, GrpAnti);
        if test=true then
          FileAnti:=Concatenation("PLanti", String(iHed), "_", String(nbV), "_", String(iGraph));
          PlanGraphToCaGe(FileAnti, PlanGraph);
          Print("Find one at FileAnti=", FileAnti, " G=", GrpInfo.SchoenfliesSymbol, "\n");
        fi;
      fi;
      if ListListStatus[iHedPos][pos]=0 then
        TheFileName:=Concatenation("PictureMinimalSymCand/Minimal", String(iHed), "_", String(nbV), "_", eSymb);
        TheFileNameCaGe:=Concatenation("PictureMinimalSymCand/Minimal", String(iHed), "_", String(nbV), "_", eSymb, ".cage");
        SaveDataToFile(TheFileName, PlanGraph);
        PlanGraphToCaGe(TheFileNameCaGe, PlanGraph);
        ListListStatus[iHedPos][pos]:=1;
        ListNbDone[iHedPos]:=ListNbDone[iHedPos]+1;
        CJ:=ConjugacyClassesSubgroups(GrpInfo.SymmetryGroup);
        ListCand:=[];
        for eCJ in CJ
        do
          eRepr:=Representative(eCJ);
          if 2*Order(eRepr)=Order(GrpInfo.SymmetryGroup) then
            eSubInfo:=GrpInfo.FunctionSymmetry(eRepr);
            Add(ListCand, eSubInfo.SchoenfliesSymbol);
          fi;
        od;
        TheRec:=rec(PL:=PlanGraph, ListSub2:=ListCand);
        ListListRepresentative[iHedPos][pos]:=TheRec;
        Add(ListInfos[iHedPos], rec(PL:=PlanGraph, GRP:=eSymb));
      fi;
    od;
    if ListNbDone[iHedPos] < ListNbSym[iHedPos] then
      IsAllDone:=false;
    fi;
  od;
  if IsAllDone=true then
    break;
  fi;
od;
for iHed in [4..8]
do
  iHedPos:=iHed-3;
  nbSym:=ListNbSym[iHedPos];
  ListCompleteSym:=[];
  for iSym in [1..nbSym]
  do
    eSymb:=ListSymmetryTotal[iHedPos][iSym];
    Print("iHed=", iHed, " iSym=", iSym, " G=", eSymb, " ListSub=", ListListRepresentative[iHedPos][iSym].ListSub2, "\n");
    ListCompleteSym:=Union(ListCompleteSym, Set(ListListRepresentative[iHedPos][iSym].ListSub2));
  od;
  Print("iHed=", iHed, "  ListCompleteSym=", ListCompleteSym, "\n");
od;
SaveDataToFile("INFOS_SymmetryHedrites", ListInfos);
