    Authors: Renata B. Filler, Scott J. Roberts and Michael Girardi

Corresponding author ([michael.girardi@yale.edu](michael.girardi@yale.edu))


### INTRODUCTION

The induction of cutaneous carcinogenesis in mice by topical administration of chemicals enables the local, systemic, and environmental factors that influence tumor susceptibility, growth, and progression to be studied in the laboratory. Chemical carcinogenesis in mouse skin has been used for several decades, and continues to help in the identification of important molecular and immunological pathways involved in cutaneous malignancy. This protocol describes the two-stage application of chemicals to the skin for the initiation and promotion of cutaneous tumors. In the two-stage model of induction, a single application of the chemical initiator mutagen 7,12-dimethylbenz[a]anthracene (DMBA) is followed by repeated applications of a pro-inflammatory phorbol ester 12-O-tetradecanoylphorbol 13-acetate (TPA; otherwise known as phorbol 12-myristate 13-acetate [PMA]). Resulting tumors may develop in the form of benign papillomas that regress or progress to SCC, or SCC may arise without an apparent precursor lesion. Thus, two-stage chemical carcinogenesis provides an opportunity to monitor early and late events in cancer development and progression.

### RELATED INFORMATION

The two-stage chemical carcinogenesis protocol includes an initiating application of DMBA which induces an irreversible and specific mutation in mouse skin: an A-to-T transversion in codon 61 (second nucleotide) of the oncogene Ha-ras (Fujiki et al. 1989). This application is followed by multiple, regular applications of the phorbol ester TPA. The initiation is typically given at a dose that is not sufficient to induce tumors, thus necessitating application of the TPA. For each experiment, it may be useful to titrate the doses of the initiator and promoter that best induce tumors in an acceptable range. Several examples of different regimens are given in Table 1.

Several parameters should be considered when utilizing the two-stage protocol with regard to the dose of initiator and promoter:

- Mouse strain susceptibility. For example, the FVB/n strain is particularly susceptible to two-stage chemical carcinogenesis, while the C57BL/6 strain is relatively resistant to tumor formation (Hennings et al. 1993; Elmets et al. 1998; Woodworth et al. 2004). For more information on strain susceptibility, see French et al. (1994), Daniel et al. (2003), Girardi et al. (2003), and Murphy et al. (2003).
- The presence of a genetic mutation (Girardi et al. 2001, 2003; Daniel et al. 2003) or transgene (French et al. 1994; Daniel et al. 2003; Murphy et al. 2003). Mice genetically engineered to target tumor suppressor genes, oncogenes, and/or immunologic activities may exhibit altered susceptibility to tumor formation.
- Appropriate initiation and promotion doses. Varying the doses of the initiator or promotor chemicals may enhance or inhibit various components/effects of the protocol (e.g., susceptibility to papilloma formation and progression to carcinoma) (Hennings et al. 1993; Girardi et al. 2003).

### MATERIALS

**Reagents**

1. 12-O-tetradecanoylphorbol 13-acetate (TPA, also commonly known as phorbol 12-myristate 13-acetate [PMA])
  - *For utilization as a topical tumor promoter, TPA may be dissolved in either ethanol (Girardi et al. 2001; Girardi et al. 2003; [http://www.sigmaaldrich.com/catalog/search/ProductDetail/SIGMA/P8139](http://www.sigmaaldrich.com/catalog/search/ProductDetail/SIGMA/P8139)) or acetone (Hennings et al. 1993; Woodworth et al. 2004; Ridd et al. 2006). We dissolve TPA in benzene-free, 100% ethanol (American Bioanalytical, AB00515) at 25 mg per 100 mL (for a 0.025%, w/v solution). This is equivalent to 40 nmol per 100-μL application. For the regimens listed in Table 1, dilute the 0.025% (w/v) TPA solution with ethanol to yield the appropriate concentration. Protect the 0.025% TPA stock solution from light, and store it at −20°C for up to 6 mo*.
- 7,12-Dimethylbenz[a]anthracene (DMBA) (Sigma-Aldrich)
  - *Dissolve DMBA in acetone at 100 mg per 100 mL (0.1%, w/v). This is equivalent to 400 nmol per 100-μL application. For the lower-dosage regimens listed in Table 1, dilute the 0.1% DMBA solution in acetone to yield the appropriate concentration. The 0.1% DMBA stock solution should be made fresh prior to each experiment, or stored at −20°C*.
- Eosin
- Formalin
- Hematoxylin
- Mice, 6- or 7-wk-old female
  - *We highly recommend using age-matched females for the experiments. Male mice may fight, causing damage to the dorsal skin. If experimental (e.g., genetically engineered) and control (e.g., wild-type) mice receive identical chemical applications, we advise mixing the groups throughout cages. Density of animals in cages should be determined according to institutional animal care guidelines*.

### Equipment

1. Calipers or other measuring device (e.g., Vernier calipers [Scienceware Bel-Art Products, Inc.], digital calipers [Mitutoyo Corp.], dermatologist ruler, or combo circle template [Staedtler, STD977101]
- Fine electric shaver (e.g., Braun 3612 or Braun 3615 InterFace)
- Handheld electric hair clippers or trimmer (e.g., Oster A5 [Oster Professional Products] or Panasonic ER121H)
- Microscope
- Microtome
- Paraffin-embedding equipment

### METHODS

**Hair Removal**

*Hair removal is typically performed at 6-7 wk of age (the beginning of the second resting hair growth cycle)*.

1. Remove a patch of dorsal hair from each mouse using an electric hair clipper.
- Remove any residual stubble with a fine electric shaver.

**Two-Stage Chemical Carcinogenesis**

Table 1. Examples of two-step carcinogenesis regimens

![Table 1](https://i.imgur.com/JVXplw5.png "Table 1")

3.One week after hair removal (7-8 wk of age, the resting hair growth phase), apply 100 μL of DMBA to the shaved area (Borum 1954; Andreasen and Borum 1956; Miller et al. 1993).

4.After 1 wk, begin 100-μL applications of TPA to the DMBA-initiated area. Apply TPA twice weekly, 3-4 d apart.

*More or less frequent applications will reduce tumor numbers*.

**Clinical Monitoring of Tumors**

*Tumors should be evaluated by visual inspection by an observer, ideally a dermatologist, blinded to the experimental group*.

5.Evaluate mice for tumors weekly. Count palpable tumors that attain a diameter of 1 mm or greater and that are present for 2 wk or longer.

6.To follow the progression of papillomas to carcinomas, make a chart of the affected area, map the tumor(s), and note any changes. Count, measure, and score the tumors as:

- clinically apparent papillomas (typically exophytic, i.e., extending outward from the skin; well-demarcated, symmetrical, pedunculated, or dome-shaped papules, without erosion or ulceration), or
- clinically apparent carcinomas (typically endophytic, i.e., growing downward; poorly demarcated, asymmetrical, non-pedunculated, or doughnut-shaped papules or nodules with erosion or ulceration).

**Histological Analysis of Tumors**

*To assess the validity of the clinical scoring system, multiple tumors from each type (papilloma and carcinoma) and size category (e.g., 1 mm2, 4 mm2, 9 mm2, and 16 mm2) should be submitted for histological analysis by a dermatopathologist blinded to the clinical score*.

7.Excise the tumors and fix them in formalin.

8.Embed the tissue in paraffin, and cut it into 5-μm sections.

9.Stain the sections with hematoxylin and eosin, and examine tumor histology using a microscope.
 
### REFERENCES

1. Andreasen E., Borum K. (1956) [The influence of the mouse hair cycle on 9, 10-dimethyl-1, 2-benzanthracene-induced skin tumors](http://cshprotocols.cshlp.org/external-ref?access_num=13372267&link_type=MED). *Acta Pathol. Microbiol. Scand. Suppl.* 39((Suppl 111)) 76–77.
- Borum K. (1954) [The role of the mouse hair cycle in epidermal carcinogenesis](http://cshprotocols.cshlp.org/external-ref?access_num=13206756&link_type=MED). *Acta Pathol. Microbiol. Scand*. 34:542–553.
- Daniel D., Meyer-Morse N., Bergsland E.K., Dehne K., Coussens L.M., Hanahan D. (2003) [Immune enhancement of skin carcinogenesis by CD4+ T cells.](http://cshprotocols.cshlp.org/cgi/ijlink?linkType=ABST&journalCode=jem&resid=197/8/1017) *J. Exp. Med*. 197:1017–1028.
- Elmets C.A., Athar M., Tubesing K.A., Rothaupt D., Xu H., Mukhtar H. (1998) [Susceptibility to the biological effects of polyaromatic hydrocarbons is influenced by genes of the major histocompatibility complex.](http://cshprotocols.cshlp.org/cgi/ijlink?linkType=ABST&journalCode=pnas&resid=95/25/14915) *Proc. Natl. Acad. Sci*. 95:14915–14919.
- French J.E., Libbus B.L., Hansen L., Spalding J., Tice R.R., Mahler J., Tennant R.W. (1994) [Cytogenetic analysis of malignant skin tumors induced in chemically treated TG-AC transgenic mice.](http://cshprotocols.cshlp.org/external-ref?access_num=7999263&link_type=MED) *Mol. Carcinog*. 11:215–226.
- Fujiki H., Suganuma M., Yoshizawa S., Kanazawa H., Sugimura T., Manam S., Kahn S.M., Jiang W., Hoshina S., Weinstein I.B. (1989) [Codon 61 mutations in the c-Harvey-ras gene in mouse skin tumors induced by 7,12-dimethylbenz[a]anthracene plus okadaic acid class tumor promoters.](http://cshprotocols.cshlp.org/external-ref?access_num=10.1002/mc.2940020403&link_type=DOI) *Mol. Carcinog*. 2:184–187.
- Girardi M., Oppenheim D.E., Steele C.R., Lewis J.M., Glusac E., Filler R., Hobby P., Sutton B., Tigelaar R.E., Hayday A.C. (2001) [Regulation of cutaneous malignancy by γδ T cells.](http://cshprotocols.cshlp.org/cgi/ijlink?linkType=ABST&journalCode=sci&resid=294/5542/605) *Science* 294:605–609.
- Girardi M., Glusac E., Filler R.B., Roberts S.J., Propperova I., Lewis J., Tigelaar R.E., Hayday A.C. (2003) [The distinct contributions of murine T cell receptor (TCR) γδ+ and TCRαβ+ T cells to different stages of chemically induced skin cancer.](http://cshprotocols.cshlp.org/cgi/ijlink?linkType=ABST&journalCode=jem&resid=198/5/747) *J. Exp. Med*. 198:747–55.
- Hennings H., Glick A.B., Lowry D.T., Krsmanovic L.S., Sly L.M., Yuspa S.H. (1993) [FVB/N mice: An inbred strain sensitive to the chemical induction of squamous cell carcinomas in the skin.](http://cshprotocols.cshlp.org/cgi/ijlink?linkType=ABST&journalCode=carcin&resid=14/11/2353) *Carcinogenesis* 14:2353–2358.
- Miller S.J., Wei Z.G., Wilson C., Dzubow L., Sun T.T., Lavker R.M. (1993) [Mouse skin is particularly susceptible to tumor initiation during early anagen of the hair cycle: Possible involvement of hair follicle stem cells.](http://cshprotocols.cshlp.org/external-ref?access_num=10.1111/1523-1747.ep12366045&link_type=DOI) *J. Invest. Dermatol*. 101:591–594.
- Murphy J.E., Morales R.E., Scott J., Kupper T.S. (2003) [IL-1α, innate immunity, and skin carcinogenesis: The effect of constitutive expression of IL-1α in epidermis on chemical carcinogenesis.](http://cshprotocols.cshlp.org/cgi/ijlink?linkType=ABST&journalCode=jimmunol&resid=170/11/5697) *J. Immunol*. 170:5697–5703.
- Ridd K., Zhang S.D., Edwards R.E., Davies R., Greaves P., Wolfreys A., Smith A.G., Gant T.W. (2006) [Association of gene expression with sequential proliferation, differentiation and tumor formation in murine skin.](http://cshprotocols.cshlp.org/cgi/ijlink?linkType=ABST&journalCode=carcin&resid=27/8/1556) *Carcinogenesis* 27:1556–1566.
- Woodworth C.D., Michael E., Smith L., Vijayachandra K., Glick A., Hennings H., Yuspa S.H. (2004) [Strain-dependent differences in malignant conversion of mouse skin tumors is an inherent property of the epidermal keratinocyte.](http://cshprotocols.cshlp.org/cgi/ijlink?linkType=ABST&journalCode=carcin&resid=25/9/1771) *Carcinogenesis* 25:1771–1778.

