    Author: Michael P. Czech

This assay is used to measure free fatty acid release from fat cells as an
estimate of lipolysis. Glycerol release can also be measured from the same
samples by taking an aliquot of medium from below the fat cell layer and
assaying for glycerol in the medium.

*Note: This protocol contains dangerous chemicals that can cause burns to exposed skin and should not be inhaled; take all precautions to prevent burns by wearing a lab coat, extra gloves, and eye/face protection. Make sure to use the fume hood properly. Keep away from open flames;
some of the chemicals are highly flammable.*

### Free Fatty Acid Release Assay.

1. Resuspend 1.0 g fat in 1.5ml-2mls KRH+2.5%BSA. (Optional: Let the cells rest
for 20min in KRH buffer with BSA and pyruvate before adding them to the tubes listed below. )
- Label 15ml snap-cap polypropylene tubes. Add 0.9ml of KRH +2.5% BSA pH 7.4 to
each tube. Add the other reagents as desired to the appropriate tubes, for example:
  - Tubes 1,2,3 (no glucose, no insulin, no theophylline)–5ul of PBS + 10ul of
3mM HCl + 5ul of 100% ethanol
  - Tubes 4,5,6 (no glucose, no insulin, + theophylline) –5ul of PBS + 10ul of
3mM HCl + 5ul of 40mM theophylline in ethanol
  - Tubes 7,8,9 (No glucose +insulin + theophylline) -5ul of PBS +10ul of 100mM insulin in 3mM HCl+ 5ul of 40mM theophylline
  - Tubes 10,11,12 (5mM glucose) - 5ul of 25mM glucose + 10ul of 3mM HCl + 5ul of 100% ethanol
  - Tubes 13,14,15 (5mM glucose +theophylline)- 5ul of 25mM glucose + 10ul of
3mM HCl + 5ul of 40mM theophylline
  - Tubes 16,17,18 (5mM glucose +insulin + theophylline) -5ul of 25mM glucose +10ul of 100mM insulin + 5ul of 40mM theophylline
- Add 0.1ml of cells to all of the tubes, which contain the 0.9ml suspension of KRH+insulin or control solutions.
- Incubate the cells at 37oC with shaking for 60 minutes to stimulate the cells.
- Remove 100ul of buffer from the bottom of the tubes after letting the tubes settle for 5 min. and place in an eppendorf tube and freeze for later studies.
- Prepare 3 blanks for titration later by adding 1ml of water to the 3 x 15ml snap-cap polypropylene tubes, label 3 other standard tubes and set them aside until later. Prepare the standards by making a 50mg/L stock of palmitic acid in hexane.
- At this point everything should be done in a fume hood. After 60 minutes add 5ml of Doles Extraction mixture to every tube (including the blanks and the standards), cap and shake the tubes, then let them stand for 15 min. Work with 6 tubes at one time to avoid evaporation.
- Add 3ml H2O and 3ml Hexane, to the sample tubes and blanks and allow the phases to separate. Add 3ml of palmitic acid solution in hexane (inste
ad of the 3ml of hexane alone) to the tubes for the standards. Add the water and hexane to 6 tubes, one at a time only and cap them immediately (hexane evaporates very quickly).
- Remove the lower phase by aspirating and wash the upper phase by adding
3ml of water and allowing the phases to separate. The lower solution contains water and can be poured down the sink.
- Take 1ml of upper hexane phase and put in 15ml glass vials. For one of the tubes remove the rest of the hexane phase to give a total volume for the hexane phase to be used in calculations later.
- Titrate the blanks and the standards of palmitic acid made previously at by bubbling air devoid of carbon dioxide through the samples, this is achieved by forcing air through a basic solution of 5N NaoH. Add 0.001N NaOH to the point of neutrality (blue to slightly pink) and record the volume of base it took to achieve neutrality. Repeat this procedure with the samples.

**Modified Doles Extraction Mixture as per Fain (100mls) 5mls/tube**

  - 80mls isopropyl alcohol
  - 20mls hexane
  - 2mls 1 N H2SO4 (0.5M H2SO4)

**Saturated Potassium Hydroxide**

  - Add potassium hydroxide pellets to a 1-liter plastic beaker with approx. 500mls of water.
  - Dissolve by stirring with a stir bar. Add more potassium hydro
xide until the pellets no longer dissolve in the water. Pour the potassium hydroxide solution into a fresh bottle
and let it cool.

**Ethanolic KOH**

- Add 20mls of 95% EtOH to a glass jar, add 1ml of saturated potassium hydroxide to it
- jar, mix well. 

**Nile Blue A Indicator Stock**

- Mix powder with ethanol for a concentrated solution. Approximate concentration is 1mg/ml.

**Theophylline**

- Make a 40mM stock of theophylline in 100% ethanol.