    Authors: Ayushi Kamthan, Mohan Kamthan, Niranjan Chakraborty, Subhra Chakraborty & Asis Datta


### Abstract

Gas chromatography- mass spectrometry (GC-MS) is a highly used and well established technological platform for metabolite profiling in both plant and non-plant species. Here we describe a simple protocol for lipophilic compounds extraction and analysis from tomato fruits and leaves which is an important crop in terms of its economic and nutritional value. This is a rapid, reliable and reproducible method to detect and quantify lipophilic metabolites including fatty acids, fatty alcohols, sterols, alkanes, alkenes, and triterpenoids by GC-MS. In addition, this is a simple and convenient method for efficient comparative lipid profiling of wild type and transgenic or mutant tomato fruits.

### Introduction

Metabolomics is one of the most rapidly advancing analytical approaches that aim at the comprehensive analysis of a large numbers of metabolites. It is most extensively utilized method in the field of plant sciences, since plants possess the unique feature of synthesizing a large number of natural products that do not exist in any other life form. Gas chromatography–mass spectrometry (GC–MS) is one of the most important and robust tools of metabolomics (1). This technology has high separation efficiency that can not only resolve complex volatile mixtures (alcohols, aldehydes, ketones, terpenes etc.) but also non-volatile metabolites through the chemical derivatization. Common derivatization procedures include trimethylsilylation and the reaction with diazomethane (2, 3, 4). It can be applied for global biochemical profiling for better understanding of metabolic events in biological systems (5, 6, 7).
Tomato is a highly interesting system to study maturation and ripening processes because of the dramatic metabolic changes that occur during development. These metabolic events have been studied in detail in the past (8, 9). Tomato fruit at different developmental stages can be distinguished on the basis of their metabolic complement (10). GC-MS has been used to characterize tomato pericarp composition in transgenic plants (11), to assess metabolic diversity of tomato species (12) and to measure metabolic changes associated with tomato fruit development (10) and to characterize biochemical changes during the development, ripening and post-harvest shelf-life of tomato fruit, covering both the pre- and post-harvest phases (13).Cuticular wax composition of wild type and lecer6 mutant tomato was also compared using this approach (14). We describe herein a detailed protocol for extraction, derivatization, identification and quantification of lipohilic metabolites from leaves and fruit tissue of tomato.
 

### Reagents

1. Chloroform (CHCl3)
- CHCl3: Methanol (1:2)
- 6% methanolic KOH (w/v)
- n-heptance
- BFSTA (N,O-bis(trimethylsilyl)trifluoroacetamide silylation reagent. It reacts with a range of polar organic compounds,replacing active hydrogens with a –Si(CH3)3 (trimethylsilyl) group.
- TMCS (trimethylchlorosilane). It is a silylation catalyst that increases the reactivity of other silylation reagents.

### Equipment

1. Freeze dryer suitable for lyophilisation
- Freezer (-80 °C) for sample storage
- Vortexer
- Silanol free glass vials
- GC-MS instrument
- Rtx5MS- 30m column ( 0.25-mm ID and 0.25µmdf)

### Procedure

**Harvesting of plant tissue (leaves or fruits)**

1. Harvest the tissue (500mg-1.0g) from plant under the desired experimental condition.
- Immediately freeze the tissue by immersing in liquid nitrogen.
- Frozen tissues can be freeze dried. Lyophilized tissue can be stored at -80°C for several weeks or processed immediately.

**Organic extraction**

1. Transfer a known amount of lyophilized tissue, typically 300-500mg in a glass vial with cap.
- Add 10µl of internal standard 5α -cholest 7en-3β-ol (1mg/ml stock) to the vial.
- Add 3.75ml of CHCl3: methanol (1:2) and vortex vigorously.
- Add 1.25 ml of CHCl3 and vortex well.
- Add 1.25 ml of dH2O and vortex once again.
- Transfer bottom organic phase to a fresh vial with the help of a pipette. The solvent should be allowed to evaporate completely at 35⁰C.
  - **Critical step**: Weighing of the tissue should be done immediately to avoid thawing.

**Alkaline hydrolysis**

1. Add 500 µl of 6% methanolic KOH (w/v) to the dried residue and incubate at 85⁰C for ½ -1 hrs.
- To it, add half the volume i.e. 250 µl of dH2O and then equal volume i.e. 750 µl of n-heptane and vortex well.
- Allow it to stand for sometimes till the layers get separated. Transfer upper phase to a fresh vial. Repeat the above step twice.
- Allow heptane to evaporate completely (16- 24hrs).

**Derivatization**

To the dried residue, add 100 µl of derivatization reagent (80 µl BFSTA+20 µl TMCS) and incubate at 65⁰C for 1 hrs and inject in to GC-MS.
**Critical step**: The most critical point is to avoid any water or moisture during derivatization especially the silylating step is highly vulnerable.

**GC-MS analysis**

For GC-MS analysis 1µl of the sample is injected in split mode in the instrument. Use a Rtx5MS- 30m column with 0.25-mm ID and 0.25µm df. Following are the parameters standardized for GC-MS run:

- Injection temperature: 300°C,
- Interface temperature: 300°C,
- Ion source should be adjusted to 250°C.
- Carrier gas: Helium (flow rate of 1 ml min-1).
- Perform the analysis using the following temperature program:
1 min. of isothermal heating at 100⁰C followed by heating at 300⁰C for 20 mins.
- Mass spectra were recorded at 2 scan sec-1 with a scanning range of 40 to 850 m/z. Quantify each component based on peak areas and normalization based on the internal standard.

### Timing 

The protocol consists of two phases: First is sample extraction and second is GC-MS analysis. Extraction procedure from lyophilized tissues takes a day and few hours (2-21/2 hrs per sample) are required for GC-MS run.

### Troubleshooting
 
Troubleshooting advice can be found in Table1.

### Anticipated Results
 
The GC-MS spectra of extracts (from tomato fruit and leave tissue) isolated from this protocol show peaks of lipohilic metabolites including fatty acids, fatty alcohols, alkanes, alkenes, sterols, tocopherols and triterpenoids. The spectra are frequently dominated by signals from fatty acids and alkanes. The major metabolites detected and quantified by this protocol are listed in Table 2. 

### References

1. Fernie, A.R., Trthewey, R.N., Krotzky, A.J.& Willmitzer, L. Metabolite profiling: from diagnostics to systems biology. *Nature Rev* 5, 1-7(2004).
- Halket, J.M. et al. Chemical derivatization and mass spectral libraries in metabolic profiling by GC/MS and LC/MS/MS. *J. Exp. Bot*. 56, 219-243(2005).
- Seger, C. & Sturm, S. Analytical aspects of plant metabolite profiling platforms: Current standings and future aims. *J Proteome Res* 6, 480-497(2007).
- Dettmer, K., Aronov, P.A. & Hammock, B.D. Mass-spectrometry based metabolomics. *MassSpectrom Rev* 26, 51-78 (2007).
- Fiehn, O., Kopka, J., Trethewey, R.N. & Willmitzer, L. Identification of uncommon plant metabolites based on calculation of elemental compositions using gas chromatography and quadrupole mass spectrometry. *Anal. Chem*.72, 3575–3580 (2000).
- Roessner, U. et al. Simultaneous analysis of metabolites in potato tuber by gas chromatography-massspectrometry. *Plant J*. 23, 131–142 (2000).
- Weckwerth, W., Tolstikov, V. & Fiehn, O. Metabolomic characterization of transgenic potato plants using GC/TOF and LC/MS. In: *Proceedings of the 49th ASMS conference on Mass spectrometry and Allied Topics*, 1–2 (2001).
- C, Boggio. et al. Changes in the amino acid composition and nitrogen metabolizing enzymes in ripening fruit of Lycopersicon esculentum. *Mill. Plant Sci*. 159, 125-133(2000).
- Chen, G.P., Wilson, I.D., Kim, S.H. & Grierson, D. Inhibiting expression of a tomato ripening associated membrane protein increases organic acids and reduces sugar levels of fruit. *Planta* 212, 799–807(2001).
- Carrari, F. & Fernie, A. Metabolic regulation underlying tomato fruit development. *J. Exp. Bot*. 57, 1883-1897 (2006).
- Roessner-Tunali, U. et al. Metabolic proofing of transgenic tomato plants overexpressing hexokinase reveals that the influence of hexose phosphorylation diminishes during fruit development. *Plant Physiol*. 133, 84-99 (2003).
- Schauer, N., Zamir, D. & Fernie, A.R. Metabolic profiling of leaves and fruit of wild species tomato: a survey of the Solanum lycopersicum complex. *J. Exp. Bot*. 56, 297-307(2005).
- Oms-Oliub, G et al. Metabolic characterization of tomato fruit during preharvest development, ripening, and postharvest shelf-life. *Post harvest boil and technol*.62, 7-16 (2011).
- Vogg, G. et al. Tomato fruit cuticular waxes and their effects on transpiration barrier properties: functional characterization of a mutant deficient in a very-long-chain fatty acid β-ketoacyl-CoA synthase. *J. Exp. Bot*.55,1401-1410 (2004).

### Figures
 

**Table1: Troubleshooting**

[Download Table1](http://www.nature.com/protocolexchange/system/uploads/2341/original/Table1.doc?1353592432)


**Table 2: Major lipophilic metabolites detected by GC-MS**

[Download Table 2](http://www.nature.com/protocolexchange/system/uploads/2342/original/Table2.doc?1353592510)

### Associated Publications
 
**Expression of a fungal sterol desaturase improves tomato drought tolerance, pathogen resistance and nutritional quality**. Ayushi Kamthan, Mohan Kamthan, Mohammad Azam, Niranjan Chakraborty, Subhra Chakraborty, and Asis Datta. *Scientific Reports*  2() 10/12/2012 [doi:10.1038/srep00951](http://dx.doi.org/10.1038/srep00951)

### Author information
 
**Ayushi Kamthan, Mohan Kamthan, Niranjan Chakraborty, Subhra Chakraborty & Asis Datta**, National Institute of Plant Genome Research, New Delhi, India 

 Correspondence to: Asis Datta (asis_datta@rediffmail.com)



*Source: [Protocol Exchange](http://www.nature.com/protocolexchange/protocols/2524#/figures) (2012) doi:10.1038/protex.2012.061. Originally published online 13 December 2012*. 