# Contributing to the o-factor (open science factor) project

This is a project started at [Neurohackademy in August 2018](http://neurohackademy.org/neurohack_year/2018/), but we welcome contributions from anyone who cares about open science.

In order to contribute, you'll need a GitHub account (freely available; [here are instructions for how to sign up](https://help.github.com/articles/signing-up-for-a-new-github-account/)).

## Share your thoughts
GitHub **issues** are a way for us to communicate across all project members. Issues can be questions, bugs, requests, suggestions - even just fixing typos! We will use labels (described below) to help us sort out our issues.

Here's [Github's guide to using issues collaboratively](https://guides.github.com/features/issues/).

### Labels

* **question** These issues are questions about the project. If you want to weigh in you can
	* react to the post with an emoji
	* write a comment

* **no-code** These issues don't require any coding knowledge. There are a great place to start if you're looking to contribute without writing code.

	Many of the issues with this label are suggesting documentation tasks. Markdown is an easy way to format text for documents (and what we've used for these guidelines; [here's a nice Markdown cheatsheet](https://github.com/adam-p/markdown-here/wiki/Markdown-Cheatsheet#links)).

* **help wanted** These are issues in which a team member has asked for extra help.

	If you have relevant expertise, consider helping!

* **bug** These issues point to problems in the project.

	If you find a bug, please give as much detail as possible in the issue.

	If you experience the same bug as one already listed as an issue, please add any additional information you may have as a comment (instead of opening a new, duplicate issue).

* **enhancement** These are issues asking for features (or anything else) to be added to the project.

	If you have a good idea and would like to see it added, please open a new issue and add as much detail as possible. Please make sure that your enhancement is distinct from any other requested or implemented features.

	If you find a similar enhancement that has already been opened as an issue, please either leave a comment OR if you open a new issue, reference the other enhancement issue and be sure to note how yours is different.

* **good first issue** These are issues that are a good way to start contributing.

	They may be no-code issues (see above), or more straightforward coding tasks.

## Make a change

Once you've identified an issue that you feel you can contribute to, here's how you can make a change to our repository.

1. Describe what you're planning to do as a comment to an issue. Sometimes this can mean making a new issue, such as if you found a bug that you plan to fix for us (thanks!).

	Check in with one of the o-factor development team members to make sure you're not overlapping with any current work that is underway, and so that everyone can be on the same page.

2. [Fork](https://help.github.com/articles/fork-a-repo/) (aka make a copy of) the o-factor repository to your own Github account.

	You can now do whatever you want with this copy of the project, and you won't mess up anyone else's work in the master repository by accident.

	Make sure to [keep your fork up to date with the master repository](https://github.com/KirstieJane/STEMMRoleModels/wiki/Syncing-your-fork-to-the-original-repository-via-the-browser).

3. Make the changes we've discussed.

	Try to keep the changed focused rather than changing lots of things at once. If you do make changes to lots of things, please create [separate branches](https://help.github.com/articles/creating-and-deleting-branches-within-your-repository/) for different updates.

4. Submit a [pull request](https://help.github.com/articles/about-pull-requests/).

	Someone in the o-factor development team will review your changes, discuss them with you if necessary, and hopefully merge them in! Note that you don't have to be ready to merge to make a pull request. Early submissions of pull requests can help us keep track of progress and help you to get earlier feedback.

**Yay! Thanks for your help!**

## Attribution
The format and content of these guidelines were adapted from those of the [WhitakerLab](https://github.com/WhitakerLab).
