function [status_colormap, TC_colormap] = update_colormap()
% UPDATE_COLORMAP Update user defined colormaps.
%
% USAGE:
%    [status_colormap, TC_colormap] = update_colormap()
%
% OUTPUTS:
%    status_colormap: matrix
%        color table for the signal status plot. 
%    TC_colormap: matrix
%        color table for the aerosol target classification plot.
%
% HISTORY:
%    - 2021-06-13: first edition by Zhenping
%
% .. Authors: - zhenping@tropos.de

%% colormao for signal status
status_colormap = [[0, 128, 255];
                   [255, 0, 128];
                   [128, 128, 128]] / 255;

%% colormap for target classification
TC_colormap = [1.0000,1.0000,1.0000;
0.9000,0.9000,0.9000;
0.6000,0.6000,0.6000;
0.8667,0.8000,0.4667;
0.9059,0.4275,0.1804;
0.5333,0.1333, 0;
0, 0, 0;
0.4706,0.1098,0.5059;
0.2275,0.5373,0.7882;
0.7059,0.8667,0.9686;
0.0667,0.4667,0.2000;
0.5255,0.7333,0.4157];

%% colormap for chiljet
chiljet = [...
223  223  223; ...
209  209  227; ...
195  195  232; ...
181  181  236; ...
168  168  241; ...
154  154  245; ...
140  140  250; ...
127  127  255; ...
111  111  255; ...
 95   95  255; ...
 79   79  255; ...
 63   63  255; ...
 47   47  255; ...
 31   31  255; ...
 15   15  255; ...
  0    0  255; ...
  0   19  243; ...
  0   39  231; ...
  0   59  219; ...
  0   79  207; ...
  0   99  195; ...
  0  119  183; ...
  0  139  171; ...
  0  159  159; ...
  0  171  139; ...
  0  183  119; ...
  0  195   99; ...
  0  207   79; ...
  0  219   59; ...
  0  231   39; ...
  0  243   19; ...
  0  255    0; ...
 31  255    0; ...
 63  255    0; ...
 95  255    0; ...
127  255    0; ...
159  255    0; ...
191  255    0; ...
223  255    0; ...
255  255    0; ...
255  239    0; ...
255  223    0; ...
255  207    0; ...
255  191    0; ...
255  175    0; ...
255  159    0; ...
255  143    0; ...
255  127    0; ...
255  111    0; ...
255   95    0; ...
255   79    0; ...
255   63    0; ...
255   47    0; ...
255   31    0; ...
255   15    0; ...
255    0    0; ...
239    0   15; ...
223    0   31; ...
207    0   47; ...
191    0   63; ...
175    0   79; ...
159    0   95; ...
143    0  111; ...
127    0  127]./256

libFolder = fileparts(mfilename('fullpath'));
disp('Saving status_colormap: OK');
save(fullfile(libFolder, 'status_colormap.mat'), 'status_colormap');
disp('Saving TC_colormap: OK');
save(fullfile(libFolder, 'TC_colormap.mat'), 'TC_colormap');
disp('Saving chiljet_colormap: OK');
save(fullfile(libFolder, 'chiljet_colormap.mat'));

end