---
title: '2.8. Weiterentwicklung Graphical User Interface des CVMA DRM'
taxonomy:
    category:
        - docs
---

## **Abschlussbericht “Weiterentwicklung Graphical User Interface des CVMA Digitale Ressourcen Managers (DRM) für die Erfassung von Bilddaten sowie anderen nicht-textuellen Forschungsdaten”**

Der Digitale Ressourcen Manager (DRM) wird als Metadatenerfassungstool für das Corpus Vitrearum Medii Aevi Deutschland ([CVMA](https://corpusvitrearum.de/)) entwickelt, einem interdisziplinären Forschungsvorhaben mit Arbeitsstellen in Freiburg (Akademie der Wissenschaften Mainz) und Potsdam (Berlin-Brandenburgische Akademie der Wissenschaften). Aufgrund seiner Mitgliedschaft im Internationalen Corpus Vitrearum ist das CVMA ebenfalls Participant im Konsortium der Nationalen Forschungsdateninfrastruktur für Forschungsdaten materieller und immaterieller Kulturgüter (NFDI4Culture). Somit konnten im Jahr 2022 für die Entwicklung einer nutzerdienlichen grafischen Oberfläche erfolgreich Drittmittel über die NFDI4Culture im Rahmen des [zweiten Community-Forums „(Weiter-)Entwicklung von Research Tools & Data Services“](https://nfdi4culture.de/de/nachrichten/zweites-forum-weiter-entwicklung-research-tools-data-services-bericht.html) eingeworben werden. Mit der Umsetzung wurde 2023 Tanja Kuppel beauftragt.

Der DRM wurde entsprechend der Projektanforderungen des CVMA zur Erschließung von Bilddaten vorwiegend mittelalterlicher Glasmalereien in Deutschland nach einer projekteigenenen [XMP-Metadatenspezifikation](https://lod.academy/cvma/ns/xmp/) durch uns in enger Abstimmung mit dem Akademievorhaben konzipiert. Die hauptsächlichen Anforderungen an eine Bildverwaltung umfassen neben einer Bildergalerie, hauptsächlich Funktionalitäten als Recherche- und Erfassungsumgebung, mit der Metadaten einer projekteigenen Spezifikation, die neben stan dardisierten auch Elemente eines eigenen Namensraums hat, in die Header der Bilddatei geschrieben werden können. Weitere wichtige Punkte für eine Entwicklung sind die Anpassbarkeit an eigene Spezifikationen über die bisherigen Anwendungskontexte hinaus, die Möglichkeit, kontrollierte Vokabulare sowie vordefinierte Auswahllisten einzubinden, die Stapelverarbeitung großer Datenmengen, aber auch die Verarbeitung und Anzeige großer Dateien. Klassische Tools, z. B. FotoStation, müssen aufgrund der langsamen Performanz und der Ressourcenintensität des Datentransfers lokal ausgeführt werden, da für den Metadatenabruf jeweils die große Bilddatei aufgerufen werden muss. Das erschwert kollaboratives Arbeiten und erfordert permanente Datentransfers sowie komplexe Backupstrategien. Der DRM verzichtet auf den Einsatz einer Datenbank, in dem u. a. über entsprechend konfigurierte JSON-Dateien auf die Bilddateien in einer durch das Projekt vorgegebenen Ordnerstruktur zugegriffen wird. Diese Ordnerstruktur wird in einer weiteren JSON-Datei automatisch durch Abfrage aller Pfade erzeugt. Dies ist notwendig, da die benötigten Datensätze diese Informationen in der Regel noch nicht enthalten und i. d. R. nur technische Metadaten durch Digitalaufnahme, Scanverfahren und Bildbearbeitung besitzen. Dies ist bei CVMA der Fall, da hier direkter Zugriff auf die Daten nötig ist. Es wird auch eine wesentlich schlankere Variante des DRM angestrebt, bei der die Daten direkt eingegeben werden können, ohne eine Verbindung zu einem Server zu haben.

In der Regel werden die Metadaten in den jeweiligen digitalen Ressourcen eindeutig zugewiesenen JSON-Dateien gespeichert, bei Bedarf erfolgt das Schreiben dieser als [XMP, EXIF oder IPTC](https://manual.zoner.com/de/information-38c17dd/) in die Bilddateien. Eine Implementierung eigener Namespaces lässt sich ebenfalls umsetzen. Durch die Speicherung der Metadaten in JSON-Dateien ist der Zugriff auf diese schnell möglich, was bei der Anwendung eines webbasierten Tools essentiell ist. Große Bilddateien werden als in der Dateigröße reduzierte sRGB-JPG angezeigt, der Zugriff auf die großen Bilddateien muss explizit erfolgen. Der DRM wurde in erster Linie nach den Anforderungen des CVMA entwickelt, jedoch lässt er sich durch die Community, z. B. durch andere, Bildbestände verarbeitende Projekte nachnutzen. Der DRM wird niedrigschwellig durch JSON-Dateien konfiguriert und lässt sich somit schnell und individuell an Projektbedürfnisse, neu hinzugekommene Metadatenfelder oder Auswahllisten sowie Anforderungen an die Anzeige anpassen.

Für das Webdesign und die Frontend-Entwicklung wurde nach ersten Gesprächen ein Benutzeroberflächen-Design mit Vorschlägen basierend auf den Nutzeranforderungen des CVMA vorgestellt, die in der nächsten Phase immer weiter konkretisiert wurden.

Nach Abnahme durch das Vorhaben begannen die Entwicklungsarbeiten. Zuerst wurde der Technologiestack an die Anforderungen moderner, performanter Web-App-Konzepte angepasst (die bisher verwendeten jquery Bibliotheken stellten sich als veraltet heraus). Hierbei wurde auf das JavaScript-basierte Framework [Nuxt.js](%20https://nuxt.com/) – ein Higher-Level Framework basierend auf [Vue.js](https://vuejs.org/) – zurückgegriffen. Frontend-Frameworks auf der Basis von JavaScript sind gerade für Benutzeroberflächen komplexerer Webanwendungen wie dem DRM geeignet, deren Daten stets aktuell gehalten werden und manipulierbar sein müssen.

Bei der Überarbeitung der technischen Basis des DRM konnte auch auf die Erfahrungen der Vorgängerversion zurückgegriffen werden. Für die grafische Entwicklung der Benutzeroberfläche wurde zusätzlich Nuxt UI implementiert, eine User Interface(UI) Komponenten Bibliothek für Nuxt.js. Die anpassbaren UI-Komponenten verkürzten die Entwicklungszeit des Frontends wesentlich und garantierten zudem eine barrierefreie Gestaltung der Web-Applikation.

Nach der Vorstellung eines Prototypen begann die erste Testphase durch das Vorhaben im Winter 2023/2024. Die Auswertung zeigte ein sehr positives Bild, wobei noch einige größere Schwächen offenbar wurden, die aber in der folgenden Projektphase behoben werden konnten.

Im letzten Teil der Entwicklung wurde der Fokus auf die Nachnutzung des DRM für andere Projekte gelegt. Die Entwicklungsumgebung, die speziell für das CVMA Projekt implementiert wurde, ist zu komplex und individuell, um sie auf mögliche Zielgruppe des DRM (wie bspw. einzelne Forschende, die nicht an Institute gebunden sind, die eine große Infrastruktur bereitstellen, oder kleine Museen) übertragen zu können. Ferner soll der DRM auch für andere Konzepte offen sein (z. B. das [Metadatenaustauschformat LIDO](https://cidoc.mini.icom.museum/working-groups/lido/lido-overview/about-lido/what-is-lido/) oder [GeoJSON](https://geojson.org/)).

Auch soll es künftig möglich sein, den DRM unabhängig von vordefinierten Servern zu nutzen. Mit Nuxt.js in Kombination mit einem git-basierten Workflow – z. B. mit Hilfe von Version Control Systemen wie GitLab oder GitHub – lässt sich die Web-App jederzeit erweitern, redaktionell bearbeiten und nach Bedarf beliebig auf eigenen Servern oder Serverless-Plattformen statisch ausrollen.

Der DRM kann unter [https://gitlab.com/digital-resource-manager/release](https://gitlab.com/digital-resource-manager/release) heruntergeladen werden. Für Einrichtungen, die in Archiven Datenbestände mit Bildern besitzen, deren Metadaten nur in den Digitalisaten liegen, bietet der DRM eine Analysemöglichkeit. Wichtig ist, dass es nicht primär darum geht, Daten wieder in das Bild zu schreiben, was den heutigen Digitalisierungsrichtlinien widerspricht, sondern Daten aus den Digitalisaten zu retten und neu verfügbar zu machen. Die Datenbestände können ordnerweise ausgelesen werden, sowohl mittels dem Standwerkzeug [ExifTool](https://exiftool.org/%20), als auch über direkten Zugriff auf die Objekte, um eventuell verunreinigte Daten und XMP-Mehrfachcontainer zu extrahieren. Die ausgelesenen Daten können als JSON-Dateien abgespeichert werden.

**Ansprechpartner:innen:**

**Konzeption/Inhaltlich**  
Anja Gerber  
Klassik Stiftung Weimar | NFDI4Objects  
Querschnittsdirektion Digitale Transformation und Innovationsmanagement  
[anja.gerber@klassik-stiftung.de](mailto:anja.gerber@klassik-stiftung.de)

**Konzeption/Technisch**  
Dr. Gordon Fischer  
Berlin-Brandenburgische Akademie der Wissenschaften  
TELOTA | IT/DH  
[gordon.fischer@bbaw.de](mailto:gordon.fischer@bbaw.de)

**Webdesign und Frontendentwicklung**  
Tanja Kuppel  
[https://tanjakuppel.netlify.app/](https://tanjakuppel.netlify.app/)
