---
title: '2.6. Weiterentwicklung der Softwareplattform Kompakkt'
taxonomy:
    category:
        - docs
---

Im Rahmen der NFDI4Culture-Förderung wurde die webbasierte Softwarelösung Kompakkt, welche die kollaborative und multimediale Bereitstellung, Annotation, Austausch und Entdeckung von 3D-Objekten im Browser ermöglicht, im Jahr 2023 kontinuierlich weiterentwickelt. Das Kompakkt-Team legte den Fokus im vergangenen Jahr auf die folgenden Schwerpunkte:

### Refaktorisierung der Codebasis und Plugin-System

Für die Weiterentwicklung der Codebasis wurde eine umfassende Refaktorisierung durchgeführt, um deren Zukunftsfähigkeit und gute Wartbarkeit sicherzustellen. In diesem Kontext wurde die Entwicklung eines modularen Plugin-Systems initiiert, das es Institutionen ermöglichen soll, Kompakkt individuell an ihre Bedürfnisse anzupassen. Der Kern der Anwendung bleibt dabei stabil und gewartet, während Zusatzfunktionen flexibel als Plugins geladen werden können. Auf diese Weise profitieren alle Nutzenden von einem robusten Fundament und können gleichzeitig von spezifischen Erweiterungen profitieren. Im Zuge der Refaktorisierung wurde die Anwendung auf die neueste Angular-Version 17 aktualisiert.

### Erweiterung des Testframeworks

Das bereits im Jahr 2022 eingeführte Framework für End-to-End- und Integrationstests wurde im vergangenen Jahr weiter ausgebaut. Dadurch kann die  
Stabilität und Funktionalität von Kompakkt auch bei künftigen Erweiterungen und Anpassungen umfassend geprüft werden. Die Tests bilden eine solide Grundlage für eine kontinuierliche und qualitätsgesicherte Weiterentwicklung der Plattform, die insbesondere in Anbetracht der Zusammenführung der Semantic Kompakkt und Kompakkt Unterschiede von Bedeutung ist.

### Verbesserter Support für mobile Endgeräte

Nach einer umfassenden Evaluierung der Benutzerfreundlichkeit auf Smartphones und Tablets werden derzeit optimierte, mobile Versionen der relevantesten Seiten entwickelt. In Zusammenarbeit mit dem Open Science Lab der TIB Hannover entsteht so eine plattformübergreifende Lösung, die den Zugriff auf 3D-Objekte von überall aus ermöglicht.

### Messwerkzeuge und Multi-Punkt-Annotationen

Auf Basis von Nutzerstudien und Anfragen wurde ein Schwerpunkt auf die Integration präziser Messwerkzeuge in den 3D-Viewer gelegt. Zu diesem Zweck wurde eine Technologie für Multi-Punkt-Annotationen entwickelt, die nicht nur Längenmessungen, sondern perspektivisch auch Flächen- oder Volumenmessungen ermöglicht. In enger Zusammenarbeit mit der IIIF 3D Working Group entwickelt das Team standardisierte Formate für Szenen und Annotationen im 3D-Raum. Dadurch lassen sich Messungen plattformübergreifend austauschen und in Kompakkt sowie anderen 3D-Werkzeugen nutzen. Aus den Nutzerstudien ging hervor, dass Messwerkzeuge nicht für alle, die Kompakkt nutzen, von Relevanz sind. Diese werden daher in das entstehende Plugin-System ausgelagert.

### Ausbau des User-Supports

Der Austausch mit der Community stellte auch im Jahr 2023 einen wesentlichen Fokus dar. Neben Workshops und Nutzertests bot das Team Support per E-Mail sowie Diskussionskanäle auf GitHub und GitLab an. Durch den kontinuierlichen Dialog mit Anwendenden konnten Verbesserungsvorschläge aufgenommen und in die Produktentwicklung eingebunden werden. Mit den Weiterentwicklungen des vergangenen Jahres ist Kompakkt für die Zukunft  
bestens gerüstet. Das Entwicklerteam arbeitet mit Hochdruck an der nahtlosen Integration aller neuen Funktionen in die Plattform. Im Jahr 2024 stehen die  
Zusammenführung von Kompakkt und Semantic Kompakkt sowie die finale Ausrollung des Plugin-Systems auf der Agenda. Wir freuen uns darauf, die Community auch in Zukunft bei der kollaborativen 3D-Visualisierung und -Annotation zu unterstützen.

**Øyvind Eide**
