---
title: '2.4. Musikwissenschaftliches Mark-Up mit dem mei-friend Editor'
taxonomy:
    category:
        - docs
---

## Zum Projekt

[*mei-friend*](https://mei-friend.mdw.ac.at/) ist ein Editor für MEI, der insbesondere die ‘letzte Meile’ des Musikkodierungsprozesses unterstützen und erleichtern soll. Bisher umfasst dies die Korrektur von Kodierungen, die durch Konvertierung aus anderen Formaten oder mithilfe optischer Musikerkennung erzeugt wurden. Das Tool ist eine browserübergreifende Webanwendung, die daher keine weitere Installation von Software erfordert. Es integriert den webbasierten Code-Editor CodeMirror und das Notensatz-Tool Verovio in einer benutzerfreundlichen grafischen Oberfläche, die eine miteinander verbundene Navigation und Bearbeitung der MEI-Kodierung, sowohl als XML als auch über die von Verovio gerenderte grafische Notation ermöglicht. Vor allem bietet *mei-friend* eine Fülle zusätzlicher Funktionen zur Vereinfachung der Arbeitsabläufe rund um MEI, darunter schemabasierte Code-Vervollständigung, GitHub-Integration, Tastaturkurzbefehle, eine einfach zu bedienende Schnittstelle zu den MEI-Richtlinien und ein Verzeichnis öffentlich lizenzierter MEI-Kodierungen. Die Codebase von *mei-friend* ist öffentlich unter [github.com/mei-friend/mei-friend](https://github.com/mei-friend/mei-friend) verfügbar.  
Ziel des Projektes war die Erweiterung der bestehenden Annotationsfunktionen und deren Ergänzung durch Funktionen zur Arbeit mit editorischem Mark-Up.

## Ergebnisse

### 1. Annotationen

Ein Projektziel bestand in der Erweiterung der Annotationsfunktionen. Angestrebt war, den bestehenden Support von Inline-Annotationen, die als `<annot>`-Elemente innerhalb der MEI-Datei erfolgen, um Funktionen zur Integration von Standoff-Annotationen zu ergänzen, die unabhängig von der annotierten Datei im RDF-Format vorgehalten werden. Ein wesentlicher Baustein dieser Funktionalität besteht in der Anbindung des *mei-friend* an dezentrale nutzerverwaltete Linked-Data-Speicher (sog. 'Personal Online Stores', auch Pods genannt) mittels Technologien, die im Rahmen des Solid Projektes entwickelt wurden. Die Angleichung der Datenmodelle (Mapping) von Inline- und Standoff-Annotationen wurde als Thema in MEI Linked Data IG getragen. Die geplante Integration von Solid Pods zur Speicherung von Standoff-Annotationen ist erfolgt. Zudem wurden die Projektbeteiligten eingeladen, am Abschluss-Workshop des Projektes "Beethoven in the House" teilzunehmen. In dessen Rahmen wurde ein Konzept zur Einbindung der Music Annotation Ontology in *mei-friend* entwickelt, um formatübergreifende Verweise auf musikalische Sinneinheiten zu ermöglichen. Eine grundlegende Implementierung der Funktionalität ist ebenfalls erfolgt.

### 2. Editorisches Markup

Die zu Projektbeginn bereits bestehende Funktionalität zur Auszeichnung von Passagen als editorische Hinzufügung wurde verbessert und erweitert. Aktuell wird nun die Verwendung von deskriptivem und transkriptionsspezifischen Mark-Up unterstützt. In der Notationsansicht selektierte Elemente werden nun nicht mehr einzeln sondern als Gruppen mit Mark-Up umschlossen. Mit der Implementierung von `<choice>` und `<subst>` wird zum ersten Mal in einem MEI-Editor Mark-Up für alternative Lesarten unterstützt.

### 3. User Studies

Ein wesentliches Anliegen des Projektes war die Interaktion mit Nutzer:innen, um die Entwicklung der angestrebten Funktionalitäten zu informieren. Begleitend zu den Projektaktivitäten wurden daher mehrere Workshops mit und um den *mei-friend* herum durchgeführt und eine kleine Interviewserie mit Musikeditor:innen zu musikeditorischen Arbeitsprozessen und den ihnen inhärenten Herausforderungen durchgeführt. Die Erbnisse der Interviewserie konnte im Rahmen der "Digital Libraries for Musicology 2023" präsentiert und als Full Paper veröffentlicht werden.

### 4. Implementierung der Erweiterungen in die Benutzeroberfläche

Der Hauptteil der Arbeiten fand im Zuge der Implementierung der Erweiterungen in die Benutzeroberfläche statt. Die durch das Projekt angestoßene Interviewstudie, sowie Workshops und Präsentationen dienten als zentrale Entscheidungsgrundlage und informierten die Erweiterungen, die an der Benutzeroberfläche vorgenommen wurden:

*   Personalisierbares Farb-Highlighting für Mark-Up in der Notationsansicht wurde implementiert.
*   Menü zur Auswahl von möglicher für Mark-Up verantwortliche Personen anhand des MEI-Headers wurde umpositioniert.
*   Ausbau des Annotation Panels zum Enrichment Panel, umfasst nun Funktionen für Annotationen und Markup in jeweiligen Tabs.
*   Liste von Annotationen wurde erweitert und enthält nun auch Markup. Damit ist sie das zentrale Element, um in einer mit Markup und Annotationen angereicherten MEI-Datei zu navigieren.
*   Die Annotations-Funktion "Describe"/"Beschreiben" wurde in der Übersichtsliste als Operation für Mark-Up-Elemente implementiert um die Erstellung editorischer Kommentare zu erleichtern.
*   Eine Funktion zum Umschalten zwischen alternativen Lesarten wurde in der Navigationsleiste des Notation-Panels implementiert.

Eine im Verlauf der Projektarbeiten identifizierte Herausforderung besteht noch immer in der Konzeptionierung grundlegender Interaktionsmuster für die Arbeit mit mehreren parallelen Textebenen. Hier konnten bisher nur erste Ansätze entwickelt werden. Zur weiteren Ausarbeitung und Optimierung dieser Ansätze sind zusätzliche User-Tests und Entwicklungsarbeiten unerlässlich.

## Ausblick

Die Entwicklungsversion ist seit September 2023 als öffentlich zugängliche [Testversion](https://testing.mei-friend.mdw.ac.at/) verfügbar. Der Merge in die parallel weiterentwickelte Hauptversion steht noch aus und ist für 2024 geplant. Die Kooperation zwischen den Projektbeteiligten wird fortgeführt. Es wurden hierzu bereits gemeinsam mit der sukzessiven Implementierung von UI-Tests begonnen. Im Rahmen der Entwicklungen wurden zudem Potenziale zur Verbesserung der Code-Base und der Benutzeroberfläche identifiziert. Die bisher ausstehende Unterstützung von Apparatus-Elementen zur Kodierung von Lesarten verschiedener Quellen befindet sich in der Konzeptionierung.

**Anna Plaksin, David M. Weigl & Werner Goebl**
