---
title: '2.3. MusicXML Integration in meico'
taxonomy:
    category:
        - docs
---

[MusicXML](https://www.musicxml.com/) ist ein Datenformat zur Beschreibung von musikalischem Notentext. Nach dem MIDI-Format ist es das am weitesten verbreitete und Software-seitig unterstützte Musikdatenformat. Der Standard für Digitale Musikeditionen, [MEI](https://music-encoding.org/), wird hingegen nur wenig unterstützt. Außer der Software [Verovio](https://www.verovio.org/index.xhtml) ist der Import von MEI-Daten in eines der etablierten und kommerziellen Notensatzprogramme nicht möglich. Der Export wird immerhin in Form von Plugins für Sibelius und MuseScore oder via Verovio ermöglicht.

In diesem Projekt wurde ein MusicXML-API (Application Programming Interface) nun in das Ökosystem des MEI Converter Frameworks [meico](%20https://github.com/cemfi/meico) integriert und damit die Grundlage für unterschiedlichste Konvertierungen von und zu MusicXML gelegt.  
meico bietet die derzeit detaillierteste und umfangreichste Konvertierung von MEI zu MIDI sowie etlichen anderen Formaten an und implementiert auch die offizielle API für das Datenformat MPM (Music Performance Markup). Meico ist auch ein Baustein im Online-Konvertierungsdienst MEIGarage. Die Integration von MusicXML wäre hier also keine Insellösung sondern würde etliche neue Konvertierungspfade eröffnen, die aus Verovio heraus oder mit den Plugins so nicht erreichbar wären.

Es musste keine von Grund auf neue API für MusicXML entwickelt werden. Hierfür konnte die ausgereifte und vollumfängliche Java-Implementierung [ProxyMusic](https://github.com/Audiveris/proxymusic) in der Version 3.0.1 genutzt werden. Die noch aktuellere Version 4.0.1 wurde ebenfalls getestet, konnte aber nicht verwendet werden, da sie mit der für meico gültigen Rückwärtskompatibilität bis zu Java 1.8 gebrochen hätte. Ein künftiges Update ist aber nicht ausgeschlossen und einfach möglich. ProxyMusic kommt mit Funktionen zum Marshalling und Unmarshalling sowie mit hunderten Java-Klassen und Funktionen zur Erstellung und Bearbeitung von MusicXML-Daten. Somit ist keine aufwendige Low-Level-XML-Verarbeitung wie in anderen Umgebungen mehr notwendig. Wird meico in eine Software-Entwicklung eingebunden, steht sofort auch der komplette Funktionsumfang von ProxyMusic zur Verfügung.

In meico existierte bereits eine Platzhalterklasse für MusicXML-Daten. Diese wurde nun ersetzt durch eine neue Implementierung, die den Standards der anderen Datentypen folgend, alle entsprechenden Konstruktoren und Methoden für die Ausgabe, Validierung, Verarbeitung und Speicherung von XML-Daten sowie ein XSLT-Interface enthält. Ein MusicXML-Objekt im meico kann sowohl aus unkomprimierten (.xml, .musicxml) als auch komprimierten (.mxl) MusicXML-Dateien instanziiert werden. Auch für die Speicherung werden beide Typen unterstützt. Ferner ist die Instanziierung auch aus String-Daten, XOM Document-Daten und InputStreams möglich.

Ein MusicXML-Dokument kann eine von drei möglichen Formen haben, score-partwise, score-timewise und opus. Alle drei werden unterstützt. Lediglich für das Marshalling und Unmarshalling von score-timewise MusicXML bestehen seitens des ProxyMusic Frameworks Einschränkungen. Nicht nur, um diese zu umgehen, wurden zwei Methoden implementiert, um score-timewise zu score-partwise Daten zu konvertieren und umgekehrt. Die beiden unterschiedlichen Modi zur Datenstrukturierung bringen auch Vorteile bei unterschiedlichen Konvertierungen – z. B. gibt es äquivalente Datenstrukturen auch in MEI.

Für die Konvertierungen MEI-MusicXML, MusicXML-MEI und MusicXML-MSM/MPM wurden entsprechende Methoden und Converter-Klassen angelegt. Die MEI-MSM/MPM-Konvertierung wurde aus der MEI-Klasse in eine eigenständige Converter-Klasse herausgezogen, um den Programmcode sinnvoll zu modularisieren. Im Zuge der Einarbeitung und Tests sind die Konvertierungen erster MusicXML-Elemente zu MSM/MPM-Darstellungen bereits umgesetzt.

Der neue Datentyp und dessen Funktionalitäten sind auch in das Benutzungs-Interface der graphischen Anwendung meicoApp integriert worden. Schließlich sind alle bisher umgesetzten Funktionalitäten auch getestet worden. Eine vollständige Dokumentation der neuen Teile des meico-Frameworks ist Teil der offiziellen JavaDoc-Dokumentation im meico GitHub-Repositorium. Auch eine *MusicXML Coverage Documentation* wurde entsprechend der *MEI Coverage Documentation* angelegt.

Alle Grundlagen sind nun vorhanden, damit sich die weiteren Entwicklungsarbeiten ganz auf die eigentlichen Konvertierungsfunktionen konzentrieren können.

**Axel Berndt**
