# Introduction

The climate system is composed of many interacting components (e.g., ocean, atmosphere, ice) and described by complex nonlinear equations. To simulate, understand and predict climate, these equations are solved numerically under a number of simplifications, therefore leading to errors. The errors are the result of numerics used to solve the equations and the lack of appropriate representations of processes occurring below the resolution of the climate model grid (i.e., subgrid processes).

The goal of this book is to conceptualize the problems associated with climate models within a simple and computationally accessible framework. We will introduce the readers to climate modeling by using a simple tool, the {cite}`Lorenz1995` (L96) two-timescale model. We discuss the numerical aspects of the L96 model, the approximate representation of subgrid processes (known as parameterizations or closures), and simple data assimilation problems (a data-model fusion method). We will then use the L96 results to demonstrate how to learn subgrid parameterizations from data with machine learning, and then test the parameterizations offline (apriori) and online (aposteriori), with a focus on the interpretability of the results.

The book was created by and as part of [M<sup>2</sup>LInES](https://m2lines.github.io/), an international collaboration supported by [Schmidt Futures](https://www.schmidtfutures.com/), to improve climate models with scientific machine learning. The goal for this book was for our team to work together and learn from each other; in particular, to get up to speed on the key scientific aspects of our collaboration (parameterizations, machine learning, data assimilation, uncertainty quantification) and to develop new ideas. Ultimately, we are happy to share these resources with the scientific community, to introduce our research ideas and foster the use of machine learning techniques for tackling climate science problems.
