import arrivaltimes
# other imports ...

Dataset = namedtuple('Dataset', 'run save path')
datasets = {
	'gajjar' : Dataset(True, True, '/path/to/data/gajjar2018/'),
	# Other datasets
}

if datasets['gajjar'].run:
	prefix = datasets['gajjar'].path
	files = {
		'11B.npz': {
			'crop': (1484, 1940),
			'downfactors': (5,4),
			't_filter_factor':1,
		},
		# Other bursts
	}
	save = datasets['gajjar'].save
	results = []
	targetDM = DM_FRB20121102A
	for filename, kwargs in files.items():
		filename = f'{prefix}{filename}'
		burst_results = arrivaltimes.measureburst(
			filename,
			outdir='measurements/frb20121102A/gajjar2018/',
			show=not save,
			save=save,
			**kwargs
		)
		for row in burst_results:
			results.append(row)

	resultsdf = pd.DataFrame(data=results, columns=arrivaltimes.results_columns).set_index('name')
	fileout = f"results.csv"
	if save:
		resultsdf.to_csv(fileout)
		print(f"Saved {fileout}")
